/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence;

import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.util.DisplayMetrics;
import io.scanbot.sdk.process.ImageFilterType;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import net.doo.snap.entity.Page;
import net.doo.snap.entity.RotationType;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.persistence.PageFactory;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.util.bitmap.BitmapLruCache;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.snap.PolygonHelper;
import org.apache.commons.io.IOUtils;

public class PictureProcessor {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final float FILTERED_PREVIEW_SCALE = 0.65f;
    private static final Logger logger = LoggerProvider.getLogger();
    private BitmapLruCache bitmapLruCache;
    private PageFactory pageFactory;
    private PageStoreStrategy pageStoreStrategy;
    private Resources resources;
    private SharedPreferences preferences;

    @Inject
    public PictureProcessor(PageFactory pageFactory, PageStoreStrategy pageStoreStrategy, Resources resources, SharedPreferences preferences, BitmapLruCache bitmapLruCache) {
        this.pageFactory = pageFactory;
        this.pageStoreStrategy = pageStoreStrategy;
        this.resources = resources;
        this.preferences = preferences;
        this.bitmapLruCache = bitmapLruCache;
    }

    public Page processBytes(byte[] image, int imageOrientation) throws IOException {
        DisplayMetrics displayMetrics = this.resources.getDisplayMetrics();
        PageFactory.Result result = this.pageFactory.buildPage(image, displayMetrics.widthPixels, displayMetrics.heightPixels);
        Page page = result.page;
        page.setRotationType(RotationType.getByDegrees((int)imageOrientation));
        if (this.preferences.contains("LAST_USED_FILTER")) {
            page.setImageFilterType(ImageFilterType.getByCode((int)this.preferences.getInt("LAST_USED_FILTER", ImageFilterType.NONE.getCode())));
        }
        ContourDetector detector = new ContourDetector();
        detector.detect(result.preview);
        List polygonF = detector.getPolygonF();
        List polygon = detector.getPolygon();
        if (!polygon.isEmpty() && PolygonHelper.checkPolygonSize(polygon)) {
            page.setPolygon(polygonF);
        }
        this.generateOptimizedPreview(this.pageStoreStrategy, page, result.preview, detector);
        return page;
    }

    private void generateOptimizedPreview(PageStoreStrategy pageStoreStrategy, Page page, Bitmap preview, ContourDetector detector) throws IOException {
        List polygon = page.getPolygon();
        if (!polygon.isEmpty()) {
            final Bitmap bitmap = detector.processImageF(preview, polygon, page.getImageFilterType().getCode());
            final String path = pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED_PREVIEW).getPath();
            this.bitmapLruCache.put((Object)path, (Object)bitmap);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(path);
                        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
                    }
                    catch (IOException e) {
                        try {
                            logger.logException((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fos);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((OutputStream)fos);
                    }
                    IOUtils.closeQuietly((OutputStream)fos);
                }
            });
            PictureProcessor.generateFilteredPreviewAsync(pageStoreStrategy, page, preview, detector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateOptimizedPreview(PageStoreStrategy pageStoreStrategy, Page page, ContourDetector detector) throws IOException {
        block2: {
            List polygon = page.getPolygon();
            if (polygon.isEmpty()) break block2;
            String previewPath = pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.PREVIEW).getPath();
            Bitmap preview = BitmapFactory.decodeFile((String)previewPath);
            Bitmap bitmap = detector.processImageF(preview, polygon, page.getImageFilterType().getCode());
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED_PREVIEW));
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
            PictureProcessor.generateFilteredPreviewAsync(pageStoreStrategy, page, preview, detector);
        }
    }

    private static void generateFilteredPreviewAsync(final PageStoreStrategy pageStoreStrategy, final Page page, final Bitmap preview, final ContourDetector detector) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PictureProcessor.generateFilteredPreview(pageStoreStrategy, page, preview, detector);
                }
                catch (IOException e) {
                    logger.logException((Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateFilteredPreview(PageStoreStrategy pageStoreStrategy, Page page, Bitmap preview, ContourDetector detector) throws IOException {
        Matrix matrix = new Matrix();
        matrix.setScale(0.65f, 0.65f);
        Bitmap downscaledPreview = Bitmap.createBitmap((Bitmap)preview, (int)0, (int)0, (int)preview.getWidth(), (int)preview.getHeight(), (Matrix)matrix, (boolean)true);
        for (ImageFilterType imageFilterType : ImageFilterType.values()) {
            Bitmap processed = detector.processImageF(downscaledPreview, page.getPolygon(), imageFilterType.getCode());
            FileOutputStream fos = new FileOutputStream(pageStoreStrategy.getFilteredPreviewFile(page.getId(), imageFilterType));
            try {
                processed.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fos);
            }
        }
    }
}

