/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence.cleanup;

import android.util.Pair;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider;
import net.doo.snap.process.ProcessingInfoProvider;
import net.doo.snap.process.util.DocumentDraft;

public class Cleaner {
    private final UnreferencedSourcesProvider unreferencedSourcesProvider;
    private final PageStoreStrategy pageStoreStrategy;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final ProcessingInfoProvider processingInfoProvider;
    private final PageStorageProcessor pageStorageProcessor;

    @Inject
    public Cleaner(UnreferencedSourcesProvider unreferencedSourcesProvider, PageStoreStrategy pageStoreStrategy, DocumentStoreStrategy documentStoreStrategy, ProcessingInfoProvider processingInfoProvider, PageStorageProcessor pageStorageProcessor) {
        this.unreferencedSourcesProvider = unreferencedSourcesProvider;
        this.pageStoreStrategy = pageStoreStrategy;
        this.documentStoreStrategy = documentStoreStrategy;
        this.processingInfoProvider = processingInfoProvider;
        this.pageStorageProcessor = pageStorageProcessor;
    }

    public void cleanUp() {
        for (Pair<String, String> docInfo : this.unreferencedSourcesProvider.getUnreferencedDocuments()) {
            this.documentStoreStrategy.eraseDocument((String)docInfo.first, (String)docInfo.second);
        }
        for (String pageId : this.unreferencedSourcesProvider.getUnreferencedSDKPages()) {
            this.pageStoreStrategy.erasePage(pageId);
        }
        for (DocumentDraft document : this.processingInfoProvider.getProcessedDocuments()) {
            this.cleanUpPagesData(document.getPages());
        }
    }

    public void cleanUpPagesData(net.doo.snap.entity.Page[] pages) {
        for (net.doo.snap.entity.Page page : pages) {
            this.pageStoreStrategy.eraseTempPageData(page.getId());
        }
    }

    public void cleanUpPagesData(Page[] pages) {
        for (Page page : pages) {
            this.pageStorageProcessor.erasePageData(page);
        }
    }

    public void cleanUpDocumentData(Document document) {
        this.documentStoreStrategy.eraseDocument(document.getId(), document.getName());
    }

    public void cleanUpDocumentThumbnail(Document document) {
        this.documentStoreStrategy.eraseDocumentThumbnail(document.getId());
    }
}

