/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process;

import java.io.File;
import java.io.IOException;
import net.doo.snap.entity.Document;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.process.ProcessorMonitor;

public class DocumentProcessorMonitor
implements ProcessorMonitor<Document> {
    private final DocumentStoreStrategy documentStoreStrategy;

    public DocumentProcessorMonitor(DocumentStoreStrategy documentStoreStrategy) {
        this.documentStoreStrategy = documentStoreStrategy;
    }

    @Override
    public void onProcessed(Document document) throws IOException {
        String docId = document.getId();
        String name = document.getName();
        File documentFile = this.documentStoreStrategy.getDocumentFile(docId, name);
        File thumbnailFile = this.documentStoreStrategy.getThumbnailFile(docId);
        document.setSize(documentFile.length());
        document.setThumbnailUri(thumbnailFile.getPath());
    }
}

