/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.ComposerFactory;
import net.doo.snap.process.compose.JpegComposer;
import net.doo.snap.process.compose.OcrComposer;
import net.doo.snap.process.compose.SimpleComposer;
import net.doo.snap.util.device.DeviceUtils;
import org.jetbrains.annotations.NotNull;

public class P2ComposerFactory
implements ComposerFactory {
    private final DeviceUtils deviceUtils;
    private final OcrComposer ocrComposer;
    private final SimpleComposer simpleComposer;
    private final JpegComposer jpegComposer;

    @Inject
    public P2ComposerFactory(DeviceUtils deviceUtils, OcrComposer ocrComposer, SimpleComposer simpleComposer, JpegComposer jpegComposer) {
        this.deviceUtils = deviceUtils;
        this.ocrComposer = ocrComposer;
        this.simpleComposer = simpleComposer;
        this.jpegComposer = jpegComposer;
    }

    @Override
    @NotNull
    public Composer composerForDocument(Document document) {
        if (this.isJpeg(document)) {
            return this.buildJpegOrDummyComposer(document);
        }
        OcrStatus status = document.getOcrStatus();
        if (status == OcrStatus.PENDING_FORCED) {
            return this.ocrComposer;
        }
        if (status == OcrStatus.PENDING_ON_CHARGER && this.deviceUtils.isDeviceOnCharger()) {
            return this.ocrComposer;
        }
        if (status == OcrStatus.PENDING) {
            return this.ocrComposer;
        }
        return this.buildSimpleOrDummyComposer(document);
    }

    private boolean isJpeg(Document document) {
        String lowerCaseName = document.getName().toLowerCase();
        return lowerCaseName.endsWith(".jpg") || lowerCaseName.endsWith(".jpeg");
    }

    private Composer buildSimpleOrDummyComposer(Document document) {
        if (document.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        return this.simpleComposer;
    }

    private Composer buildJpegOrDummyComposer(Document document) {
        if (document.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        return this.jpegComposer;
    }
}

