/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.util.DisplayMetrics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.doo.snap.entity.Page;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.process.compose.PageComposer;
import net.doo.snap.util.bitmap.BitmapUtils;
import org.apache.commons.io.IOUtils;

public class PageComposerImpl
implements PageComposer {
    private final ContourDetector contourDetector;
    private final PageStoreStrategy pageStoreStrategy;
    private final Resources resources;
    private PageComposer[] subComposers;

    public PageComposerImpl(ContourDetector contourDetector, PageStoreStrategy pageStoreStrategy, Resources resources, PageComposer ... subComposers) {
        this.contourDetector = contourDetector;
        this.pageStoreStrategy = pageStoreStrategy;
        this.resources = resources;
        this.subComposers = subComposers;
    }

    @Override
    public Bitmap compose(Page page, Bitmap draft) throws IOException {
        Bitmap result = this.createOptimized(page);
        if (!BitmapUtils.isBitmapValid((Bitmap)result)) {
            throw new IOException("Optimized bitmap can not be created");
        }
        this.createPreview(page, result);
        if (this.subComposers != null) {
            for (PageComposer composer : this.subComposers) {
                result = composer.compose(page, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap createOptimized(Page page) throws IOException {
        Bitmap bitmap;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inMutable = true;
        File optimizedFile = this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED);
        String optimizedPath = optimizedFile.getPath();
        Bitmap bitmap2 = bitmap = optimizedFile.exists() ? BitmapFactory.decodeFile((String)optimizedPath, (BitmapFactory.Options)options) : null;
        if (bitmap == null) {
            optimizedFile.delete();
            String originalPath = this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.ORIGINAL).getPath();
            bitmap = this.contourDetector.processImageF(originalPath, page.getPolygon(), page.getImageFilterType().getCode());
            FileOutputStream stream = new FileOutputStream(optimizedPath);
            try {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)stream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)stream);
            }
        }
        return bitmap;
    }

    private void createPreview(Page page, Bitmap optimized) throws IOException {
        DisplayMetrics displayMetrics = this.resources.getDisplayMetrics();
        int previewSize = Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels);
        this.saveRotatedAndScaledBitmap(page.getRotationType().getDegrees(), previewSize, optimized, this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED_PREVIEW));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRotatedAndScaledBitmap(int rotation, int maxDimension, Bitmap original, File file) throws FileNotFoundException {
        float scale = (float)maxDimension / (float)Math.max(original.getWidth(), original.getHeight());
        Matrix matrix = new Matrix();
        matrix.preRotate((float)rotation, (float)(original.getWidth() / 2), (float)(original.getHeight() / 2));
        matrix.postScale(scale, scale);
        Bitmap thumbnail = Bitmap.createBitmap((Bitmap)original, (int)0, (int)0, (int)original.getWidth(), (int)original.getHeight(), (Matrix)matrix, (boolean)true);
        FileOutputStream stream = new FileOutputStream(file);
        try {
            thumbnail.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)stream);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)stream);
        }
    }
}

