/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.draft;

import android.content.SharedPreferences;
import java.util.UUID;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.entity.Page;
import net.doo.snap.entity.SnappingDraft;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.process.util.DocumentDraft;

public class CombinedDocumentDraftExtractor
implements DocumentDraftExtractor {
    private final DocumentStoreStrategy documentStoreStrategy;
    private final SharedPreferences sharedPreferences;

    @Inject
    public CombinedDocumentDraftExtractor(DocumentStoreStrategy documentStoreStrategy, SharedPreferences sharedPreferences) {
        this.documentStoreStrategy = documentStoreStrategy;
        this.sharedPreferences = sharedPreferences;
    }

    @Override
    public DocumentDraft[] extract(SnappingDraft draft) {
        boolean singleAsJpeg = this.sharedPreferences.getBoolean("SAVE_SINGLE_AS_JPEG", false);
        String extension = singleAsJpeg && draft.size() == 1 ? ".jpg" : ".pdf";
        Document document = this.createDocument(this.documentStoreStrategy.getUniqueName(draft.getDocumentName() + extension), draft.size());
        return new DocumentDraft[]{new DocumentDraft(document, draft.getPages().toArray(new Page[draft.size()]))};
    }

    private Document createDocument(String name, int size) {
        Document document = new Document();
        document.setId(UUID.randomUUID().toString());
        document.setName(name);
        document.setPagesCount(size);
        document.setOcrStatus(OcrStatus.NOT_SCHEDULED);
        return document;
    }
}

