/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.draft;

import android.content.SharedPreferences;
import java.util.UUID;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.entity.SnappingDraft;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.process.util.DocumentDraft;

public class MultipleDocumentsDraftExtractor
implements DocumentDraftExtractor {
    private final String extension;

    public static MultipleDocumentsDraftExtractor forPdf() {
        return new MultipleDocumentsDraftExtractor(".pdf");
    }

    public static MultipleDocumentsDraftExtractor forJpeg() {
        return new MultipleDocumentsDraftExtractor(".jpg");
    }

    @Inject
    public MultipleDocumentsDraftExtractor(SharedPreferences sharedPreferences) {
        this(sharedPreferences.getBoolean("SAVE_SINGLE_AS_JPEG", false) ? ".jpg" : ".pdf");
    }

    private MultipleDocumentsDraftExtractor(String extension) {
        this.extension = extension;
    }

    @Override
    public DocumentDraft[] extract(SnappingDraft draft) {
        DocumentDraft[] documentMetadatas = new DocumentDraft[draft.size()];
        for (int i = 0; i < documentMetadatas.length; ++i) {
            Document document = this.createDocument(draft.getDocumentName() + this.extension, 1);
            documentMetadatas[i] = new DocumentDraft(document, draft.getPage(i));
        }
        return documentMetadatas;
    }

    private Document createDocument(String name, int size) {
        Document document = new Document();
        document.setId(UUID.randomUUID().toString());
        document.setName(name);
        document.setPagesCount(size);
        document.setOcrStatus(OcrStatus.NOT_SCHEDULED);
        return document;
    }
}

