/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.animation.Animator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.widget.AppCompatImageView;
import io.scanbot.sdk.utils.ViewUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import net.doo.snap.R;
import net.doo.snap.ScanbotSDKInitializer;
import net.doo.snap.lib.detector.Line2D;
import net.doo.snap.ui.MagnifierView;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.snap.PolygonHelper;
import org.jetbrains.annotations.Nullable;

public class EditPolygonImageView
extends AppCompatImageView {
    private static final int CORNERS_COUNT = 4;
    public static final List<PointF> DEFAULT_POLYGON = new ArrayList<PointF>(){
        {
            this.add(new PointF(0.0f, 0.0f));
            this.add(new PointF(1.0f, 0.0f));
            this.add(new PointF(1.0f, 1.0f));
            this.add(new PointF(0.0f, 1.0f));
        }
    };
    private EditPolygonAnimationEndListener editPolygonAnimationEndListener = null;
    private final float magneticLineTreshold;
    private final int edgeColor;
    private final int edgeColorOnLine;
    private final Drawable cornerDrawable;
    private final Drawable edgeDrawable;
    private Paint paint;
    private Paint paintOnLine;
    private Paint handlePaint;
    private PolygonHelper polygonHelper;
    private float rotationScale = 1.0f;
    private final List<Line2D> horizontalLines2D = new ArrayList<Line2D>();
    private final List<Line2D> verticalLines2D = new ArrayList<Line2D>();
    private final List<PolygonHelper.Line> horizontalLines = new ArrayList<PolygonHelper.Line>();
    private final List<PolygonHelper.Line> verticalLines = new ArrayList<PolygonHelper.Line>();
    private PointF finger = new PointF();
    private List<PointF> polygon;
    private List<PointF> corners;
    private List<PolygonHelper.Edge> edges;
    private float offsetX;
    private float offsetY;
    private Bitmap cornerBitmap;
    private Bitmap edgeBitmap;
    private int handleSize;
    private PointF selectedCorner;
    private PolygonHelper.Edge selectedEdge;
    private PointF tmpPointA = new PointF();
    private PointF tmpPointB = new PointF();
    private float medianX;
    private float medianY;
    private PriorityQueue<PointF> pointsQueue = new PriorityQueue<PointF>(4, new Comparator<PointF>(){

        @Override
        public int compare(PointF lhs, PointF rhs) {
            double first = Math.atan2(lhs.y - EditPolygonImageView.this.medianY, lhs.x - EditPolygonImageView.this.medianX);
            double second = Math.atan2(rhs.y - EditPolygonImageView.this.medianY, rhs.x - EditPolygonImageView.this.medianX);
            return Double.compare(first, second);
        }
    });
    @Nullable
    private MagnifierView magnifierView;
    private float[] imageMatrix = new float[9];
    private RectF touchRect = new RectF();
    private float polygonStrokeWidth;
    private int lastKnownImageWidth = -1;
    private int lastKnownImageHeight = -1;
    private float scaleLandscape = 1.0f;
    private float scalePortrait = 1.0f;

    public static List<PointF> getDefaultPolygon() {
        return new ArrayList<PointF>(){
            {
                this.add(new PointF(0.0f, 0.0f));
                this.add(new PointF(1.0f, 0.0f));
                this.add(new PointF(1.0f, 1.0f));
                this.add(new PointF(0.0f, 1.0f));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditPolygonImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        int i;
        if (!io.scanbot.sdk.ScanbotSDKInitializer.isInitialized() && !ScanbotSDKInitializer.isInitialized()) {
            throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.");
        }
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.EditPolygonImageView, 0, 0);
        try {
            this.edgeColor = typedArray.getColor(R.styleable.EditPolygonImageView_edgeColor, 0);
            this.edgeColorOnLine = typedArray.getColor(R.styleable.EditPolygonImageView_edgeColorOnLine, this.edgeColor);
            this.cornerDrawable = typedArray.getDrawable(R.styleable.EditPolygonImageView_cornerImageSrc);
            this.edgeDrawable = typedArray.getDrawable(R.styleable.EditPolygonImageView_edgeImageSrc);
            this.magneticLineTreshold = typedArray.getDimension(R.styleable.EditPolygonImageView_magneticLineTreshold, this.getResources().getDimension(R.dimen.magnetic_line_treshold));
            this.polygonStrokeWidth = typedArray.getDimension(R.styleable.EditPolygonImageView_editPolygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
            this.handleSize = typedArray.getDimensionPixelSize(R.styleable.EditPolygonImageView_editPolygonHandleSize, this.getResources().getDimensionPixelSize(R.dimen.edit_polygon_handle_size));
        }
        finally {
            typedArray.recycle();
        }
        this.polygon = Collections.emptyList();
        this.paint = new Paint();
        this.paint.setColor(this.edgeColor);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.polygonStrokeWidth);
        this.paint.setAntiAlias(true);
        this.paint.setStrokeCap(Paint.Cap.SQUARE);
        this.paintOnLine = new Paint();
        this.paintOnLine.setColor(this.edgeColorOnLine);
        this.paintOnLine.setStyle(Paint.Style.STROKE);
        this.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
        this.paintOnLine.setAntiAlias(true);
        this.paintOnLine.setStrokeCap(Paint.Cap.SQUARE);
        this.handlePaint = new Paint();
        this.handlePaint.setAntiAlias(true);
        this.handlePaint.setFilterBitmap(true);
        this.polygonHelper = new PolygonHelper();
        this.corners = new ArrayList<PointF>();
        for (i = 0; i < 4; ++i) {
            this.corners.add(new PointF());
        }
        this.edges = new ArrayList<PolygonHelper.Edge>();
        for (i = 0; i < this.corners.size(); ++i) {
            PolygonHelper.Edge edge = new PolygonHelper.Edge();
            edge.pointA = this.corners.get(i);
            edge.pointB = this.corners.get((i + 1) % 4);
            edge.pointFarA = this.corners.get((i + 3) % 4);
            edge.pointFarB = this.corners.get((i + 2) % 4);
            this.edges.add(edge);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.cornerBitmap = BitmapUtils.drawableToBitmap((Drawable)this.cornerDrawable);
        this.edgeBitmap = BitmapUtils.drawableToBitmap((Drawable)this.edgeDrawable);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cornerBitmap.recycle();
        this.edgeBitmap.recycle();
        this.editPolygonAnimationEndListener = null;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.onImageSizeUpdated();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    public void setPolygon(final List<PointF> polygon) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!polygon.isEmpty()) {
                    EditPolygonImageView.this.polygon = polygon;
                    if (!EditPolygonImageView.this.corners.isEmpty()) {
                        EditPolygonImageView.this.polygonHelper.getDrawingPolygon(polygon, EditPolygonImageView.this.corners);
                    }
                    EditPolygonImageView.this.invalidate();
                }
            }
        });
    }

    public List<PointF> getPolygon() {
        if (!this.corners.isEmpty() && !this.polygon.isEmpty()) {
            this.polygonHelper.getPolygonFromDrawingPolygon(this.corners, this.polygon);
        }
        return this.polygon;
    }

    public void setRotation(float rotation) {
        if (rotation % 90.0f != 0.0f) {
            return;
        }
        float rotateBy = this.getRotation() - rotation;
        float scale = this.getRotationScale(this.getRotation(), rotateBy);
        if (this.magnifierView != null) {
            this.magnifierView.setImageRotation(rotation);
        }
        this.setScaleX(scale);
        this.setScaleY(scale);
        this.invalidate();
        super.setRotation(rotation);
    }

    public void setLines(final List<Line2D> horizontalLines, final List<Line2D> verticalLines) {
        this.post(new Runnable(){

            @Override
            public void run() {
                ArrayList<Line2D> copyHorizontalLines = new ArrayList<Line2D>(horizontalLines.size());
                for (Line2D horizontalLine : horizontalLines) {
                    copyHorizontalLines.add(new Line2D(new PointF(horizontalLine.getStart().x, horizontalLine.getStart().y), new PointF(horizontalLine.getEnd().x, horizontalLine.getEnd().y)));
                }
                EditPolygonImageView.this.horizontalLines2D.clear();
                EditPolygonImageView.this.horizontalLines2D.addAll(EditPolygonImageView.this.polygonHelper.scaleLines(copyHorizontalLines));
                EditPolygonImageView.this.horizontalLines.clear();
                for (Line2D line2D : copyHorizontalLines) {
                    PolygonHelper.Line line = new PolygonHelper.Line();
                    line.calculateLine(line2D.getStart(), line2D.getEnd());
                    EditPolygonImageView.this.horizontalLines.add(line);
                }
                ArrayList<Line2D> copyVerticalLines = new ArrayList<Line2D>(verticalLines.size());
                for (Line2D verticalLine : verticalLines) {
                    copyVerticalLines.add(new Line2D(new PointF(verticalLine.getStart().x, verticalLine.getStart().y), new PointF(verticalLine.getEnd().x, verticalLine.getEnd().y)));
                }
                EditPolygonImageView.this.verticalLines2D.clear();
                EditPolygonImageView.this.verticalLines2D.addAll(EditPolygonImageView.this.polygonHelper.scaleLines(copyVerticalLines));
                EditPolygonImageView.this.verticalLines.clear();
                for (Line2D line2D : copyVerticalLines) {
                    PolygonHelper.Line line = new PolygonHelper.Line();
                    line.calculateLine(line2D.getStart(), line2D.getEnd());
                    EditPolygonImageView.this.verticalLines.add(line);
                }
            }
        });
    }

    public void setEdgeColor(int color) {
        this.paint.setColor(color);
    }

    public void setEdgeColorOnLine(int color) {
        this.paintOnLine.setColor(color);
    }

    public void setEdgeWidth(float width) {
        this.polygonStrokeWidth = width;
        this.paint.setStrokeWidth(this.polygonStrokeWidth);
        this.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
    }

    public void rotateClockwise() {
        float currentRotation = this.getRotation();
        if (currentRotation % 90.0f != 0.0f) {
            return;
        }
        float rotateBy = 90.0f;
        float scale = this.getRotationScale(currentRotation, 90.0f);
        this.animate().rotationBy(90.0f).scaleX(scale).scaleY(scale).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (EditPolygonImageView.this.magnifierView != null) {
                    EditPolygonImageView.this.magnifierView.setImageRotation(EditPolygonImageView.this.getRotation());
                }
                if (EditPolygonImageView.this.editPolygonAnimationEndListener != null) {
                    EditPolygonImageView.this.editPolygonAnimationEndListener.onAnimationEnded();
                }
                EditPolygonImageView.this.invalidate();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }).start();
    }

    public void rotateCounterClockwise() {
        float currentRotation = this.getRotation();
        if (currentRotation % 90.0f != 0.0f) {
            return;
        }
        float rotateBy = -90.0f;
        float scale = this.getRotationScale(currentRotation, -90.0f);
        this.animate().rotationBy(-90.0f).scaleX(scale).scaleY(scale).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (EditPolygonImageView.this.magnifierView != null) {
                    EditPolygonImageView.this.magnifierView.setImageRotation(EditPolygonImageView.this.getRotation());
                }
                if (EditPolygonImageView.this.editPolygonAnimationEndListener != null) {
                    EditPolygonImageView.this.editPolygonAnimationEndListener.onAnimationEnded();
                }
                EditPolygonImageView.this.invalidate();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }).start();
    }

    private float getRotationScale(float currentRotation, float rotateBy) {
        float newRotation = Math.abs((currentRotation + rotateBy) % 360.0f);
        if (newRotation / 90.0f % 2.0f == 0.0f) {
            return this.scalePortrait;
        }
        return this.scaleLandscape;
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.checkWhetherImageSizeUpdated();
        if (!this.polygon.isEmpty()) {
            canvas.save();
            canvas.translate(this.offsetX, this.offsetY);
            for (PolygonHelper.Edge edge : this.edges) {
                canvas.drawLine(edge.pointA.x, edge.pointA.y, edge.pointB.x, edge.pointB.y, edge.isDetectedLine ? this.paintOnLine : this.paint);
            }
            if (this.selectedCorner != null) {
                this.drawHandle(canvas, this.selectedCorner, this.cornerBitmap, 0.0f);
                canvas.save();
                canvas.translate(-this.offsetX, -this.offsetY);
                if (this.magnifierView != null) {
                    PointF selectedCornerF = new PointF(this.selectedCorner.x / ((float)this.getWidth() - 2.0f * this.offsetX), this.selectedCorner.y / ((float)this.getHeight() - 2.0f * this.offsetY));
                    this.magnifierView.drawMagnifier(selectedCornerF);
                }
                canvas.restore();
            } else if (this.selectedEdge != null) {
                this.drawHandle(canvas, this.selectedEdge.getHandle(), this.edgeBitmap, this.selectedEdge.getAngleInDegrees());
            } else {
                for (PolygonHelper.Edge edge : this.edges) {
                    this.drawHandle(canvas, edge.getHandle(), this.edgeBitmap, edge.getAngleInDegrees());
                }
                for (PointF point : this.corners) {
                    this.drawHandle(canvas, point, this.cornerBitmap, 0.0f);
                }
            }
            canvas.restore();
        }
    }

    private void checkWhetherImageSizeUpdated() {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return;
        }
        if (drawable.getIntrinsicWidth() != this.lastKnownImageWidth || drawable.getIntrinsicHeight() != this.lastKnownImageHeight) {
            this.lastKnownImageWidth = drawable.getIntrinsicWidth();
            this.lastKnownImageHeight = drawable.getIntrinsicHeight();
            this.onImageSizeUpdated();
        }
    }

    private void drawHandle(Canvas canvas, PointF point, Bitmap handle, float degrees) {
        canvas.save();
        if (degrees != 0.0f) {
            canvas.rotate(degrees, point.x, point.y);
        }
        float counterScale = 1.0f / this.getRotationScale(this.getRotation(), 0.0f);
        canvas.scale(counterScale, counterScale, point.x, point.y);
        canvas.drawBitmap(handle, point.x - (float)(handle.getWidth() >> 1), point.y - (float)(handle.getHeight() >> 1), this.handlePaint);
        canvas.restore();
    }

    private void keepInsideView(PointF point) {
        float x = Math.max(0.0f, Math.min(point.x, (float)this.getWidth() - 2.0f * this.offsetX));
        float y = Math.max(0.0f, Math.min(point.y, (float)this.getHeight() - 2.0f * this.offsetY));
        point.set(x, y);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                int halfHandleSize = this.handleSize >> 1;
                this.touchRect.set(event.getX() - this.offsetX - (float)halfHandleSize, event.getY() - this.offsetY - (float)halfHandleSize, event.getX() - this.offsetX + (float)halfHandleSize, event.getY() - this.offsetY + (float)halfHandleSize);
                for (PointF point : this.corners) {
                    if (!this.touchRect.contains(point.x, point.y)) continue;
                    this.selectedCorner = point;
                    this.invalidate();
                    return true;
                }
                for (PolygonHelper.Edge edge : this.edges) {
                    PointF edgeHandle = edge.getHandle();
                    if (!this.touchRect.contains(edgeHandle.x, edgeHandle.y)) continue;
                    this.selectedEdge = edge;
                    edge.prevX = event.getX();
                    edge.prevY = event.getY();
                    edge.lineA.calculateLine(edge.pointA, edge.pointFarA);
                    edge.lineB.calculateLine(edge.pointB, edge.pointFarB);
                    this.finger.set(edgeHandle);
                    this.invalidate();
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.selectedCorner != null) {
                    this.selectedCorner.set(event.getX() - this.offsetX, event.getY() - this.offsetY);
                    this.keepInsideView(this.selectedCorner);
                    this.ensureNoPolygonIntersection();
                    this.invalidate();
                } else if (this.selectedEdge != null) {
                    double distance;
                    PolygonHelper.Line line;
                    int i;
                    float dx = event.getX() - this.selectedEdge.prevX;
                    float dy = event.getY() - this.selectedEdge.prevY;
                    this.finger.offset(dx, dy);
                    this.tmpPointA.set(this.selectedEdge.pointA);
                    this.tmpPointB.set(this.selectedEdge.pointB);
                    double closestDistance = Double.MAX_VALUE;
                    Line2D closestLine2D = null;
                    if (this.selectedEdge.isHorizontal()) {
                        for (i = 0; i < this.horizontalLines.size(); ++i) {
                            line = this.horizontalLines.get(i);
                            distance = line.getDistanceToPoint(this.finger);
                            if (!(distance < closestDistance)) continue;
                            closestDistance = distance;
                            closestLine2D = this.horizontalLines2D.get(i);
                        }
                    } else {
                        for (i = 0; i < this.verticalLines.size(); ++i) {
                            line = this.verticalLines.get(i);
                            distance = line.getDistanceToPoint(this.finger);
                            if (!(distance < closestDistance)) continue;
                            closestDistance = distance;
                            closestLine2D = this.verticalLines2D.get(i);
                        }
                    }
                    if (closestLine2D != null && closestDistance < (double)this.magneticLineTreshold) {
                        this.selectedEdge.pointA.set(closestLine2D.getStart());
                        this.selectedEdge.pointB.set(closestLine2D.getEnd());
                        this.selectedEdge.isDetectedLine = true;
                    } else {
                        this.selectedEdge.isDetectedLine = false;
                        PointF handle = this.selectedEdge.getHandle();
                        float fingerDx = this.finger.x - handle.x;
                        float fingerDy = this.finger.y - handle.y;
                        this.selectedEdge.pointA.offset(fingerDx, fingerDy);
                        this.selectedEdge.pointB.offset(fingerDx, fingerDy);
                    }
                    this.selectedEdge.edgeLine.calculateLine(this.selectedEdge.pointA, this.selectedEdge.pointB);
                    PointF intersectionA = this.selectedEdge.edgeLine.getIntersectionPoint(this.selectedEdge.lineA);
                    if (Float.isNaN(intersectionA.x) || Float.isNaN(intersectionA.y)) {
                        this.restoreSelectedEdge();
                        return false;
                    }
                    this.selectedEdge.pointA.set(intersectionA);
                    PointF intersectionB = this.selectedEdge.edgeLine.getIntersectionPoint(this.selectedEdge.lineB);
                    if (Float.isNaN(intersectionB.x) || Float.isNaN(intersectionB.y)) {
                        this.restoreSelectedEdge();
                        return false;
                    }
                    this.selectedEdge.pointB.set(intersectionB);
                    this.keepInsideView(this.selectedEdge.pointA);
                    this.keepInsideView(this.selectedEdge.pointB);
                    this.selectedEdge.prevX = event.getX();
                    this.selectedEdge.prevY = event.getY();
                    this.invalidate();
                }
                return true;
            }
            case 1: 
            case 3: {
                this.selectedCorner = null;
                this.selectedEdge = null;
                if (this.magnifierView != null) {
                    this.magnifierView.eraseMagnifier();
                }
                this.invalidate();
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private void restoreSelectedEdge() {
        this.selectedEdge.pointA.set(this.tmpPointA);
        this.selectedEdge.pointB.set(this.tmpPointB);
        this.selectedEdge.edgeLine.calculateLine(this.selectedEdge.pointA, this.selectedEdge.pointB);
    }

    private void ensureNoPolygonIntersection() {
        this.calculateMedian();
        if (this.ensureCornersOrder()) {
            this.ensureEdgesOrder();
        }
    }

    private boolean ensureCornersOrder() {
        boolean changed = false;
        this.pointsQueue.addAll(this.corners);
        for (int i = 0; i < 4; ++i) {
            PointF pointF = (PointF)this.pointsQueue.remove();
            if (!pointF.equals((Object)this.corners.get(i))) {
                changed = true;
            }
            this.corners.set(i, pointF);
        }
        return changed;
    }

    private void calculateMedian() {
        float sx = 0.0f;
        float sy = 0.0f;
        for (int i = 0; i < 4; ++i) {
            PointF pointF = this.corners.get(i);
            sx += pointF.x;
            sy += pointF.y;
        }
        this.medianX = sx / 4.0f;
        this.medianY = sy / 4.0f;
    }

    private void ensureEdgesOrder() {
        for (int i = 0; i < 4; ++i) {
            PolygonHelper.Edge edge = this.edges.get(i);
            edge.pointA = this.corners.get(i);
            edge.pointB = this.corners.get((i + 1) % 4);
            edge.pointFarA = this.corners.get((i + 3) % 4);
            edge.pointFarB = this.corners.get((i + 2) % 4);
        }
    }

    private void onImageSizeUpdated() {
        if (this.getDrawable() != null) {
            this.offsetX = 0.0f;
            this.offsetY = 0.0f;
            this.getImageMatrix().getValues(this.imageMatrix);
            Drawable d = this.getDrawable();
            int origW = d.getIntrinsicWidth();
            int origH = d.getIntrinsicHeight();
            RectF drawableBounds = new RectF(0.0f, 0.0f, (float)origW * this.getScaleX(), (float)origH * this.getScaleY());
            this.scalePortrait = ViewUtils.fitRectToView((View)this, 0.0f, drawableBounds) * this.getScaleX();
            this.scaleLandscape = ViewUtils.fitRectToView((View)this, 90.0f, drawableBounds) * this.getScaleY();
            if ((float)origW * this.scalePortrait < (float)this.getWidth()) {
                this.offsetX = this.getWidth() - (int)((float)origW * this.scalePortrait) >> 1;
            }
            if ((float)origH * this.scalePortrait < (float)this.getHeight()) {
                this.offsetY = this.getHeight() - (int)((float)origH * this.scalePortrait) >> 1;
            }
            this.polygonHelper.setImageSize((int)((float)origW * this.scalePortrait), (int)((float)origH * this.scalePortrait));
            this.scaleLandscape /= this.scalePortrait;
            this.scalePortrait = 1.0f;
            if (this.getRotation() / 90.0f % 2.0f == 1.0f) {
                this.setScaleX(this.scaleLandscape);
                this.setScaleY(this.scaleLandscape);
            }
            if (!this.polygon.isEmpty()) {
                this.polygonHelper.getDrawingPolygon(this.polygon, this.corners);
            }
        }
    }

    void setMagnifier(MagnifierView magnifier) {
        this.magnifierView = magnifier;
        this.invalidate();
    }

    public void setEditPolygonAnimationEndListener(EditPolygonAnimationEndListener editPolygonAnimationEndListener) {
        this.editPolygonAnimationEndListener = editPolygonAnimationEndListener;
    }

    public static interface EditPolygonAnimationEndListener {
        public void onAnimationEnded();
    }
}

