/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import net.doo.snap.R;
import net.doo.snap.ui.EditPolygonImageView;
import net.doo.snap.util.bitmap.BitmapUtils;

public class MagnifierView
extends View {
    private final float magnifierRaduis;
    private final float magnifierMargin;
    private final int magnifierDrawableResourceId;
    private Magnifier magnifier = new Magnifier();
    private PointF zoomPoint;
    private Bitmap magnifierFrameBitmap;
    private boolean enableBounding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MagnifierView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MagnifierView, 0, 0);
        try {
            this.magnifierDrawableResourceId = typedArray.getResourceId(R.styleable.MagnifierView_magnifierImageSrc, 0);
            this.magnifierRaduis = typedArray.getDimension(R.styleable.MagnifierView_magnifierRadius, this.getResources().getDimension(R.dimen.magnifier_raduis));
            this.magnifierMargin = typedArray.getDimension(R.styleable.MagnifierView_magnifierMargin, this.getResources().getDimension(R.dimen.magnifier_margin));
            this.enableBounding = typedArray.getBoolean(R.styleable.MagnifierView_magnifierEnableBounding, true);
        }
        finally {
            typedArray.recycle();
        }
    }

    void drawMagnifier(PointF zoomPoint) {
        this.zoomPoint = zoomPoint;
        this.invalidate();
    }

    void eraseMagnifier() {
        this.zoomPoint = null;
        this.invalidate();
    }

    public void setImageRotation(float rotation) {
        this.magnifier.setImageRotation(rotation);
        this.invalidate();
    }

    public void setupMagnifier(EditPolygonImageView view) {
        Bitmap mutableBitmap = BitmapUtils.drawableToBitmap((Drawable)view.getDrawable());
        this.magnifier.setup(mutableBitmap, view.getRotation(), -16777216);
        view.setMagnifier(this);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.zoomPoint != null) {
            this.magnifier.draw(canvas, this.zoomPoint);
        } else {
            canvas.drawColor(0);
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        this.magnifierFrameBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.magnifierDrawableResourceId, (BitmapFactory.Options)options);
        if (this.magnifierFrameBitmap == null) {
            this.magnifierFrameBitmap = BitmapUtils.drawableToBitmap((Drawable)this.getResources().getDrawable(this.magnifierDrawableResourceId));
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.magnifierFrameBitmap.recycle();
        this.magnifierFrameBitmap = null;
        this.magnifier.cleanup();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.magnifier.setViewDimensions(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
    }

    public void setEnableBounding(boolean enableBounding) {
        this.enableBounding = enableBounding;
    }

    private class Magnifier {
        private final float ZOOM = 2.0f;
        private float bitmapScale;
        private int viewWidth;
        private int viewHeight;
        private BitmapShader shader;
        private Paint shaderPaint;
        private Matrix matrix = new Matrix();
        private float offsetX;
        private float offsetY;
        private float rotation;
        private Bitmap magnifierBitmap;

        Magnifier() {
        }

        void setViewDimensions(int width, int height) {
            this.viewWidth = width;
            this.viewHeight = height;
            if (this.magnifierBitmap != null && width != 0 && height != 0) {
                this.bitmapScale = Math.max((float)this.magnifierBitmap.getWidth() / (float)this.viewWidth, (float)this.magnifierBitmap.getHeight() / (float)this.viewHeight);
                this.offsetX = ((float)this.viewWidth - (float)this.magnifierBitmap.getWidth() / this.bitmapScale) / 2.0f;
                this.offsetY = ((float)this.viewHeight - (float)this.magnifierBitmap.getHeight() / this.bitmapScale) / 2.0f;
            }
        }

        void setup(Bitmap bitmap, float rotation, int outsideColor) {
            if (BitmapUtils.isBitmapValid((Bitmap)bitmap)) {
                if (this.shader != null) {
                    this.cleanup();
                }
                this.magnifierBitmap = this.drawOutline(bitmap, outsideColor);
                this.shader = new BitmapShader(this.magnifierBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                this.shaderPaint = new Paint();
                this.shaderPaint.setShader((Shader)this.shader);
                this.rotation = rotation;
                this.setViewDimensions(MagnifierView.this.getWidth() - MagnifierView.this.getPaddingLeft() - MagnifierView.this.getPaddingRight(), MagnifierView.this.getHeight() - MagnifierView.this.getPaddingTop() - MagnifierView.this.getPaddingBottom());
            }
        }

        void cleanup() {
            if (this.magnifierBitmap != null) {
                this.magnifierBitmap.recycle();
            }
            this.magnifierBitmap = null;
            this.shaderPaint = null;
            this.shader = null;
        }

        private Bitmap drawOutline(Bitmap bitmap, int outlineColor) {
            Canvas canvas = new Canvas(bitmap);
            Paint paint = new Paint();
            paint.setColor(outlineColor);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(0.0f);
            canvas.drawRect(0.0f, 0.0f, (float)(bitmap.getWidth() - 1), (float)(bitmap.getHeight() - 1), paint);
            return bitmap;
        }

        void draw(Canvas canvas, PointF zoomPointF) {
            PointF zoomPoint = new PointF(zoomPointF.x * (float)this.magnifierBitmap.getWidth(), zoomPointF.y * (float)this.magnifierBitmap.getHeight());
            float startX = MagnifierView.this.magnifierMargin;
            float startY = MagnifierView.this.magnifierMargin;
            if (MagnifierView.this.enableBounding && this.isInLeftTop(zoomPoint)) {
                startX = (float)MagnifierView.this.getWidth() - MagnifierView.this.magnifierRaduis * 2.0f - MagnifierView.this.magnifierMargin;
            }
            this.matrix.setScale(2.0f, 2.0f);
            this.matrix.postTranslate(-zoomPoint.x * 2.0f + MagnifierView.this.magnifierRaduis + startX, -zoomPoint.y * 2.0f + MagnifierView.this.magnifierRaduis + startY);
            this.shader.setLocalMatrix(this.matrix);
            canvas.save();
            canvas.rotate(this.rotation, startX + MagnifierView.this.magnifierRaduis, startY + MagnifierView.this.magnifierRaduis);
            canvas.drawCircle(startX + MagnifierView.this.magnifierRaduis, startY + MagnifierView.this.magnifierRaduis, MagnifierView.this.magnifierRaduis, this.shaderPaint);
            canvas.restore();
            canvas.drawBitmap(MagnifierView.this.magnifierFrameBitmap, startX, startY, null);
        }

        private boolean isInLeftTop(PointF point) {
            int quarter = 1;
            quarter = point.x + this.offsetX < (float)(this.magnifierBitmap.getWidth() >> 1) ? (point.y + this.offsetY < (float)(this.magnifierBitmap.getHeight() >> 1) ? 1 : 4) : (point.y + this.offsetY < (float)(this.magnifierBitmap.getHeight() >> 1) ? 2 : 3);
            quarter = (int)((float)quarter - (360.0f - this.rotation) % 360.0f / 90.0f);
            return quarter == 1;
        }

        void setImageRotation(float rotation) {
            this.rotation = rotation;
        }
    }
}

