/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util;

public class YUVUtil {
    public static byte[] rotateYUV21Image(int cameraRotation, byte[] data, int imageWidth, int imageHeight) {
        switch (cameraRotation) {
            case 0: {
                return data;
            }
            case 90: {
                return YUVUtil.rotateCW(data, imageWidth, imageHeight);
            }
            case 180: {
                return YUVUtil.rotate180(data, imageWidth, imageHeight);
            }
            case 270: {
                return YUVUtil.rotateCCW(data, imageWidth, imageHeight);
            }
        }
        return data;
    }

    private static byte[] rotateCW(byte[] data, int imageWidth, int imageHeight) {
        byte[] yuv = new byte[imageWidth * imageHeight];
        int i = 0;
        for (int x = 0; x < imageWidth; ++x) {
            for (int y = imageHeight - 1; y >= 0; --y) {
                yuv[i] = data[y * imageWidth + x];
                ++i;
            }
        }
        return yuv;
    }

    private static byte[] rotate180(byte[] data, int imageWidth, int imageHeight) {
        int n = imageWidth * imageHeight;
        byte[] yuv = new byte[n];
        int i = n - 1;
        for (int j = 0; j < n; ++j) {
            yuv[i] = data[j];
            --i;
        }
        return yuv;
    }

    private static byte[] rotateCCW(byte[] data, int imageWidth, int imageHeight) {
        int n = imageWidth * imageHeight;
        byte[] yuv = new byte[n];
        int i = n - 1;
        for (int x = 0; x < imageWidth; ++x) {
            for (int y = imageHeight - 1; y >= 0; --y) {
                yuv[i] = data[y * imageWidth + x];
                --i;
            }
        }
        return yuv;
    }
}

