/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.bitmap;

import android.graphics.Bitmap;

public class ImageQualityOptimizer {
    public Bitmap optimizeImage(Bitmap bitmap, float widthInches, float heightInches, long maxRequiredDpi) {
        int bitmapWidth;
        int bitmapHeight = bitmap.getHeight();
        float density = Math.round((float)Math.max(bitmapHeight, bitmapWidth = bitmap.getWidth()) / Math.max(heightInches, widthInches));
        float scaleFactor = (float)maxRequiredDpi / density;
        if (scaleFactor >= 1.0f) {
            return bitmap;
        }
        int scaledWidth = Math.round((float)bitmapWidth * scaleFactor);
        int scaledHeight = Math.round((float)bitmapHeight * scaleFactor);
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)scaledWidth, (int)scaledHeight, (boolean)false);
    }

    public final Bitmap optimizeImage(Bitmap bitmap, long requiredDpi) {
        return this.optimizeImage(bitmap, PaperFormat.A4.widthInches, PaperFormat.A4.heightInches, requiredDpi);
    }

    public static enum PaperFormat {
        A1(23.4f, 33.1f),
        A2(16.5f, 23.4f),
        A3(11.7f, 16.5f),
        A4(8.3f, 11.7f),
        A5(5.8f, 8.3f),
        US_LETTER(8.5f, 11.0f),
        US_LEGAL(8.5f, 14.0f);

        public final float widthInches;
        public final float heightInches;

        private PaperFormat(float widthInches, float heightInches) {
            this.widthInches = widthInches;
            this.heightInches = heightInches;
        }
    }
}

