/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.device;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import javax.inject.Inject;

public class DeviceUtils {
    private final Context context;

    @Inject
    public DeviceUtils(Context context) {
        this.context = context;
    }

    public float getBatteryLevel() {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = this.context.registerReceiver(null, filter);
        float batteryPct = -1.0f;
        if (batteryStatus != null) {
            int level = batteryStatus.getIntExtra("level", -1);
            int scale = batteryStatus.getIntExtra("scale", -1);
            batteryPct = (float)level / (float)scale;
        }
        return batteryPct;
    }

    public boolean isDeviceOnCharger() {
        Intent batteryIntent = this.context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        int status = batteryIntent.getIntExtra("status", -1);
        if (status == 2 || status == 5) {
            return true;
        }
        int chargePlug = batteryIntent.getIntExtra("plugged", -1);
        return chargePlug == 2 || chargePlug == 1;
    }
}

