/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.snap;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import java.util.ArrayList;
import java.util.List;
import net.doo.snap.lib.detector.Line2D;

public class PolygonHelper {
    private static final int MIN_EDGE_LENGTH_PX = 35;
    private float[] tmpPoints = new float[8];
    private Matrix matrix = new Matrix();
    private int width;
    private int height;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int rotation = 0;

    public static boolean checkPolygonSize(List<Point> polygon) {
        return !polygon.isEmpty() && Math.abs(polygon.get((int)1).x - polygon.get((int)0).x) > 35 && Math.abs(polygon.get((int)2).x - polygon.get((int)3).x) > 35 && Math.abs(polygon.get((int)3).y - polygon.get((int)0).y) > 35 && Math.abs(polygon.get((int)2).y - polygon.get((int)1).y) > 35;
    }

    public void setRotation(int degrees) {
        if (this.rotation == degrees) {
            return;
        }
        this.rotation = degrees;
        this.matrix.setRotate((float)degrees, 0.5f, 0.5f);
    }

    public void setImageSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setLayout(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.width = right - left;
        this.height = bottom - top;
    }

    public void polygonToPoints(List<PointF> polygon, float[] points) {
        int i;
        for (i = 0; i < polygon.size(); ++i) {
            this.tmpPoints[i * 2] = polygon.get((int)i).x;
            this.tmpPoints[i * 2 + 1] = polygon.get((int)i).y;
        }
        this.matrix.mapPoints(this.tmpPoints);
        for (i = 0; i < polygon.size(); ++i) {
            points[i * 4] = (float)this.left + (float)this.width * this.tmpPoints[i * 2];
            points[i * 4 + 1] = (float)this.top + (float)this.height * this.tmpPoints[i * 2 + 1];
            points[i * 4 + 2] = (float)this.left + (float)this.width * this.tmpPoints[(i * 2 + 2) % 8];
            points[i * 4 + 3] = (float)this.top + (float)this.height * this.tmpPoints[(i * 2 + 3) % 8];
        }
    }

    public void getDrawingPolygon(List<PointF> polygon, List<PointF> drawingPolygon) {
        for (int i = 0; i < drawingPolygon.size(); ++i) {
            PointF point = polygon.get(i);
            PointF drawingPoint = drawingPolygon.get(i);
            drawingPoint.x = point.x * (float)this.width;
            drawingPoint.y = point.y * (float)this.height;
        }
    }

    public void getPolygonFromDrawingPolygon(List<PointF> drawingPolygon, List<PointF> polygon) {
        for (int i = 0; i < drawingPolygon.size(); ++i) {
            PointF point = polygon.get(i);
            PointF drawingPoint = drawingPolygon.get(i);
            point.x = drawingPoint.x / (float)this.width;
            point.y = drawingPoint.y / (float)this.height;
        }
    }

    public List<Line2D> scaleLines(List<Line2D> lines) {
        ArrayList<Line2D> outLines = new ArrayList<Line2D>();
        for (Line2D line : lines) {
            line.getStart().x = (float)this.left + (float)this.width * line.getStart().x;
            line.getStart().y = (float)this.top + (float)this.height * line.getStart().y;
            line.getEnd().x = (float)this.left + (float)this.width * line.getEnd().x;
            line.getEnd().y = (float)this.top + (float)this.height * line.getEnd().y;
            outLines.add(line);
        }
        return outLines;
    }

    public static class Line {
        private double a;
        private double b;
        private double c;
        private PointF intersectionPoint = new PointF();

        public PointF getIntersectionPoint(Line line) {
            this.intersectionPoint.x = (float)((this.c * line.b - this.b * line.c) / (this.b * line.a - this.a * line.b));
            this.intersectionPoint.y = (float)((this.a * line.c - this.c * line.a) / (this.b * line.a - this.a * line.b));
            return this.intersectionPoint;
        }

        public void calculateLine(PointF start, PointF end) {
            this.a = start.y - end.y;
            this.b = end.x - start.x;
            this.c = (start.x - end.x) * start.y + (end.y - start.y) * start.x;
        }

        public double getDistanceToPoint(PointF point) {
            if (this.a != 0.0 || this.b != 0.0) {
                return Math.abs(this.a * (double)point.x + this.b * (double)point.y + this.c) / Math.sqrt(this.a * this.a + this.b * this.b);
            }
            return 0.0;
        }
    }

    public static class Edge {
        public PointF pointA;
        public PointF pointB;
        public PointF pointFarA;
        public PointF pointFarB;
        public Line edgeLine = new Line();
        public Line lineA = new Line();
        public Line lineB = new Line();
        private PointF handle = new PointF();
        public float prevX;
        public float prevY;
        public boolean isDetectedLine = false;

        public float getAngleInDegrees() {
            float dy = this.pointB.y - this.pointA.y;
            float dx = this.pointB.x - this.pointA.x;
            double angle = Math.atan2(dy, dx);
            angle = Math.toDegrees(angle);
            return (float)(angle += 90.0);
        }

        public PointF getHandle() {
            this.handle.x = (this.pointA.x + this.pointB.x) / 2.0f;
            this.handle.y = (this.pointA.y + this.pointB.y) / 2.0f;
            return this.handle;
        }

        public boolean isHorizontal() {
            float dy = this.pointB.y - this.pointA.y;
            float dx = this.pointB.x - this.pointA.x;
            return Math.abs(dx) > Math.abs(dy);
        }
    }
}

