/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr;

import android.net.Uri;
import androidx.core.net.UriKt;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.a;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.PDFPageSize;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.persistence.PageFactory;
import net.doo.snap.process.OcrResult;
import net.doo.snap.process.TextRecognition;
import org.jetbrains.annotations.NotNull;

public final class b
implements OpticalCharacterRecognizer {
    private final TextRecognition a;
    private final PageFactory b;
    private final BlobManager c;
    private final PageFileStorage d;

    private final Document a() {
        Document document;
        b b2 = document;
        new Document().setId(UUID.randomUUID().toString());
        b2.setName(b2.getId() + ".pdf");
        b2.setOcrStatus(OcrStatus.PENDING);
        return b2;
    }

    private final void a(Set<? extends Language> languages) {
        if (!((this = SetsKt.minus(languages, ((b)this).getInstalledLanguages())).isEmpty() ^ true)) {
            return;
        }
        throw new a(this + " Provided set of languages was not presented on device");
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public b(@NotNull TextRecognition textRecognition, @NotNull PageFactory pageFactory, @NotNull BlobManager blobManager, @NotNull PageFileStorage pageFileStorage) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)var1_1, (String)"textRecognition");
        Intrinsics.checkParameterIsNotNull((Object)var2_2, (String)"pageFactory");
        Intrinsics.checkParameterIsNotNull((Object)var3_3, (String)"blobManager");
        Intrinsics.checkParameterIsNotNull((Object)var4_4, (String)"pageFileStorage");
        this.a = var1_1;
        this.b = var2_2;
        this.c = var3_3;
        this.d = var4_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull Set<? extends Language> languages) {
        ArrayList<net.doo.snap.entity.Page> arrayList;
        Iterator iterator;
        void var2_2;
        b b2 = this;
        void v1 = var2_2;
        Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull((Object)v1, (String)"languages");
        b2.a((Set<? extends Language>)v1);
        TextRecognition textRecognition = b2.a;
        ArrayList<net.doo.snap.entity.Page> arrayList2 = arrayList;
        arrayList = new ArrayList<net.doo.snap.entity.Page>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        for (Uri uri : imageFileUris) {
            arrayList2.add(this.b.buildPage(UriKt.toFile((Uri)uri)));
        }
        OcrResult ocrResult = textRecognition.withoutPDF(arrayList2, (Set)var2_2).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withoutP\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromPages(@NotNull List<Page> pages, @NotNull Set<? extends Language> languages) {
        ArrayList<net.doo.snap.entity.Page> arrayList;
        Iterator iterator;
        void var2_2;
        b b2 = this;
        void v1 = var2_2;
        Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"pages");
        Intrinsics.checkParameterIsNotNull((Object)v1, (String)"languages");
        b2.a((Set<? extends Language>)v1);
        TextRecognition textRecognition = b2.a;
        ArrayList<net.doo.snap.entity.Page> arrayList2 = arrayList;
        arrayList = new ArrayList<net.doo.snap.entity.Page>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        for (Page page : pages) {
            net.doo.snap.entity.Page page2 = this.b.buildPage(page.getPageId(), new File(this.d.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
            page2.setImageFilterType(page.getFilter());
            arrayList2.add(page2);
        }
        OcrResult ocrResult = textRecognition.withoutPDF(arrayList2, (Set)var2_2).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withoutP\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        ArrayList<net.doo.snap.entity.Page> arrayList;
        void var2_2;
        Iterator iterator;
        void var3_3;
        b b2 = this;
        void v1 = var3_3;
        Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull((Object)var2_2, (String)"pageSize");
        Intrinsics.checkParameterIsNotNull((Object)v1, (String)"languages");
        b2.a((Set<? extends Language>)v1);
        TextRecognition textRecognition = b2.a;
        Document document = b2.a();
        ArrayList<net.doo.snap.entity.Page> arrayList2 = arrayList;
        arrayList = new ArrayList<net.doo.snap.entity.Page>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        for (Uri uri : imageFileUris) {
            net.doo.snap.entity.Page page = this.b.buildPage(UriKt.toFile((Uri)uri));
            Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"oldPage");
            page.setPageSize((PDFPageSize)var2_2);
            arrayList2.add(page);
        }
        OcrResult ocrResult = textRecognition.withPDF(document, arrayList2, (Set)var3_3).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withPDF(\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromPages(@NotNull List<Page> pages, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        ArrayList<net.doo.snap.entity.Page> arrayList;
        void var2_2;
        Iterator iterator;
        void var3_3;
        b b2 = this;
        void v1 = var3_3;
        Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"pages");
        Intrinsics.checkParameterIsNotNull((Object)var2_2, (String)"pageSize");
        Intrinsics.checkParameterIsNotNull((Object)v1, (String)"languages");
        b2.a((Set<? extends Language>)v1);
        TextRecognition textRecognition = b2.a;
        Document document = b2.a();
        ArrayList<net.doo.snap.entity.Page> arrayList2 = arrayList;
        arrayList = new ArrayList<net.doo.snap.entity.Page>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        for (Page page : pages) {
            net.doo.snap.entity.Page page2 = this.b.buildPage(page.getPageId(), new File(this.d.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
            page2.setImageFilterType(page.getFilter());
            page2.setPolygon(page.getPolygon());
            page2.setPageSize((PDFPageSize)var2_2);
            arrayList2.add(page2);
        }
        OcrResult ocrResult = textRecognition.withPDF(document, arrayList2, (Set)var3_3).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withPDF(\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public File getLanguageDataPath() {
        File file = this.c.getOCRBlobsDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"blobManager.ocrBlobsDirectory");
        return file;
    }

    @Override
    @NotNull
    public Set<Language> getInstalledLanguages() {
        Set set = this.c.getAllLanguagesWithAvailableOcrBlobs();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"blobManager.allLanguagesWithAvailableOcrBlobs");
        return set;
    }
}

