/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.bitmap;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public class BitmapUtils {
    public static Rect getBitmapBounds(String path2) {
        Rect rect = new Rect();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path2, (BitmapFactory.Options)options);
        int path2 = options.outWidth;
        int n2 = options.outHeight;
        rect.set(0, 0, path2, n2);
        return rect;
    }

    public static boolean isBitmapValid(Bitmap bitmap) {
        Bitmap bitmap2;
        return bitmap != null && !bitmap2.isRecycled();
    }

    public static Rect getContentBounds(Bitmap bitmap) throws NullPointerException {
        if (bitmap != null) {
            Bitmap bitmap2;
            Bitmap bitmap3 = bitmap2;
            int n2 = bitmap3.getWidth();
            int n3 = bitmap3.getHeight();
            int n4 = 0;
            int n5 = 0;
            for (int i2 = 0; i2 < bitmap2.getHeight(); ++i2) {
                for (int i3 = 0; i3 < bitmap2.getWidth(); ++i3) {
                    if (bitmap2.getPixel(i3, i2) == 0) continue;
                    if (i3 < n2) {
                        n2 = i3;
                    }
                    if (i2 < n3) {
                        n3 = i2;
                    }
                    if (i3 > n4) {
                        n4 = i3;
                    }
                    if (i2 <= n5) continue;
                    n5 = i2;
                }
            }
            return new Rect(n2, n3, n4, n5);
        }
        throw new NullPointerException("Bitmap is null");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void compress(Bitmap bitmap, Bitmap.CompressFormat format, int quality, File file) throws IOException {
        Throwable throwable2;
        FileOutputStream fileOutputStream;
        block5: {
            FileOutputStream fileOutputStream2;
            void v3;
            void v2;
            Bitmap bitmap2;
            FileOutputStream fileOutputStream3;
            Object var4_4 = null;
            fileOutputStream = fileOutputStream3;
            try {
                void var3_3;
                void var2_2;
                void var1_1;
                Bitmap bitmap22;
                bitmap2 = bitmap22;
                v2 = var1_1;
                v3 = var2_2;
                FileOutputStream fileOutputStream4 = fileOutputStream;
                fileOutputStream2 = fileOutputStream4;
                fileOutputStream4((File)var3_3);
            }
            catch (Throwable throwable2) {
                fileOutputStream = var4_4;
                break block5;
            }
            try {
                bitmap2.compress((Bitmap.CompressFormat)v2, (int)v3, (OutputStream)fileOutputStream2);
            }
            catch (Throwable throwable2) {
                break block5;
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream3);
            return;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        throw throwable2;
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap createPreview(Resources res, int imageRes, int targetWidth, int targetHeight) {
        void var3_3;
        void var2_2;
        void var1_1;
        Resources resources;
        BitmapFactory.Options options;
        BitmapFactory.Options options2;
        if (imageRes <= 0) {
            return null;
        }
        BitmapFactory.Options options3 = options2 = options;
        options3();
        options3.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resources, (int)var1_1, (BitmapFactory.Options)options3);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, (int)var2_2, (int)var3_3);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)resources, (int)var1_1, (BitmapFactory.Options)options);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap createPreview(byte[] image, int targetWidth, int targetHeight) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        BitmapFactory.Options options;
        if (image == null) {
            return null;
        }
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options2);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, (int)var1_1, (int)var2_2);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options2);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap createPreview(Bitmap image, int targetWidth, int targetHeight) {
        void var2_2;
        int n2;
        Bitmap bitmap;
        if (image == null) {
            return null;
        }
        Bitmap bitmap2 = bitmap;
        n2 = BitmapUtils.calculateInSampleSize(n2, (int)var2_2, bitmap.getWidth(), bitmap.getHeight());
        return Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)(bitmap2.getWidth() / n2), (int)(bitmap.getHeight() / n2), (boolean)false);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options3, int reqWidth, int reqHeight) {
        BitmapFactory.Options options2 = options3;
        int options3 = options2.outHeight;
        return BitmapUtils.calculateInSampleSize(reqWidth, reqHeight, options2.outWidth, options3);
    }

    /*
     * WARNING - void declaration
     */
    private static int calculateInSampleSize(int reqWidth, int reqHeight, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n2;
        int n3;
        int n4 = width > height ? 1 : 0;
        if (n4 != (n3 = n2 > var1_1)) {
            void v0 = var2_2;
            var2_2 = var3_3;
            var3_3 = v0;
        }
        n4 = 1;
        if (var3_3 > var1_1 || var2_2 > n2) {
            void v1 = var2_2;
            var2_2 = var3_3 / 2;
            var3_3 = v1 / 2;
            while (var2_2 / n4 > var1_1 && var3_3 / n4 > n2) {
                n4 *= 2;
            }
        }
        return n4;
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap decodeQuietly(@Nullable String path, @Nullable BitmapFactory.Options options) {
        String string2;
        File file;
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        File file2 = file;
        if (new File(string2).exists() && file2.isFile()) {
            void var1_1;
            return BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)var1_1);
        }
        return null;
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        Drawable drawable2;
        BitmapDrawable bitmapDrawable;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
            return bitmapDrawable.getBitmap().copy(Bitmap.Config.ARGB_8888, true);
        }
        if (drawable2.getIntrinsicWidth() > 0 && drawable2.getIntrinsicHeight() > 0) {
            bitmapDrawable = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        } else {
            bitmapDrawable = Bitmap.Config.ARGB_8888;
            bitmapDrawable = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)bitmapDrawable);
        }
        Canvas canvas = new Canvas((Bitmap)bitmapDrawable);
        int n2 = canvas.getWidth();
        int n3 = canvas.getHeight();
        drawable2.setBounds(0, 0, n2, n3);
        drawable2.draw(canvas);
        return bitmapDrawable;
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap scaleIfNeeded(Bitmap image, int maxHeight, int maxWidth) {
        void var1_1;
        Bitmap bitmap;
        void var2_3;
        if (maxHeight >= image.getHeight() && var2_3 >= bitmap.getWidth()) {
            return bitmap;
        }
        float f2 = Math.min((float)var2_3 / (float)bitmap.getWidth(), (float)var1_1 / (float)bitmap.getHeight());
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)Math.round(f2 * (float)bitmap.getWidth()), (int)Math.round(f2 * (float)bitmap.getHeight()), (boolean)false);
    }
}

