/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.inject.Inject;
import net.doo.snap.R;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.persistence.cleanup.Cleaner;
import net.doo.snap.process.DocumentProcessingResult;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.ComposerFactory;
import net.doo.snap.process.h;
import net.doo.snap.process.util.DocumentDraft;
import net.doo.snap.util.bitmap.BitmapLruCache;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class DocumentProcessor {
    private final DocumentStoreStrategy a;
    private final PageStoreStrategy b;
    private final BitmapLruCache c;
    private final ComposerFactory d;
    private final a e;
    private final h<Document> f;
    private final Cleaner g;
    private final Logger h;

    @Inject
    public DocumentProcessor(DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, Resources resources, BitmapLruCache bitmapLruCache, ComposerFactory composerFactory, h<Document> documentProcessorMonitor, Cleaner cleaner) {
        DocumentProcessor documentProcessor = this;
        this.h = LoggerProvider.getLogger();
        this.a = documentStoreStrategy;
        this.b = pageStoreStrategy;
        this.c = bitmapLruCache;
        this.d = composerFactory;
        this.f = documentProcessorMonitor;
        documentProcessor.g = cleaner;
        documentProcessor.e = new a(resources, documentStoreStrategy, pageStoreStrategy);
    }

    /*
     * WARNING - void declaration
     */
    private void a(Document document, Page[] pages) throws IOException {
        void var1_1;
        void var2_2;
        this.a.ensureDocumentDirectory(document.getId());
        if (document.getSize() < 0L) {
            for (int i2 = 0; i2 < ((void)var2_2).length; ++i2) {
                void var4_5 = var2_2[i2];
                if (i2 != 0) continue;
                this.e.a((Document)var1_1, (Page)var4_5);
            }
        }
        Composer composer = this.d.composerForDocument((Document)var1_1);
        this.h.d("Processing", "(" + var1_1.getName() + ") Using composer: " + composer.getClass().getSimpleName());
        composer.composeDocument((Document)var1_1, (Page[])var2_2);
    }

    public DocumentProcessingResult processDocument(@NotNull DocumentDraft documentDraft) throws IOException {
        DocumentProcessor documentProcessor = this;
        Document document = documentDraft.getDocument();
        documentDraft = documentDraft.getPages();
        documentProcessor.a(document, documentDraft);
        documentProcessor.f.a(document);
        documentProcessor.c.evictAll();
        documentProcessor.g.cleanUpPagesData(documentDraft);
        return new DocumentProcessingResult(document, Arrays.asList(documentDraft), this.a.getDocumentFile(document.getId(), document.getName()));
    }

    private static class a {
        private final Resources a;
        private final DocumentStoreStrategy b;
        private PageStoreStrategy c;

        a(Resources resources, DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy) {
            this.a = resources;
            this.b = documentStoreStrategy;
            this.c = pageStoreStrategy;
        }

        /*
         * WARNING - void declaration
         */
        private void a(Document document, Page page) throws IOException {
            BitmapFactory.Options options;
            int n2 = (int)this.a.getDimension(R.dimen.document_thumbnail_size);
            BitmapFactory.Options options2 = options;
            options2();
            options2.inJustDecodeBounds = true;
            String string = this.c.getImageFile(page.getId(), Page.ImageType.OPTIMIZED).getPath();
            BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options2);
            int n3 = Math.max(options.outHeight, options2.outWidth) / n2;
            if (n3 < 1) {
                n3 = 1;
            }
            new BitmapFactory.Options().inSampleSize = n3;
            Bitmap bitmap = BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)new BitmapFactory.Options());
            if (BitmapUtils.isBitmapValid(bitmap)) {
                void var1_1;
                void var2_2;
                this.a(var2_2.getRotationType().getDegrees(), n2, bitmap, this.b.getThumbnailFile(var1_1.getId()));
            }
        }

        /*
         * WARNING - void declaration
         */
        private void a(int rotation2, int maxDimension2, Bitmap original, File file) throws FileNotFoundException {
            void var1_5;
            FileOutputStream fileOutputStream;
            Matrix matrix;
            Bitmap bitmap = original;
            float this322 = (float)maxDimension2 / (float)Math.max(original.getWidth(), original.getHeight());
            Matrix maxDimension2 = matrix;
            float f2 = this322;
            maxDimension2();
            maxDimension2.preRotate((float)rotation2, (float)(original.getWidth() / 2), (float)(original.getHeight() / 2));
            matrix.postScale(f2, f2);
            int this322 = bitmap.getWidth();
            rotation2 = bitmap.getHeight();
            Bitmap this322 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)this322, (int)rotation2, (Matrix)maxDimension2, (boolean)true);
            FileOutputStream rotation2 = fileOutputStream;
            rotation2(file);
            try {
                this322.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)var1_5);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((OutputStream)var1_5);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }
}

