/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.net.Uri;
import android.provider.MediaStore;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.CropOperation;
import io.scanbot.sdk.process.FilterOperation;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.process.Operation;
import io.scanbot.sdk.process.RotateOperation;
import io.scanbot.sdk.process.TuneOperation;
import io.scanbot.sdk.utils.PolygonHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.bitmap.BitmapUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ,\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J$\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0010J:\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00102\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\u001d\u001a\u00020\u0013H\u0002J\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ,\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J2\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0016\u0010\"\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0013J0\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010+\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/scanbot/sdk/process/PageProcessor;", "", "context", "Landroid/content/Context;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "imageProcessor", "Lio/scanbot/sdk/process/ImageProcessor;", "(Landroid/content/Context;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/process/ImageProcessor;)V", "applyFilter", "Lio/scanbot/sdk/persistence/Page;", "page", "filter", "Lio/scanbot/sdk/process/ImageFilterType;", "applyFilterTunes", "tunes", "", "Lio/scanbot/sdk/process/TuneOperation;", "filterOrder", "", "calculateRotationDegree", "times", "cropAndRotate", "polygon", "Landroid/graphics/PointF;", "cropApplyFiltersTunesFromPage", "Landroid/graphics/Bitmap;", "processor", "originalBitmap", "degrees", "detectDocument", "generateFilteredPreview", "getOperationsForFilterAndTunes", "Lio/scanbot/sdk/process/Operation;", "rotate", "rotateAndSavePageImage", "", "bitmap", "rotationDegree", "pageId", "", "pageType", "Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;", "scaleBitmapIfNeeded", "imageSizeLimit", "Lio/scanbot/sdk/persistence/Page$Size;", "sdk-bundle_release"})
public final class PageProcessor {
    private Context context;
    private final PageFileStorage pageFileStorage;
    private final ImageProcessor imageProcessor;

    @NotNull
    public final Page applyFilter(@NotNull Page page, @NotNull ImageFilterType filter) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
        return this.applyFilterTunes(page, filter, page.getTunes(), page.getFilterOrder());
    }

    @NotNull
    public final Page applyFilterTunes(@NotNull Page page, @NotNull ImageFilterType filter, @NotNull List<TuneOperation> tunes, int filterOrder) throws IOException {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(tunes, (String)"tunes");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Unfiltered document image does not exists for this page.");
        }
        Bitmap bitmap2 = bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"unfilteredDocumentBitmap");
        Bitmap bitmap3 = ImageProcessor.process$default(this.imageProcessor, bitmap2, this.getOperationsForFilterAndTunes(filterOrder, filter, tunes), false, 4, null);
        if (bitmap3 == null) {
            throw (Throwable)new IOException("Unable to apply filter and tunes");
        }
        Bitmap bitmap4 = bitmap3;
        this.pageFileStorage.setImageForId(bitmap4, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
        bitmap4.recycle();
        return Page.copy$default(page, null, null, null, filter, null, null, 0, 119, null);
    }

    @NotNull
    public final Bitmap generateFilteredPreview(@NotNull Page page, @NotNull ImageFilterType filter) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
        return this.generateFilteredPreview(page, filter, page.getTunes(), page.getFilterOrder());
    }

    @NotNull
    public final Bitmap generateFilteredPreview(@NotNull Page page, @NotNull ImageFilterType filter, @NotNull List<TuneOperation> tunes, int filterOrder) throws IOException {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(tunes, (String)"tunes");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Unfiltered document image does not exists for this page.");
        }
        Bitmap bitmap2 = bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"unfilteredDocumentBitmap");
        Bitmap bitmap3 = ImageProcessor.process$default(this.imageProcessor, bitmap2, this.getOperationsForFilterAndTunes(filterOrder, filter, tunes), false, 4, null);
        if (bitmap3 == null) {
            throw (Throwable)new IOException("Unable to generate filtered preview");
        }
        Bitmap bitmap4 = bitmap3;
        Bitmap bitmap5 = this.pageFileStorage.generateAndSetFilteredPreviewForId(bitmap4, page.getPageId(), filter);
        bitmap.recycle();
        bitmap4.recycle();
        return bitmap5;
    }

    @NotNull
    public final Page detectDocument(@NotNull Page page) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Original image does not exists for this page.");
        }
        Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        ContourDetector contourDetector = new ContourDetector();
        try {
            Bitmap bitmap2;
            DetectionResult detectionResult;
            if (contourDetector.detect(bitmap) == null) {
                Page page2 = page;
                return page2;
            }
            DetectionResult detectionResult2 = detectionResult;
            PageProcessor pageProcessor = this;
            ImageProcessor imageProcessor = pageProcessor.imageProcessor;
            Bitmap bitmap3 = bitmap;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"originalBitmap");
            List list = contourDetector.getPolygonF();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"detector.polygonF");
            Bitmap bitmap4 = PageProcessor.cropApplyFiltersTunesFromPage$default(pageProcessor, imageProcessor, bitmap3, list, page, 0, 16, null);
            Bitmap bitmap5 = page.getDocumentImageSizeLimit().getHeight() != Integer.MAX_VALUE && page.getDocumentImageSizeLimit().getWidth() != Integer.MAX_VALUE ? BitmapUtils.scaleIfNeeded((Bitmap)bitmap4, (int)page.getDocumentImageSizeLimit().getWidth(), (int)page.getDocumentImageSizeLimit().getHeight()) : bitmap4;
            if (bitmap5 == null) {
                throw (Throwable)new IOException("Unable to filter");
            }
            Bitmap bitmap6 = bitmap5;
            if (page.getFilter() != ImageFilterType.NONE) {
                List list2 = contourDetector.getPolygonF();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"detector.polygonF");
                bitmap2 = ImageProcessor.process$default(this.imageProcessor, bitmap, CollectionsKt.listOf((Object)new CropOperation(list2)), false, 4, null);
            } else {
                bitmap2 = bitmap6;
            }
            if (bitmap2 == null) {
                throw (Throwable)new IOException("Unable to filter");
            }
            Bitmap bitmap7 = bitmap2;
            this.pageFileStorage.setImageForId(bitmap6, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
            this.pageFileStorage.setImageForId(bitmap7, page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
            this.pageFileStorage.removeFilteredPreviewImages(page.getPageId());
            bitmap.recycle();
            bitmap6.recycle();
            bitmap7.recycle();
            Bitmap bitmap8 = bitmap4;
            if (bitmap8 != null) {
                bitmap8.recycle();
            }
            List list3 = contourDetector.getPolygonF();
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"detector.polygonF");
            Page page3 = Page.copy$default(page, null, list3, detectionResult2, null, null, null, 0, 121, null);
            return page3;
        }
        finally {
            contourDetector.dispose();
        }
    }

    @NotNull
    public final Page rotate(@NotNull Page page, int times) throws IOException {
        Object object;
        Bitmap bitmap;
        Bitmap bitmap2;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Original image does not exists for this page.");
        }
        int n2 = this.calculateRotationDegree(times);
        Bitmap bitmap3 = bitmap2 = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"originalBitmap");
        this.rotateAndSavePageImage(bitmap3, n2, page.getPageId(), PageFileStorage.PageFileType.ORIGINAL, this.imageProcessor);
        bitmap2.recycle();
        Uri uri2 = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
        if (new File(uri2.getPath()).exists()) {
            Bitmap bitmap4 = bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri2);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"documentBitmap");
            this.rotateAndSavePageImage(bitmap4, n2, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT, this.imageProcessor);
            bitmap.recycle();
        }
        bitmap = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (new File(uri2.getPath()).exists()) {
            Bitmap bitmap5 = object = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)bitmap);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap5, (String)"unfilteredDocumentBitmap");
            this.rotateAndSavePageImage(bitmap5, n2, page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT, this.imageProcessor);
            object.recycle();
        }
        this.pageFileStorage.removeFilteredPreviewImages(page.getPageId());
        object = page.getPolygon();
        if (!((Collection)object).isEmpty()) {
            object = PolygonHelper.Companion.rotatePolygon(page.getPolygon(), (float)n2);
        }
        return Page.copy$default(page, null, (List)object, null, null, null, null, 0, 125, null);
    }

    @NotNull
    public final Page cropAndRotate(@NotNull Page page, int times, @NotNull List<? extends PointF> polygon) throws IOException {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull(polygon, (String)"polygon");
        String string2 = page.getPageId();
        Uri uri = this.pageFileStorage.getImageURI(string2, PageFileStorage.PageFileType.ORIGINAL);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Original image does not exists for this page.");
        }
        int n2 = this.calculateRotationDegree(times);
        Bitmap bitmap2 = bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"originalBitmap");
        Bitmap bitmap3 = ImageProcessor.process$default(this.imageProcessor, bitmap2, CollectionsKt.listOf((Object[])new Operation[]{new CropOperation(polygon), new RotateOperation(n2)}), false, 4, null);
        if (bitmap3 == null) {
            throw (Throwable)new IOException("Unable to crop and rotate");
        }
        Bitmap bitmap4 = bitmap3;
        bitmap4 = this.scaleBitmapIfNeeded(bitmap4, page.getDocumentImageSizeLimit());
        this.pageFileStorage.setImageForId(bitmap4, string2, PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        bitmap4.recycle();
        PageProcessor pageProcessor = this;
        Bitmap bitmap5 = pageProcessor.cropApplyFiltersTunesFromPage(pageProcessor.imageProcessor, bitmap, polygon, page, n2);
        if (bitmap5 == null) {
            throw (Throwable)new IOException("Unable to filter");
        }
        Bitmap bitmap6 = bitmap5;
        bitmap6 = this.scaleBitmapIfNeeded(bitmap6, page.getDocumentImageSizeLimit());
        this.pageFileStorage.setImageForId(bitmap6, string2, PageFileStorage.PageFileType.DOCUMENT);
        bitmap6.recycle();
        this.rotateAndSavePageImage(bitmap, n2, string2, PageFileStorage.PageFileType.ORIGINAL, this.imageProcessor);
        bitmap.recycle();
        this.pageFileStorage.removeFilteredPreviewImages(string2);
        List list = polygon;
        if (!((Collection)list).isEmpty()) {
            list = PolygonHelper.Companion.rotatePolygon(polygon, (float)n2);
        }
        return Page.copy$default(page, null, list, null, null, null, null, 0, 125, null);
    }

    private final Bitmap cropApplyFiltersTunesFromPage(ImageProcessor processor, Bitmap originalBitmap, List<? extends PointF> polygon, Page page, int degrees) {
        List list = CollectionsKt.toMutableList((Collection)CollectionsKt.listOf((Object)new CropOperation(polygon)));
        list.addAll((Collection)this.getOperationsForFilterAndTunes(page.getFilterOrder(), page.getFilter(), page.getTunes()));
        if (degrees != 0) {
            list.add(new RotateOperation(degrees));
        }
        return ImageProcessor.process$default(processor, originalBitmap, list, false, 4, null);
    }

    static /* synthetic */ Bitmap cropApplyFiltersTunesFromPage$default(PageProcessor pageProcessor, ImageProcessor imageProcessor, Bitmap bitmap, List list, Page page, int n2, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n2 = 0;
        }
        return pageProcessor.cropApplyFiltersTunesFromPage(imageProcessor, bitmap, list, page, n2);
    }

    private final List<Operation> getOperationsForFilterAndTunes(int filterOrder, ImageFilterType filter, List<TuneOperation> tunes) {
        List list = new ArrayList();
        list.addAll(CollectionsKt.take((Iterable)tunes, (int)filterOrder));
        list.add(new FilterOperation(filter));
        List<TuneOperation> list2 = tunes;
        list.addAll(CollectionsKt.takeLast(list2, (int)(list2.size() - filterOrder)));
        return list;
    }

    static /* synthetic */ List getOperationsForFilterAndTunes$default(PageProcessor pageProcessor, int n2, ImageFilterType imageFilterType, List list, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 0;
        }
        if ((n3 & 2) != 0) {
            imageFilterType = ImageFilterType.NONE;
        }
        if ((n3 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return pageProcessor.getOperationsForFilterAndTunes(n2, imageFilterType, list);
    }

    private final int calculateRotationDegree(int times) {
        int n2 = -1 * times * 90;
        if (n2 < 0) {
            int n3 = Math.abs(n2);
            return 360 - n3 % 360;
        }
        return n2 % 360;
    }

    private final void rotateAndSavePageImage(Bitmap bitmap, int rotationDegree, String pageId, PageFileStorage.PageFileType pageType, ImageProcessor imageProcessor) {
        Bitmap bitmap2 = ImageProcessor.process$default(imageProcessor, bitmap, CollectionsKt.listOf((Object)new RotateOperation(rotationDegree)), false, 4, null);
        if (bitmap2 == null) {
            throw (Throwable)new IOException("Unable to rotate");
        }
        Bitmap bitmap3 = bitmap2;
        this.pageFileStorage.setImageForId(bitmap3, pageId, pageType);
        bitmap3.recycle();
    }

    private final Bitmap scaleBitmapIfNeeded(Bitmap bitmap, Page.Size imageSizeLimit) {
        if (imageSizeLimit.getHeight() != Integer.MAX_VALUE && imageSizeLimit.getWidth() != Integer.MAX_VALUE) {
            Bitmap bitmap2 = BitmapUtils.scaleIfNeeded((Bitmap)bitmap, (int)imageSizeLimit.getWidth(), (int)imageSizeLimit.getHeight());
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"BitmapUtils.scaleIfNeede\u2026h, imageSizeLimit.height)");
            return bitmap2;
        }
        return bitmap;
    }

    @Inject
    public PageProcessor(@NotNull Context context, @NotNull PageFileStorage pageFileStorage, @NotNull ImageProcessor imageProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkParameterIsNotNull((Object)imageProcessor, (String)"imageProcessor");
        this.context = context;
        this.pageFileStorage = pageFileStorage;
        this.imageProcessor = imageProcessor;
    }
}

