/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.View;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.ui.camera.BaseFinderOverlayView;
import io.scanbot.sdk.utils.PolygonHelper;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.doo.snap.camera.CameraPreviewMode;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.detector.PageAspectRatio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002JD\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000eH\u0004J\b\u0010\u001e\u001a\u00020\u0011H\u0016J\u0014\u0010\u001f\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/scanbot/sdk/ui/camera/FinderOverlayView;", "Lio/scanbot/sdk/ui/camera/BaseFinderOverlayView;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "contourDetectorFrameHandler", "Lnet/doo/snap/camera/ContourDetectorFrameHandler$ResultHandler;", "getContourDetectorFrameHandler", "()Lnet/doo/snap/camera/ContourDetectorFrameHandler$ResultHandler;", "finderAnimation", "Landroid/animation/AnimatorSet;", "requiredPageAspectRatios", "", "Lnet/doo/snap/lib/detector/PageAspectRatio;", "animatePaddingChanges", "", "paddingLeftRight", "", "paddingTopBottom", "handleDetectionResult", "requiredAspectRatios", "detectionResult", "Lnet/doo/snap/lib/detector/DetectionResult;", "frameWidth", "frameHeight", "frameOrientation", "polygon", "Landroid/graphics/PointF;", "setInitialFinderViewSize", "setRequiredAspectRatios", "sdk-bundle_release"})
public class FinderOverlayView
extends BaseFinderOverlayView {
    private AnimatorSet finderAnimation = new AnimatorSet();
    private List<? extends PageAspectRatio> requiredPageAspectRatios;
    @NotNull
    private final ContourDetectorFrameHandler.ResultHandler contourDetectorFrameHandler = new ContourDetectorFrameHandler.ResultHandler(){

        public final boolean handle(@NotNull FrameHandlerResult<? extends ContourDetectorFrameHandler.DetectedFrame, SdkLicenseError> result) {
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            if (result instanceof FrameHandlerResult.Success) {
                ContourDetectorFrameHandler.DetectedFrame detectedFrame = (ContourDetectorFrameHandler.DetectedFrame)((FrameHandlerResult.Success)result).getValue();
                List<PageAspectRatio> list = detectedFrame.requiredPageAspectRatios;
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"it.requiredPageAspectRatios");
                DetectionResult detectionResult = detectedFrame.detectionResult;
                Intrinsics.checkExpressionValueIsNotNull((Object)detectionResult, (String)"it.detectionResult");
                int n2 = detectedFrame.frameWidth;
                int n3 = detectedFrame.frameHeight;
                int n4 = detectedFrame.frameOrientation;
                List<PointF> list2 = detectedFrame.polygon;
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"it.polygon");
                this.handleDetectionResult(list, detectionResult, n2, n3, n4, list2);
            }
            return false;
        }
    };
    private HashMap _$_findViewCache;

    @NotNull
    public final ContourDetectorFrameHandler.ResultHandler getContourDetectorFrameHandler() {
        return this.contourDetectorFrameHandler;
    }

    public final void setRequiredAspectRatios(@NotNull List<? extends PageAspectRatio> requiredAspectRatios) {
        Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
        this.requiredPageAspectRatios = requiredAspectRatios;
        this.post(new Runnable(){

            @Override
            public final void run() {
                this.setInitialFinderViewSize();
            }
        });
    }

    public void setInitialFinderViewSize() {
        int n2;
        int n3;
        if (this.getFixedFinderWidthInPx() <= 0 || this.getFixedFinderHeightInPx() <= 0) {
            int n4;
            int n5;
            double d2;
            if (this.getInitialPreviewMode() == CameraPreviewMode.FIT_IN) {
                double d3;
                double d4 = this.getInitialPreviewWidth() == 0 || this.getInitialPreviewHeight() == 0 ? (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight() : (double)this.getInitialPreviewWidth() / (double)this.getInitialPreviewHeight();
                d2 = (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight();
                n5 = d3 < d4 ? this.getMeasuredWidth() : (int)((double)this.getMeasuredHeight() * d4);
                n4 = d2 < d4 ? (int)((double)this.getMeasuredWidth() / d4) : this.getMeasuredHeight();
            } else {
                n5 = this.getMeasuredWidth();
                n4 = this.getMeasuredHeight();
            }
            int n6 = n5 - 2 * this.getMinFinderPadding();
            int n7 = n4 - 2 * this.getMinFinderPadding();
            double d5 = d2 = (double)n6 / (double)n7;
            if (this.requiredPageAspectRatios != null) {
                List<? extends PageAspectRatio> list = this.requiredPageAspectRatios;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (!list.isEmpty()) {
                    List<? extends PageAspectRatio> list2 = this.requiredPageAspectRatios;
                    if (list2 == null) {
                        Intrinsics.throwNpe();
                    }
                    PageAspectRatio pageAspectRatio = list2.get(0);
                    d5 = pageAspectRatio.width / pageAspectRatio.height;
                }
            }
            if (d5 < d2) {
                double d6 = (double)n7 * d5;
                n3 = this.getMinFinderPadding() + (this.getMeasuredHeight() - n4) / 2;
                n2 = (int)(((double)n5 - d6) / 2.0) + (this.getMeasuredWidth() - n5) / 2;
            } else {
                double d7 = (double)n6 / d5;
                n3 = (int)(((double)n4 - d7) / 2.0) + (this.getMeasuredHeight() - n4) / 2;
                n2 = this.getMinFinderPadding() + (this.getMeasuredWidth() - n5) / 2;
            }
        } else {
            n3 = (this.getMeasuredHeight() - this.getFixedFinderHeightInPx()) / 2;
            n2 = (this.getMeasuredWidth() - this.getFixedFinderWidthInPx()) / 2;
        }
        this.setPadding(n2, n3, n2, n3);
        this.adjustDescriptionPosition(n3);
        this.invalidate();
    }

    protected final void handleDetectionResult(@NotNull List<? extends PageAspectRatio> requiredAspectRatios, @NotNull DetectionResult detectionResult, int frameWidth, int frameHeight, int frameOrientation, @NotNull List<? extends PointF> polygon) {
        block21: {
            block20: {
                Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
                Intrinsics.checkParameterIsNotNull((Object)detectionResult, (String)"detectionResult");
                Intrinsics.checkParameterIsNotNull(polygon, (String)"polygon");
                if (this.getFixedFinderWidthInPx() > 0 && this.getFixedFinderHeightInPx() > 0) {
                    return;
                }
                if (!requiredAspectRatios.isEmpty()) {
                    this.requiredPageAspectRatios = requiredAspectRatios;
                }
                if (this.requiredPageAspectRatios == null) break block20;
                List<? extends PageAspectRatio> list = this.requiredPageAspectRatios;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (!list.isEmpty() && !this.finderAnimation.isRunning()) break block21;
            }
            return;
        }
        if (polygon.size() > 0 && (detectionResult == DetectionResult.OK || detectionResult == DetectionResult.OK_BUT_BAD_ANGLES || detectionResult == DetectionResult.OK_BUT_BAD_ASPECT_RATIO || detectionResult == DetectionResult.OK_BUT_TOO_SMALL || detectionResult == DetectionResult.OK_OFF_CENTER)) {
            double d2;
            PageAspectRatio pageAspectRatio;
            Object object;
            double d3;
            Object object2;
            Ref.IntRef intRef;
            int n2;
            int n3;
            double d4;
            int n4;
            int n5;
            if (this.getInitialPreviewMode() == CameraPreviewMode.FIT_IN) {
                double d5;
                n5 = frameOrientation % 180 == 0 ? frameWidth : frameHeight;
                n4 = frameOrientation % 180 == 0 ? frameHeight : frameWidth;
                d4 = (double)n5 / (double)n4;
                double d6 = (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight();
                n3 = d5 < d4 ? this.getMeasuredWidth() : (int)((double)this.getMeasuredHeight() * d4);
                n2 = d6 < d4 ? (int)((double)this.getMeasuredWidth() / d4) : this.getMeasuredHeight();
            } else {
                n3 = this.getMeasuredWidth();
                n2 = this.getMeasuredHeight();
            }
            n5 = n3 - 2 * this.getMinFinderPadding();
            n4 = n2 - 2 * this.getMinFinderPadding();
            d4 = (double)n5 / (double)n4;
            float f2 = PolygonHelper.Companion.approximatePolygonAspectRatio(polygon, frameWidth, frameHeight, frameOrientation);
            List<? extends PageAspectRatio> list = this.requiredPageAspectRatios;
            if (list != null) {
                Object v3;
                intRef = ((Iterable)list).iterator();
                if (!intRef.hasNext()) {
                    v3 = null;
                } else {
                    object2 = intRef.next();
                    if (!intRef.hasNext()) {
                        v3 = object2;
                    } else {
                        PageAspectRatio pageAspectRatio2 = (PageAspectRatio)object2;
                        d3 = Math.abs((double)f2 - pageAspectRatio2.width / pageAspectRatio2.height);
                        do {
                            object = intRef.next();
                            PageAspectRatio pageAspectRatio3 = object;
                            double d7 = Math.abs((double)f2 - pageAspectRatio3.width / pageAspectRatio3.height);
                            if (Double.compare(d3, d7) <= 0) continue;
                            object2 = object;
                            d3 = d7;
                        } while (intRef.hasNext());
                        v3 = object2;
                    }
                }
                pageAspectRatio = v3;
            } else {
                pageAspectRatio = null;
            }
            if (pageAspectRatio != null) {
                object = pageAspectRatio;
                d2 = pageAspectRatio.width / object.height;
            } else {
                d2 = d4;
            }
            double d8 = d2;
            intRef = new Ref.IntRef();
            object2 = new Ref.IntRef();
            if (d8 < d4) {
                d3 = (double)n4 * d8;
                intRef.element = this.getMinFinderPadding() + (this.getMeasuredHeight() - n2) / 2;
                ((Ref.IntRef)object2).element = (int)(((double)n3 - d3) / 2.0) + (this.getMeasuredWidth() - n3) / 2;
            } else {
                d3 = (double)n5 / d8;
                intRef.element = (int)(((double)n2 - d3) / 2.0) + (this.getMeasuredHeight() - n2) / 2;
                ((Ref.IntRef)object2).element = this.getMinFinderPadding() + (this.getMeasuredWidth() - n3) / 2;
            }
            this.post(new Runnable((Ref.IntRef)object2, intRef){
                final /* synthetic */ Ref.IntRef b;
                final /* synthetic */ Ref.IntRef c;

                @Override
                public final void run() {
                    this.animatePaddingChanges(this.b.element, this.c.element);
                }
                {
                    this.b = intRef;
                    this.c = intRef2;
                }
            });
        }
    }

    private final void animatePaddingChanges(int paddingLeftRight, int paddingTopBottom) {
        if (this.getPaddingRight() == paddingLeftRight && this.getPaddingLeft() == paddingLeftRight && this.getPaddingTop() == paddingTopBottom && this.getPaddingBottom() == paddingTopBottom) {
            return;
        }
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.getPaddingRight(), paddingLeftRight});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n2 = this.getPaddingLeft();
                int n3 = this.getPaddingTop();
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.setPadding(n2, n3, (Integer)object, this.getPaddingBottom());
            }
        });
        ValueAnimator valueAnimator2 = ValueAnimator.ofInt((int[])new int[]{this.getPaddingLeft(), paddingLeftRight});
        valueAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.setPadding((Integer)object, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
            }
        });
        ValueAnimator valueAnimator3 = ValueAnimator.ofInt((int[])new int[]{this.getPaddingTop(), paddingTopBottom});
        valueAnimator3.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n2 = this.getPaddingLeft();
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.setPadding(n2, (Integer)object, this.getPaddingRight(), this.getPaddingBottom());
            }
        });
        ValueAnimator valueAnimator4 = ValueAnimator.ofInt((int[])new int[]{this.getPaddingBottom(), paddingTopBottom});
        valueAnimator4.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n2 = this.getPaddingLeft();
                int n3 = this.getPaddingTop();
                int n4 = this.getPaddingRight();
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.setPadding(n2, n3, n4, (Integer)object);
                Object object2 = valueAnimator.getAnimatedValue();
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.adjustDescriptionPosition((Integer)object2);
                this.invalidate();
            }
        });
        this.finderAnimation.end();
        this.finderAnimation.cancel();
        AnimatorSet animatorSet = this.finderAnimation = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{(Animator)valueAnimator, (Animator)valueAnimator2, (Animator)valueAnimator3, (Animator)valueAnimator4});
        animatorSet.setDuration(200L);
        animatorSet.start();
    }

    public FinderOverlayView(@Nullable Context context, @Nullable AttributeSet attr) {
        super(context, attr);
    }

    public View _$_findCachedViewById(int n2) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n2)) == null) {
            view = this.findViewById(n2);
            this._$_findViewCache.put(n2, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

