/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.graphics.PointF;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.FrameHandlerResult;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.doo.snap.camera.CameraStateCallback;
import net.doo.snap.camera.CameraTakePictureCallback;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.camera.sensor.SignificantMoveCatcher;
import net.doo.snap.camera.sensor.SignificantMoveListener;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;

public class AutoSnappingController {
    private static final long DEFAULT_CAPTURE_INTERVAL_MS = 1000L;
    private static final long MAXIMUM_CAPTURE_INTERVAL = 3000L;
    private static final int DELAY_AFTER_MOVE_MS = 2000;
    private static final int OK_DETECTIONS_COUNT_FOR_AUTOSNAP = 3;
    private static final double OK_DETECTIONS_THRESHOLD = 0.05;
    protected final ScanbotCameraView cameraView;
    protected final SignificantMoveCatcher significantMoveCatcher;
    protected final SignificantMoveListener significantMoveListener;
    private long lastSignificantMove = 0L;
    protected final AtomicLong captureInterval = new AtomicLong(1000L);
    protected final Logger logger = LoggerProvider.getLogger();
    protected long lastCapture = 0L;
    protected AtomicBoolean capturing = new AtomicBoolean(false);
    protected boolean ignoreBadAspectRatio = false;
    protected final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private boolean isAutoSnapEnabled = true;
    private AtomicBoolean isAutosnappingShooting = new AtomicBoolean(false);
    private AutoSnappingCallback autoSnappingCallback = AutoSnappingCallback.NULL;
    private final Runnable autosnappingShoot = new Runnable(){

        @Override
        public final void run() {
            boolean bl;
            boolean bl2 = bl = SystemClock.elapsedRealtime() - AutoSnappingController.this.lastSignificantMove <= 2000L;
            if (AutoSnappingController.this.isAutoSnapEnabled && !bl) {
                if (!AutoSnappingController.this.autoSnappingCallback.onAutoSnapping()) {
                    if (Build.VERSION.SDK_INT >= 24) {
                        AutoSnappingController.this.cameraView.takePicture(false);
                        return;
                    }
                    AutoSnappingController.this.cameraView.takePicture(true);
                    return;
                }
            } else {
                AutoSnappingController.this.isAutosnappingShooting.set(false);
            }
        }
    };
    private List<PointF> lastDetectedPolygon;
    private AtomicInteger okDetectionCounter = new AtomicInteger(0);

    public static AutoSnappingController attach(ScanbotCameraView cameraView) {
        ContourDetectorFrameHandler contourDetectorFrameHandler = new ContourDetectorFrameHandler(cameraView.getContext());
        return AutoSnappingController.attach(cameraView, contourDetectorFrameHandler);
    }

    public static AutoSnappingController attach(ScanbotCameraView cameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        return new AutoSnappingController(cameraView, contourDetectorFrameHandler);
    }

    public AutoSnappingController(ScanbotCameraView cameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        this(cameraView, (PreviewBuffer.FrameHandler)contourDetectorFrameHandler);
        contourDetectorFrameHandler.addResultHandler(new c(0));
    }

    protected AutoSnappingController(ScanbotCameraView cameraView, PreviewBuffer.FrameHandler frameHandler) {
        this.cameraView = cameraView;
        this.significantMoveCatcher = new SignificantMoveCatcher(cameraView.getContext().getApplicationContext());
        this.significantMoveListener = new SignificantMoveListenerImpl();
        cameraView.getPreviewBuffer().addFrameHandler(frameHandler);
        cameraView.addPictureCallback((PictureCallback)new d(0));
        cameraView.addCameraStateCallback((CameraStateCallback)new a(0));
        cameraView.addTakePictureCallback((CameraTakePictureCallback)new b(0));
    }

    protected void onDetectionOK(List<PointF> polygon) {
        if (!this.isAutosnappingShooting.get()) {
            this.checkDetectedPolygonAndSnap(polygon);
        }
    }

    private void checkDetectedPolygonAndSnap(List<PointF> polygon) {
        if (polygon == null || polygon.isEmpty() || this.okDetectionCounter.get() >= 3) {
            this.isAutosnappingShooting.set(true);
            this.mainThreadHandler.post(this.autosnappingShoot);
            this.okDetectionCounter.set(0);
            this.lastDetectedPolygon = null;
            return;
        }
        if (this.lastDetectedPolygon == null) {
            this.lastDetectedPolygon = polygon;
            return;
        }
        AutoSnappingController autoSnappingController = this;
        if (autoSnappingController.polygonsAreClose(autoSnappingController.lastDetectedPolygon, polygon)) {
            this.okDetectionCounter.incrementAndGet();
            return;
        }
        this.okDetectionCounter.set(0);
        this.lastDetectedPolygon = polygon;
    }

    private boolean polygonsAreClose(List<PointF> lastDetectedPolygon, List<PointF> polygon) {
        return (double)Math.abs(lastDetectedPolygon.get((int)0).x - polygon.get((int)0).x) < 0.05 && (double)Math.abs(lastDetectedPolygon.get((int)0).y - polygon.get((int)0).y) < 0.05 && (double)Math.abs(lastDetectedPolygon.get((int)2).x - polygon.get((int)2).x) < 0.05 && (double)Math.abs(lastDetectedPolygon.get((int)2).y - polygon.get((int)2).y) < 0.05;
    }

    public void setEnabled(boolean enabled) {
        this.isAutoSnapEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.isAutoSnapEnabled;
    }

    public void setSensitivity(float sensitivity) {
        this.logger.logMethod();
        float f2 = 1.0f - this.clamp(sensitivity);
        this.captureInterval.set((long)(f2 * 3000.0f));
    }

    public void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        this.logger.logMethod();
        this.ignoreBadAspectRatio = ignoreBadAspectRatio;
    }

    private float clamp(float value) {
        if (value < 0.0f) {
            return 0.0f;
        }
        if (value > 1.0f) {
            return 1.0f;
        }
        return value;
    }

    public void setAutoSnappingCallback(AutoSnappingCallback callback) {
        this.logger.logMethod();
        this.autoSnappingCallback = callback != null ? callback : AutoSnappingCallback.NULL;
    }

    private final class b
    implements CameraTakePictureCallback {
        private b() {
        }

        public final void onTakePictureRequested() {
        }

        public final void onTakePictureCancelled() {
            AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
        }

        /* synthetic */ b(byte by) {
            this();
        }
    }

    protected class SignificantMoveListenerImpl
    implements SignificantMoveListener {
        protected SignificantMoveListenerImpl() {
        }

        @Override
        public float getSignificantMoveThreshold() {
            return 0.6f;
        }

        @Override
        public void onSignificantMove() {
            AutoSnappingController.this.lastSignificantMove = SystemClock.elapsedRealtime();
            if (AutoSnappingController.this.capturing.get() && AutoSnappingController.this.isAutosnappingShooting.get()) {
                AutoSnappingController.this.cameraView.continuousFocus();
                AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
                AutoSnappingController.this.isAutosnappingShooting.set(false);
            }
        }
    }

    private final class a
    implements CameraStateCallback {
        private a() {
        }

        public final void onResume() {
            AutoSnappingController.this.capturing.set(true);
            AutoSnappingController.this.significantMoveCatcher.registerSignificantMoveListener(AutoSnappingController.this.significantMoveListener);
        }

        public final void onPause() {
            AutoSnappingController.this.significantMoveCatcher.unregisterSignificantMoveListener(AutoSnappingController.this.significantMoveListener);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
            AutoSnappingController.this.capturing.set(false);
            AutoSnappingController.this.lastCapture = 0L;
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }

    private final class d
    implements PictureCallback {
        private d() {
        }

        public final void onPictureTaken(byte[] image, int imageOrientation) {
            AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
        }

        /* synthetic */ d(byte by) {
            this();
        }
    }

    private final class c
    implements ContourDetectorFrameHandler.ResultHandler {
        private c() {
        }

        private void a(List<PointF> list) {
            AutoSnappingController.this.mainThreadHandler.post(new Runnable(list){
                final /* synthetic */ List a;
                {
                    this.a = list;
                }

                @Override
                public final void run() {
                    AutoSnappingController.this.onDetectionOK(this.a);
                }
            });
        }

        public final boolean handle(@NotNull FrameHandlerResult<? extends ContourDetectorFrameHandler.DetectedFrame, ? extends SdkLicenseError> result) {
            if (result instanceof FrameHandlerResult.Success) {
                ContourDetectorFrameHandler.DetectedFrame detectedFrame = (ContourDetectorFrameHandler.DetectedFrame)((FrameHandlerResult.Success)result).getValue();
                AutoSnappingController.this.logger.logMethod();
                if ((detectedFrame.detectionResult == DetectionResult.OK || AutoSnappingController.this.ignoreBadAspectRatio && detectedFrame.detectionResult == DetectionResult.OK_BUT_BAD_ASPECT_RATIO) && AutoSnappingController.this.capturing.get() && SystemClock.elapsedRealtime() - AutoSnappingController.this.lastCapture > AutoSnappingController.this.captureInterval.get()) {
                    if (AutoSnappingController.this.lastCapture != 0L) {
                        List<PointF> list = detectedFrame.polygon;
                        c c2 = this;
                        c2.AutoSnappingController.this.mainThreadHandler.post(new /* invalid duplicate definition of identical inner class */);
                    }
                    AutoSnappingController.this.lastCapture = SystemClock.elapsedRealtime();
                }
            }
            return false;
        }

        /* synthetic */ c(byte by) {
            this();
        }
    }

    public static interface AutoSnappingCallback {
        public static final AutoSnappingCallback NULL = new AutoSnappingCallback(){

            @Override
            public final boolean onAutoSnapping() {
                return false;
            }
        };

        public boolean onAutoSnapping();
    }
}

