/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.dcscanner;

import android.content.Context;
import io.scanbot.dcscanner.model.DisabilityCertificateRecognizerResultInfo;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.dcscanner.DCScanner;
import net.doo.snap.security.SapSingleton;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class DCScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private DCScanner dcScanner;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    private final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private boolean enabled = true;

    public static DCScannerFrameHandler attach(ScanbotCameraView cameraView, DCScanner dcScanner) {
        DCScannerFrameHandler dCScannerFrameHandler = new DCScannerFrameHandler(cameraView.getContext(), dcScanner);
        cameraView.getPreviewBuffer().addFrameHandler((PreviewBuffer.FrameHandler)dCScannerFrameHandler);
        return dCScannerFrameHandler;
    }

    public DCScannerFrameHandler(Context context, DCScanner dcScanner) {
        this.dcScanner = dcScanner;
        this.sapManager = SapSingleton.getInstance();
    }

    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame previewFrame) {
        this.logger.logMethod();
        if (!this.enabled) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.DisabilityCertRecognition).booleanValue()) {
            this.notifyHandlers((FrameHandlerResult<DisabilityCertificateRecognizerResultInfo, SdkLicenseError>)new FrameHandlerResult.Failure((Object)new SdkLicenseError()));
            return false;
        }
        DisabilityCertificateRecognizerResultInfo disabilityCertificateRecognizerResultInfo = this.dcScanner.recognizeDC(previewFrame.frame, previewFrame.width, previewFrame.height, previewFrame.frameOrientation);
        return this.notifyHandlers((FrameHandlerResult<DisabilityCertificateRecognizerResultInfo, SdkLicenseError>)new FrameHandlerResult.Success((Object)disabilityCertificateRecognizerResultInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(handler);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyHandlers(FrameHandlerResult<DisabilityCertificateRecognizerResultInfo, SdkLicenseError> result) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handle(result);
            }
        }
        return bl;
    }

    public static interface ResultHandler
    extends BaseResultHandler<DisabilityCertificateRecognizerResultInfo, SdkLicenseError> {
    }
}

