/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.payformscanner;

import android.content.Context;
import io.scanbot.payformscanner.PayFormScanner;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.payformscanner.PayFormScanner;
import net.doo.snap.security.SapSingleton;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class PayFormScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private PayFormScanner payFormScanner;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    private final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private boolean enabled = true;

    public static PayFormScannerFrameHandler attach(ScanbotCameraView cameraView, PayFormScanner payFormScanner) {
        PayFormScannerFrameHandler payFormScannerFrameHandler = new PayFormScannerFrameHandler(cameraView.getContext(), payFormScanner);
        cameraView.getPreviewBuffer().addFrameHandler((PreviewBuffer.FrameHandler)payFormScannerFrameHandler);
        return payFormScannerFrameHandler;
    }

    public PayFormScannerFrameHandler(Context context, PayFormScanner payFormScanner) {
        this.payFormScanner = payFormScanner;
        this.sapManager = SapSingleton.getInstance();
    }

    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame previewFrame) {
        this.logger.logMethod();
        if (!this.enabled) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.PayformDetection).booleanValue()) {
            this.notifyHandlers((FrameHandlerResult<PayFormScanner.DetectionResult, SdkLicenseError>)new FrameHandlerResult.Failure((Object)new SdkLicenseError()));
            return false;
        }
        PayFormScanner.DetectionResult detectionResult = this.payFormScanner.preVerifyForm(previewFrame.frame, previewFrame.width, previewFrame.height, previewFrame.frameOrientation);
        return this.notifyHandlers((FrameHandlerResult<PayFormScanner.DetectionResult, SdkLicenseError>)new FrameHandlerResult.Success((Object)detectionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(handler);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyHandlers(FrameHandlerResult<PayFormScanner.DetectionResult, SdkLicenseError> result) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handle(result);
            }
        }
        return bl;
    }

    public static interface ResultHandler
    extends BaseResultHandler<PayFormScanner.DetectionResult, SdkLicenseError> {
    }
}

