/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.inject.Inject;
import net.doo.snap.R;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.persistence.cleanup.Cleaner;
import net.doo.snap.process.DocumentProcessingResult;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.ComposerFactory;
import net.doo.snap.process.h;
import net.doo.snap.process.util.DocumentDraft;
import net.doo.snap.util.bitmap.BitmapLruCache;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class DocumentProcessor {
    private final DocumentStoreStrategy a;
    private final PageStoreStrategy b;
    private final BitmapLruCache c;
    private final ComposerFactory d;
    private final a e;
    private final h<Document> f;
    private final Cleaner g;
    private final Logger h = LoggerProvider.getLogger();

    @Inject
    public DocumentProcessor(DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, Resources resources, BitmapLruCache bitmapLruCache, ComposerFactory composerFactory, h<Document> documentProcessorMonitor, Cleaner cleaner) {
        this.a = documentStoreStrategy;
        this.b = pageStoreStrategy;
        this.c = bitmapLruCache;
        this.d = composerFactory;
        this.f = documentProcessorMonitor;
        this.g = cleaner;
        this.e = new a(resources, documentStoreStrategy, pageStoreStrategy);
    }

    public DocumentProcessingResult processDocument(@NotNull DocumentDraft documentDraft) throws IOException {
        Page[] pageArray;
        Document document = documentDraft.getDocument();
        Page[] pageArray2 = pageArray = documentDraft.getPages();
        Document document2 = document;
        DocumentProcessor documentProcessor = this;
        documentProcessor.a.ensureDocumentDirectory(document2.getId());
        if (document2.getSize() < 0L) {
            for (int i2 = 0; i2 < pageArray2.length; ++i2) {
                Page page = pageArray2[i2];
                if (i2 != 0) continue;
                net.doo.snap.process.DocumentProcessor$a.a(documentProcessor.e, document2, page);
            }
        }
        Composer composer = documentProcessor.d.composerForDocument(document2);
        documentProcessor.h.d("Processing", "(" + document2.getName() + ") Using composer: " + composer.getClass().getSimpleName());
        composer.composeDocument(document2, pageArray2);
        this.f.a(document);
        this.c.evictAll();
        this.g.cleanUpPagesData(pageArray);
        return new DocumentProcessingResult(document, Arrays.asList(pageArray), this.a.getDocumentFile(document.getId(), document.getName()));
    }

    private void a(Document document, Page[] pageArray) throws IOException {
        this.a.ensureDocumentDirectory(document.getId());
        if (document.getSize() < 0L) {
            for (int i2 = 0; i2 < pageArray.length; ++i2) {
                Page page = pageArray[i2];
                if (i2 != 0) continue;
                net.doo.snap.process.DocumentProcessor$a.a(this.e, document, page);
            }
        }
        Composer composer = this.d.composerForDocument(document);
        this.h.d("Processing", "(" + document.getName() + ") Using composer: " + composer.getClass().getSimpleName());
        composer.composeDocument(document, pageArray);
    }

    private static final class a {
        private final Resources a;
        private final DocumentStoreStrategy b;
        private PageStoreStrategy c;

        a(Resources resources, DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy) {
            this.a = resources;
            this.b = documentStoreStrategy;
            this.c = pageStoreStrategy;
        }

        private void a(Document document, Page page) throws IOException {
            int n2 = (int)this.a.getDimension(R.dimen.aO);
            BitmapFactory.Options options = new BitmapFactory.Options();
            new BitmapFactory.Options().inJustDecodeBounds = true;
            String string2 = this.c.getImageFile(page.getId(), Page.ImageType.OPTIMIZED).getPath();
            BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
            int n3 = Math.max(options.outHeight, options.outWidth) / n2;
            if (n3 <= 0) {
                n3 = 1;
            }
            BitmapFactory.Options options2 = new BitmapFactory.Options();
            new BitmapFactory.Options().inSampleSize = n3;
            Bitmap bitmap = BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options2);
            if (BitmapUtils.isBitmapValid((Bitmap)bitmap)) {
                File file = this.b.getThumbnailFile(document.getId());
                Bitmap bitmap2 = bitmap;
                int n4 = page.getRotationType().getDegrees();
                float f2 = (float)n2 / (float)Math.max(bitmap2.getWidth(), bitmap2.getHeight());
                Matrix matrix = new Matrix();
                matrix.preRotate((float)n4, (float)(bitmap2.getWidth() / 2), (float)(bitmap2.getHeight() / 2));
                float f3 = f2;
                matrix.postScale(f3, f3);
                Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)bitmap2.getWidth(), (int)bitmap2.getHeight(), (Matrix)matrix, (boolean)true);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    bitmap3.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fileOutputStream);
                    return;
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)fileOutputStream);
                }
            }
        }

        private static void a(int n2, int n3, Bitmap bitmap, File file) throws FileNotFoundException {
            float f2 = (float)n3 / (float)Math.max(bitmap.getWidth(), bitmap.getHeight());
            Matrix matrix = new Matrix();
            matrix.preRotate((float)n2, (float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2));
            float f3 = f2;
            matrix.postScale(f3, f3);
            Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fileOutputStream);
                return;
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
        }

        static /* synthetic */ void a(a a2, Document document, Page page) throws IOException {
            Page page2 = page;
            Document document2 = document;
            a a3 = a2;
            int n2 = (int)a3.a.getDimension(R.dimen.aO);
            BitmapFactory.Options options = new BitmapFactory.Options();
            new BitmapFactory.Options().inJustDecodeBounds = true;
            String string2 = a3.c.getImageFile(page2.getId(), Page.ImageType.OPTIMIZED).getPath();
            BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
            int n3 = Math.max(options.outHeight, options.outWidth) / n2;
            if (n3 <= 0) {
                n3 = 1;
            }
            BitmapFactory.Options options2 = new BitmapFactory.Options();
            new BitmapFactory.Options().inSampleSize = n3;
            Bitmap bitmap = BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options2);
            if (BitmapUtils.isBitmapValid((Bitmap)bitmap)) {
                File file = a3.b.getThumbnailFile(document2.getId());
                Bitmap bitmap2 = bitmap;
                int n4 = page2.getRotationType().getDegrees();
                float f2 = (float)n2 / (float)Math.max(bitmap2.getWidth(), bitmap2.getHeight());
                Matrix matrix = new Matrix();
                matrix.preRotate((float)n4, (float)(bitmap2.getWidth() / 2), (float)(bitmap2.getHeight() / 2));
                float f3 = f2;
                matrix.postScale(f3, f3);
                Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)bitmap2.getWidth(), (int)bitmap2.getHeight(), (Matrix)matrix, (boolean)true);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    bitmap3.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fileOutputStream);
                    return;
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)fileOutputStream);
                }
            }
        }
    }
}

