/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;

public class JpegComposer
implements Composer {
    private final DocumentStoreStrategy a;
    private final PageStoreStrategy b;
    private final Logger c = LoggerProvider.getLogger();

    @Inject
    public JpegComposer(DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy) {
        this.a = documentStoreStrategy;
        this.b = pageStoreStrategy;
    }

    public void composeDocument(Document document, Page ... pages) throws IOException {
        if (pages.length != 1) {
            throw new IllegalArgumentException("Composer can only take 1 page");
        }
        Page page = pages[0];
        Document document2 = document;
        JpegComposer jpegComposer = this;
        File file = jpegComposer.b.getImageFile(page.getId(), Page.ImageType.OPTIMIZED);
        File file2 = jpegComposer.a.getDocumentFile(document2.getId(), document2.getName());
        FileUtils.copyFile((File)file, (File)file2);
        int n2 = page.getRotationType().getDegrees();
        if (n2 != 0 && n2 != 360) {
            try {
                Bitmap bitmap = BitmapFactory.decodeFile((String)file2.getPath());
                if (bitmap == null) {
                    throw new IOException("Can't decode file into bitmap or path doesn't exist");
                }
                int n3 = bitmap.getWidth();
                int n4 = bitmap.getHeight();
                Matrix matrix = new Matrix();
                matrix.setRotate((float)n2, (float)(n3 / 2), (float)(n4 / 2));
                Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n3, (int)n4, (Matrix)matrix, (boolean)true);
                bitmap.recycle();
                BitmapUtils.compress((Bitmap)bitmap2, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG, (int)90, (File)file2);
                bitmap2.recycle();
                return;
            }
            catch (IOException | OutOfMemoryError throwable) {
                jpegComposer.c.logException(throwable);
            }
        }
    }

    private void a(Document document, Page page) throws IOException {
        File file = this.b.getImageFile(page.getId(), Page.ImageType.OPTIMIZED);
        File file2 = this.a.getDocumentFile(document.getId(), document.getName());
        FileUtils.copyFile((File)file, (File)file2);
        int n2 = page.getRotationType().getDegrees();
        if (n2 != 0 && n2 != 360) {
            try {
                Bitmap bitmap = BitmapFactory.decodeFile((String)file2.getPath());
                if (bitmap == null) {
                    throw new IOException("Can't decode file into bitmap or path doesn't exist");
                }
                int n3 = bitmap.getWidth();
                int n4 = bitmap.getHeight();
                Matrix matrix = new Matrix();
                matrix.setRotate((float)n2, (float)(n3 / 2), (float)(n4 / 2));
                Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n3, (int)n4, (Matrix)matrix, (boolean)true);
                bitmap.recycle();
                BitmapUtils.compress((Bitmap)bitmap2, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG, (int)90, (File)file2);
                bitmap2.recycle();
                return;
            }
            catch (IOException | OutOfMemoryError throwable) {
                this.c.logException(throwable);
            }
        }
    }
}

