/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import io.scanbot.multipleobjectsscanner.model.Polygon;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.multipleobjects.MultipleObjectsFrameHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.doo.snap.R;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.snap.PolygonHelper;

public class MultiplePolygonsView
extends View {
    private static final Property<Paint, Integer> PAINT_ALPHA_PROPERTY = Property.of(Paint.class, Integer.TYPE, (String)"alpha");
    private static final int POLYGON_FADE_OUT_DURATION_MS = 250;
    private List<float[]> listOfPoints = new ArrayList<float[]>();
    private Paint strokePaint;
    private Paint fillPaint;
    private Paint strokePaintOK;
    private Paint fillPaintOK;
    private boolean useFill = false;
    private boolean useFillOK = false;
    private Path path;
    public MultipleObjectsFrameHandler.ResultHandler multipleObjectDetectorHandler = new MultipleObjectsFrameHandler.ResultHandler(){

        public final boolean handle(FrameHandlerResult<? extends MultipleObjectsFrameHandler.DetectedData, ? extends SdkLicenseError> result) {
            if (result instanceof FrameHandlerResult.Success) {
                final MultipleObjectsFrameHandler.DetectedData detectedData = (MultipleObjectsFrameHandler.DetectedData)((FrameHandlerResult.Success)result).getValue();
                if (detectedData.getDetectedPolygons().isEmpty() && MultiplePolygonsView.this.listOfPoints.isEmpty()) {
                    return false;
                }
                if (MultiplePolygonsView.this.polygonUpdating.get()) {
                    return false;
                }
                MultiplePolygonsView.this.post(new Runnable(){

                    @Override
                    public final void run() {
                        MultiplePolygonsView.this.polygonUpdating.set(true);
                        MultiplePolygonsView.this.updatePolygon(detectedData.getDetectedPolygons());
                    }
                });
            }
            return false;
        }
    };
    private ObjectAnimator polygonAlphaAnimator;
    private PolygonHelper polygonHelper;
    private DetectionResult lastResult = DetectionResult.ERROR_NOTHING_DETECTED;
    protected AtomicBoolean polygonUpdating = new AtomicBoolean(false);

    public MultiplePolygonsView(Context context) {
        super(context);
        this.initView(context, null);
    }

    public MultiplePolygonsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        this.strokePaint = new Paint();
        this.strokePaint.setColor(-1);
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.strokePaint.setStrokeWidth(this.getResources().getDimension(R.dimen.bt));
        this.strokePaint.setAntiAlias(true);
        this.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
        this.fillPaint = new Paint();
        this.fillPaint.setColor(-16711936);
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.strokePaintOK = new Paint();
        this.strokePaintOK.setColor(-1);
        this.strokePaintOK.setStyle(Paint.Style.STROKE);
        this.strokePaintOK.setStrokeWidth(this.getResources().getDimension(R.dimen.bt));
        this.strokePaintOK.setAntiAlias(true);
        this.strokePaintOK.setStrokeCap(Paint.Cap.SQUARE);
        this.fillPaintOK = new Paint();
        this.fillPaintOK.setColor(-16711936);
        this.fillPaintOK.setStyle(Paint.Style.FILL);
        this.polygonHelper = new PolygonHelper();
        this.path = new Path();
        if (attrs != null) {
            this.loadAttributes(context, attrs);
        }
    }

    private void loadAttributes(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.gq);
        try {
            int n2 = typedArray.getColor(R.styleable.gr, 0);
            this.useFill = n2 != 0;
            this.fillPaint.setColor(n2);
            int n3 = typedArray.getColor(R.styleable.gt, -1);
            this.strokePaint.setColor(n3);
            int n4 = typedArray.getColor(R.styleable.gs, n2);
            this.useFillOK = n4 != 0;
            this.fillPaintOK.setColor(n4);
            int n5 = typedArray.getColor(R.styleable.gu, n3);
            this.strokePaintOK.setColor(n5);
            float f2 = typedArray.getDimension(R.styleable.gv, this.getResources().getDimension(R.dimen.bt));
            this.strokePaint.setStrokeWidth(f2);
            this.strokePaintOK.setStrokeWidth(f2);
            return;
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setFillColor(int fillColor) {
        this.useFill = fillColor != 0;
        this.fillPaint.setColor(fillColor);
        this.invalidate();
    }

    public void setFillColorOK(int fillColorOK) {
        this.useFillOK = fillColorOK != 0;
        this.fillPaintOK.setColor(fillColorOK);
        this.invalidate();
    }

    public void setStrokeColor(int strokeColor) {
        this.strokePaint.setColor(strokeColor);
        this.invalidate();
    }

    public void setStrokeColorOK(int strokeColorOK) {
        this.strokePaintOK.setColor(strokeColorOK);
        this.invalidate();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokePaint.setStrokeWidth(strokeWidth);
        this.strokePaintOK.setStrokeWidth(strokeWidth);
        this.invalidate();
    }

    protected void onSizeChanged(int w2, int h2, int oldw, int oldh) {
        super.onSizeChanged(w2, h2, oldw, oldh);
        this.polygonHelper.setLayout(0, 0, w2, h2);
    }

    protected void updatePolygon(List<Polygon> polygons) {
        if (polygons.isEmpty() && !this.listOfPoints.isEmpty()) {
            this.listOfPoints.clear();
            if (this.polygonAlphaAnimator != null) {
                this.polygonAlphaAnimator.cancel();
                this.polygonAlphaAnimator = null;
            }
            this.animatePolygonFadeOut();
        } else {
            this.strokePaint.setAlpha(255);
            this.listOfPoints.clear();
            for (Polygon polygon : polygons) {
                float[] fArray = new float[16];
                this.polygonHelper.polygonToPoints(polygon.getPolygonF(), fArray);
                this.listOfPoints.add(fArray);
                if (!this.useFill && !this.useFillOK) continue;
                this.updatePath();
            }
        }
        this.polygonUpdating.set(false);
        this.invalidate();
    }

    private void animatePolygonFadeOut() {
        this.polygonAlphaAnimator = ObjectAnimator.ofInt((Object)this.strokePaint, PAINT_ALPHA_PROPERTY, (int[])new int[]{0});
        this.polygonAlphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                MultiplePolygonsView.this.invalidate();
            }
        });
        this.polygonAlphaAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public final void onAnimationCancel(Animator animation) {
                MultiplePolygonsView.this.polygonUpdating.set(false);
                super.onAnimationCancel(animation);
            }

            public final void onAnimationEnd(Animator animation) {
                MultiplePolygonsView.this.polygonUpdating.set(false);
                super.onAnimationEnd(animation);
            }
        });
        this.polygonAlphaAnimator.setDuration(250L);
        this.polygonAlphaAnimator.start();
    }

    protected void dispatchDraw(Canvas canvas) {
        boolean bl;
        super.dispatchDraw(canvas);
        Paint paint = this.lastResult == DetectionResult.OK ? this.fillPaintOK : this.fillPaint;
        Paint paint2 = this.lastResult == DetectionResult.OK ? this.strokePaintOK : this.strokePaint;
        boolean bl2 = bl = this.lastResult == DetectionResult.OK ? this.useFillOK : this.useFill;
        if (!this.listOfPoints.isEmpty()) {
            if (bl) {
                canvas.drawPath(this.path, paint);
            }
            for (float[] fArray : this.listOfPoints) {
                canvas.drawLines(fArray, paint2);
            }
        }
    }

    private void updatePath() {
        this.path.rewind();
        for (float[] fArray : this.listOfPoints) {
            this.path.moveTo(fArray[0], fArray[1]);
            for (int i2 = 2; i2 < fArray.length; i2 += 2) {
                this.path.lineTo(fArray[i2], fArray[i2 + 1]);
            }
        }
    }
}

