/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.FrameHandlerResult;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.doo.snap.R;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.snap.PolygonHelper;
import org.jetbrains.annotations.NotNull;

public class PolygonView
extends View {
    private static final Property<Paint, Integer> PAINT_ALPHA_PROPERTY = Property.of(Paint.class, Integer.TYPE, (String)"alpha");
    private static final int POLYGON_FADE_OUT_DURATION_MS = 250;
    protected List<PointF> polygon;
    private float[] points;
    private float[] animationPoints;
    private Paint strokePaint;
    private Paint fillPaint;
    private Paint strokePaintOK;
    private Paint fillPaintOK;
    private boolean useFill = false;
    private boolean useFillOK = false;
    private Path path;
    private ValueAnimator polygonAnimator;
    private ObjectAnimator polygonAlphaAnimator;
    private a polygonEvaluator = new a(0);
    private PolygonHelper polygonHelper;
    private DetectionResult lastResult = DetectionResult.ERROR_NOTHING_DETECTED;
    protected AtomicBoolean polygonUpdating = new AtomicBoolean(false);
    public ContourDetectorFrameHandler.ResultHandler contourDetectorResultHandler = new ContourDetectorFrameHandler.ResultHandler(){

        public final boolean handle(@NotNull FrameHandlerResult<? extends ContourDetectorFrameHandler.DetectedFrame, ? extends SdkLicenseError> result) {
            if (result instanceof FrameHandlerResult.Success) {
                final ContourDetectorFrameHandler.DetectedFrame detectedFrame = (ContourDetectorFrameHandler.DetectedFrame)((FrameHandlerResult.Success)result).getValue();
                if (PolygonView.this.polygon == null && detectedFrame.polygon == null || PolygonView.this.polygon != null && PolygonView.this.polygon.equals(detectedFrame.polygon)) {
                    return false;
                }
                if (PolygonView.this.polygonUpdating.get()) {
                    return false;
                }
                PolygonView.this.post(new Runnable(){

                    @Override
                    public final void run() {
                        PolygonView.this.polygonUpdating.set(true);
                        PolygonView.this.updatePolygon(detectedFrame.detectionResult, detectedFrame.frameOrientation, detectedFrame.polygon);
                    }
                });
            }
            return false;
        }
    };

    public PolygonView(Context context) {
        super(context);
        this.initView(context, null);
    }

    public PolygonView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        this.strokePaint = new Paint();
        this.strokePaint.setColor(-1);
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.strokePaint.setStrokeWidth(this.getResources().getDimension(R.dimen.bt));
        this.strokePaint.setAntiAlias(true);
        this.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
        this.fillPaint = new Paint();
        this.fillPaint.setColor(-16711936);
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.strokePaintOK = new Paint();
        this.strokePaintOK.setColor(-1);
        this.strokePaintOK.setStyle(Paint.Style.STROKE);
        this.strokePaintOK.setStrokeWidth(this.getResources().getDimension(R.dimen.bt));
        this.strokePaintOK.setAntiAlias(true);
        this.strokePaintOK.setStrokeCap(Paint.Cap.SQUARE);
        this.fillPaintOK = new Paint();
        this.fillPaintOK.setColor(-16711936);
        this.fillPaintOK.setStyle(Paint.Style.FILL);
        this.points = new float[16];
        this.animationPoints = new float[this.points.length];
        this.polygonHelper = new PolygonHelper();
        this.polygon = Collections.emptyList();
        this.path = new Path();
        if (attrs != null) {
            this.loadAttributes(context, attrs);
        }
    }

    private void loadAttributes(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.gq);
        try {
            int n2 = typedArray.getColor(R.styleable.gr, 0);
            this.useFill = n2 != 0;
            this.fillPaint.setColor(n2);
            int n3 = typedArray.getColor(R.styleable.gt, -1);
            this.strokePaint.setColor(n3);
            int n4 = typedArray.getColor(R.styleable.gs, n2);
            this.useFillOK = n4 != 0;
            this.fillPaintOK.setColor(n4);
            int n5 = typedArray.getColor(R.styleable.gu, n3);
            this.strokePaintOK.setColor(n5);
            float f2 = typedArray.getDimension(R.styleable.gv, this.getResources().getDimension(R.dimen.bt));
            this.strokePaint.setStrokeWidth(f2);
            this.strokePaintOK.setStrokeWidth(f2);
            return;
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setFillColor(int fillColor) {
        this.useFill = fillColor != 0;
        this.fillPaint.setColor(fillColor);
        this.invalidate();
    }

    public void setFillColorOK(int fillColorOK) {
        this.useFillOK = fillColorOK != 0;
        this.fillPaintOK.setColor(fillColorOK);
        this.invalidate();
    }

    public void setStrokeColor(int strokeColor) {
        this.strokePaint.setColor(strokeColor);
        this.invalidate();
    }

    public void setStrokeColorOK(int strokeColorOK) {
        this.strokePaintOK.setColor(strokeColorOK);
        this.invalidate();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokePaint.setStrokeWidth(strokeWidth);
        this.strokePaintOK.setStrokeWidth(strokeWidth);
        this.invalidate();
    }

    protected void onSizeChanged(int w2, int h2, int oldw, int oldh) {
        super.onSizeChanged(w2, h2, oldw, oldh);
        this.polygonHelper.setLayout(0, 0, w2, h2);
    }

    protected void updatePolygon(DetectionResult detectionResult, int frameOrientation, List<PointF> polygon) {
        this.lastResult = detectionResult;
        this.polygonHelper.setRotation(frameOrientation);
        if (this.polygon.isEmpty()) {
            this.polygonHelper.polygonToPoints(polygon, this.points);
            if (this.useFill || this.useFillOK) {
                this.updatePath();
            }
            this.polygonUpdating.set(false);
        } else {
            this.animateToPolygon(polygon);
        }
        this.polygon = polygon;
        this.invalidate();
    }

    private void animateToPolygon(List<PointF> polygon) {
        if (this.polygonAnimator != null) {
            this.polygonAnimator.cancel();
            this.polygonAnimator = null;
        }
        if (this.polygonAlphaAnimator != null) {
            this.polygonAlphaAnimator.cancel();
            this.polygonAlphaAnimator = null;
        }
        if (polygon.isEmpty()) {
            this.animatePolygonFadeOut();
            return;
        }
        this.animateToNextPolygon();
    }

    private void animateToNextPolygon() {
        this.strokePaint.setAlpha(255);
        this.polygonHelper.polygonToPoints(this.polygon, this.animationPoints);
        this.polygonAnimator = ValueAnimator.ofObject((TypeEvaluator)this.polygonEvaluator, (Object[])new Object[]{this.points, this.animationPoints});
        this.polygonAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public final void onAnimationCancel(Animator animation) {
                PolygonView.this.polygonUpdating.set(false);
                super.onAnimationCancel(animation);
            }

            public final void onAnimationEnd(Animator animation) {
                PolygonView.this.polygonUpdating.set(false);
                super.onAnimationEnd(animation);
            }
        });
        this.polygonAnimator.start();
    }

    private void animatePolygonFadeOut() {
        this.polygonAlphaAnimator = ObjectAnimator.ofInt((Object)this.strokePaint, PAINT_ALPHA_PROPERTY, (int[])new int[]{0});
        this.polygonAlphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                PolygonView.this.invalidate();
            }
        });
        this.polygonAlphaAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public final void onAnimationCancel(Animator animation) {
                PolygonView.this.polygonUpdating.set(false);
                super.onAnimationCancel(animation);
            }

            public final void onAnimationEnd(Animator animation) {
                PolygonView.this.polygonUpdating.set(false);
                super.onAnimationEnd(animation);
            }
        });
        this.polygonAlphaAnimator.setDuration(250L);
        this.polygonAlphaAnimator.start();
    }

    protected void dispatchDraw(Canvas canvas) {
        boolean bl;
        super.dispatchDraw(canvas);
        Paint paint = this.lastResult == DetectionResult.OK ? this.fillPaintOK : this.fillPaint;
        Paint paint2 = this.lastResult == DetectionResult.OK ? this.strokePaintOK : this.strokePaint;
        boolean bl2 = bl = this.lastResult == DetectionResult.OK ? this.useFillOK : this.useFill;
        if (!this.polygon.isEmpty()) {
            if (bl) {
                canvas.drawPath(this.path, paint);
            }
            canvas.drawLines(this.points, paint2);
        }
    }

    private void updatePath() {
        this.path.rewind();
        this.path.moveTo(this.points[0], this.points[1]);
        for (int i2 = 2; i2 < this.points.length; i2 += 2) {
            this.path.lineTo(this.points[i2], this.points[i2 + 1]);
        }
    }

    private final class a
    implements TypeEvaluator {
        private a() {
        }

        public final Object evaluate(float fraction, Object startObj, Object endObj) {
            float[] fArray = (float[])endObj;
            float[] fArray2 = (float[])startObj;
            a a2 = this;
            for (int i2 = 0; i2 < a2.PolygonView.this.points.length; ++i2) {
                ((PolygonView)a2.PolygonView.this).points[i2] = fArray2[i2] + fraction * (fArray[i2] - fArray2[i2]);
            }
            if (a2.PolygonView.this.useFill || a2.PolygonView.this.useFillOK) {
                a2.PolygonView.this.updatePath();
            }
            a2.PolygonView.this.invalidate();
            return null;
        }

        private void a(float f2, float[] fArray, float[] fArray2) {
            for (int i2 = 0; i2 < PolygonView.this.points.length; ++i2) {
                ((PolygonView)PolygonView.this).points[i2] = fArray[i2] + f2 * (fArray2[i2] - fArray[i2]);
            }
            if (PolygonView.this.useFill || PolygonView.this.useFillOK) {
                PolygonView.this.updatePath();
            }
            PolygonView.this.invalidate();
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

