/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.utils.PolygonHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.R;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.detector.PageAspectRatio;
import net.doo.snap.security.SapSingleton;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class ContourDetectorFrameHandler
implements PreviewBuffer.FrameHandler {
    private final ContourDetector contourDetector;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    protected final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private final int finderInnerThresholdPx;
    private final int finderOuterThresholdPx;
    protected boolean enabled = true;
    private List<PageAspectRatio> requiredPageAspectRatios = null;

    public static ContourDetectorFrameHandler attach(ScanbotCameraView cameraView) {
        ContourDetectorFrameHandler contourDetectorFrameHandler;
        ContourDetectorFrameHandler contourDetectorFrameHandler2 = contourDetectorFrameHandler;
        contourDetectorFrameHandler2(cameraView.getContext());
        cameraView.getPreviewBuffer().addFrameHandler((PreviewBuffer.FrameHandler)contourDetectorFrameHandler2);
        return contourDetectorFrameHandler;
    }

    public ContourDetectorFrameHandler(Context context) {
        this.contourDetector = new ContourDetector();
        this.sapManager = SapSingleton.getInstance();
        this.finderInnerThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.I0);
        this.finderOuterThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.J0);
    }

    /*
     * WARNING - void declaration
     */
    private DetectionResult detectOffCenter(PreviewBuffer.FrameHandler.Frame previewFrame, DetectionResult detectionResult, List<PointF> polygon) {
        DetectionResult detectionResult2;
        Rect rect = previewFrame.finderRect;
        if (!(rect == null || rect.isEmpty() || detectionResult2 != DetectionResult.OK && detectionResult2 != DetectionResult.OK_BUT_BAD_ASPECT_RATIO && detectionResult2 != DetectionResult.OK_BUT_TOO_SMALL && detectionResult2 != DetectionResult.OK_BUT_BAD_ANGLES)) {
            Rect rect2;
            void var1_1;
            List list;
            list = PolygonHelper.rotatePolygon((List)list, (float)var1_1.frameOrientation);
            int n2 = var1_1.frameOrientation % 180 == 0 ? 1 : 0;
            int n3 = n2 != 0 ? var1_1.width : var1_1.height;
            n2 = n2 != 0 ? var1_1.height : var1_1.width;
            Rect rect3 = rect2;
            float f2 = n3;
            float f3 = n2;
            rect2 = new Rect((int)(((PointF)list.get((int)0)).x * f2), (int)(((PointF)list.get((int)0)).y * f3), (int)(((PointF)list.get((int)2)).x * f2), (int)(((PointF)list.get((int)2)).y * f3));
            if (this.checkOuterThreshold(var1_1.finderRect, rect3)) {
                detectionResult2 = DetectionResult.OK_OFF_CENTER;
            } else if (!this.requiredPageAspectRatios.isEmpty() && this.checkInnerThreshold(var1_1.finderRect, rect3)) {
                detectionResult2 = DetectionResult.OK_BUT_TOO_SMALL;
            }
        }
        return detectionResult2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkInnerThreshold(Rect finderRect, Rect polygonRect) {
        void var0_1;
        void var1_2;
        void var2_3;
        int this_ = this_.finderInnerThresholdPx;
        return polygonRect.left - finderRect.left > this_ || var2_3.top - var1_2.top > var0_1 || var1_2.bottom - var2_3.bottom > var0_1 || var1_2.right - var2_3.right > var0_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkOuterThreshold(Rect finderRect, Rect polygonRect) {
        void var0_1;
        void var2_3;
        void var1_2;
        int this_ = this_.finderOuterThresholdPx;
        return finderRect.left - polygonRect.left > this_ || var1_2.top - var2_3.top > var0_1 || var2_3.bottom - var1_2.bottom > var0_1 || var2_3.right - var1_2.right > var0_1;
    }

    /*
     * WARNING - void declaration
     */
    private void setRectOfInterest(int frameOrientation, RectF visibleRect) {
        if (visibleRect != null) {
            void var2_2;
            void var1_1;
            Matrix matrix;
            ContourDetectorFrameHandler contourDetectorFrameHandler = contourDetectorFrameHandler2;
            ContourDetectorFrameHandler contourDetectorFrameHandler2 = matrix;
            contourDetectorFrameHandler2();
            contourDetectorFrameHandler2.setRotate((float)var1_1, 0.5f, 0.5f);
            matrix.mapRect((RectF)var2_2);
            contourDetectorFrameHandler.contourDetector.setRectOfInterest((RectF)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fixRequiredAspectRatios(int frameOrientation) {
        ArrayList<PageAspectRatio> arrayList = this.requiredPageAspectRatios;
        if (arrayList != null && !arrayList.isEmpty()) {
            ArrayList<PageAspectRatio> arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<PageAspectRatio>();
            for (PageAspectRatio pageAspectRatio : this.requiredPageAspectRatios) {
                PageAspectRatio pageAspectRatio2;
                void var1_1;
                if (var1_1 % 180 == false) {
                    PageAspectRatio pageAspectRatio3;
                    pageAspectRatio2 = pageAspectRatio3;
                    pageAspectRatio3 = new PageAspectRatio(pageAspectRatio.width, pageAspectRatio.height);
                } else {
                    PageAspectRatio pageAspectRatio4;
                    pageAspectRatio2 = pageAspectRatio4;
                    pageAspectRatio4 = new PageAspectRatio(pageAspectRatio.height, pageAspectRatio.width);
                }
                arrayList.add(pageAspectRatio2);
            }
            this.contourDetector.setRequiredAspectRatios(arrayList);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame previewFrame) {
        DetectedFrame detectedFrame;
        void var1_1;
        ContourDetectorFrameHandler contourDetectorFrameHandler = this;
        contourDetectorFrameHandler.logger.logMethod();
        if (!contourDetectorFrameHandler.enabled) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.EdgeDetection).booleanValue()) {
            this.notifyHandlers((FrameHandlerResult<DetectedFrame, SdkLicenseError>)new FrameHandlerResult.Failure((Object)new SdkLicenseError()));
            return false;
        }
        ContourDetectorFrameHandler contourDetectorFrameHandler2 = this;
        ContourDetectorFrameHandler contourDetectorFrameHandler3 = this;
        this.fixRequiredAspectRatios(var1_1.frameOrientation);
        contourDetectorFrameHandler3.setRectOfInterest(var1_1.frameOrientation, var1_1.visibleRect);
        List list = this.contourDetector.getPolygonF();
        DetectionResult detectionResult = contourDetectorFrameHandler2.detectOffCenter((PreviewBuffer.FrameHandler.Frame)var1_1, contourDetectorFrameHandler3.contourDetector.detect(var1_1.frame, var1_1.width, var1_1.height), list);
        DetectedFrame detectedFrame2 = detectedFrame;
        detectedFrame = new DetectedFrame(detectionResult, list, var1_1.frameOrientation, var1_1.width, var1_1.height, this.contourDetector.getDetectionScore(), var1_1.finderRect, this.requiredPageAspectRatios);
        return contourDetectorFrameHandler2.notifyHandlers((FrameHandlerResult<DetectedFrame, SdkLicenseError>)new FrameHandlerResult.Success((Object)detectedFrame2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            void var1_1;
            this.handlers.add((ResultHandler)var1_1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            void var1_1;
            this.handlers.remove(var1_1);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        void var1_1;
        if (!(acceptedAngleScore < 0.0) && !(var1_1 > 100.0)) {
            this.contourDetector.setAcceptedAngleScore((double)var1_1);
            return;
        }
        throw new IllegalArgumentException("Invalid acceptedAngleScore value.");
    }

    /*
     * WARNING - void declaration
     */
    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        void var1_1;
        if (!(acceptedSizeScore < 0.0) && !(var1_1 > 100.0)) {
            this.contourDetector.setAcceptedSizeScore((double)var1_1);
            return;
        }
        throw new IllegalArgumentException("Invalid acceptedSizeScore value.");
    }

    public final void setRequiredAspectRatios(List<PageAspectRatio> requiredPageAspectRatios) {
        this.requiredPageAspectRatios = requiredPageAspectRatios;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected boolean notifyHandlers(FrameHandlerResult<DetectedFrame, SdkLicenseError> result) {
        ContourDetectorFrameHandler contourDetectorFrameHandler = this_;
        boolean this_ = false;
        Set<ResultHandler> set = contourDetectorFrameHandler.handlers;
        synchronized (set) {
            int n2;
            Iterator<ResultHandler> iterator = contourDetectorFrameHandler.handlers.iterator();
            while (true) {
                void var1_2;
                if (!iterator.hasNext()) break;
                n2 |= iterator.next().handle((FrameHandlerResult)var1_2);
                continue;
                break;
            }
            return n2 != 0;
        }
    }

    public static class DetectedFrame {
        public final DetectionResult detectionResult;
        public final List<PointF> polygon;
        public final int frameOrientation;
        public final int frameWidth;
        public final int frameHeight;
        public final double detectionScore;
        public final Rect finderRect;
        public final List<PageAspectRatio> requiredPageAspectRatios;

        @Deprecated
        public DetectedFrame(DetectionResult detectionResult, List<PointF> polygon, int frameOrientation, int frameWidth, int frameHeight) {
            DetectedFrame detectedFrame = this;
            this.detectionResult = detectionResult;
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            detectedFrame.polygon = Collections.unmodifiableList(polygon);
            detectedFrame.detectionScore = 0.0;
            detectedFrame.finderRect = null;
            detectedFrame.requiredPageAspectRatios = null;
        }

        public DetectedFrame(DetectionResult detectionResult, List<PointF> polygon, int frameOrientation, int frameWidth, int frameHeight, double detectionScore, Rect finderRect, List<PageAspectRatio> requiredPageAspectRatios) {
            this.detectionResult = detectionResult;
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.polygon = Collections.unmodifiableList(polygon);
            this.detectionScore = detectionScore;
            this.finderRect = finderRect;
            this.requiredPageAspectRatios = requiredPageAspectRatios;
        }
    }

    public static interface ResultHandler
    extends BaseResultHandler<DetectedFrame, SdkLicenseError> {
    }
}

