/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import net.doo.snap.R;
import net.doo.snap.ui.EditPolygonImageView;
import net.doo.snap.util.bitmap.BitmapUtils;

public class MagnifierView
extends View {
    private final float magnifierRaduis;
    private final float magnifierMargin;
    private final int magnifierDrawableResourceId;
    private a magnifier = new a();
    private PointF zoomPoint;
    private Bitmap magnifierFrameBitmap;
    private boolean enableBounding;

    public MagnifierView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.w5, 0, 0);
        try {
            this.magnifierDrawableResourceId = typedArray.getResourceId(R.styleable.y5, 0);
            this.magnifierRaduis = typedArray.getDimension(R.styleable.A5, this.getResources().getDimension(R.dimen.c1));
            this.magnifierMargin = typedArray.getDimension(R.styleable.z5, this.getResources().getDimension(R.dimen.b1));
            this.enableBounding = typedArray.getBoolean(R.styleable.x5, true);
        }
        catch (Throwable throwable) {
            typedArray.recycle();
            throw throwable;
        }
        typedArray.recycle();
    }

    void drawMagnifier(PointF zoomPoint) {
        this.zoomPoint = zoomPoint;
        this.invalidate();
    }

    void eraseMagnifier() {
        this.zoomPoint = null;
        this.invalidate();
    }

    public void setImageRotation(float rotation) {
        MagnifierView magnifierView = this;
        magnifierView.magnifier.a(rotation);
        magnifierView.invalidate();
    }

    public void setupMagnifier(EditPolygonImageView view) {
        MagnifierView magnifierView = this_;
        MagnifierView this_ = BitmapUtils.drawableToBitmap((Drawable)view.getDrawable());
        magnifierView.magnifier.a((Bitmap)this_, view.getRotation(), -16777216);
        view.setMagnifier(magnifierView);
    }

    /*
     * WARNING - void declaration
     */
    protected void dispatchDraw(Canvas canvas) {
        void var1_1;
        MagnifierView magnifierView = this;
        super.dispatchDraw(canvas);
        PointF pointF = magnifierView.zoomPoint;
        if (pointF != null) {
            this.magnifier.a((Canvas)var1_1, pointF);
        } else {
            var1_1.drawColor(0);
        }
    }

    public void onAttachedToWindow() {
        BitmapFactory.Options options;
        MagnifierView magnifierView = this;
        super.onAttachedToWindow();
        BitmapFactory.Options options2 = options;
        new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
        magnifierView.magnifierFrameBitmap = BitmapFactory.decodeResource((Resources)magnifierView.getResources(), (int)this.magnifierDrawableResourceId, (BitmapFactory.Options)options2);
        if (magnifierView.magnifierFrameBitmap == null) {
            this.magnifierFrameBitmap = BitmapUtils.drawableToBitmap((Drawable)this.getResources().getDrawable(this.magnifierDrawableResourceId));
        }
    }

    public void onDetachedFromWindow() {
        MagnifierView magnifierView = this;
        super.onDetachedFromWindow();
        magnifierView.magnifierFrameBitmap.recycle();
        magnifierView.magnifierFrameBitmap = null;
        magnifierView.magnifier.a();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        MagnifierView magnifierView = this;
        super.onLayout(changed, left, top, right, bottom);
        magnifierView.magnifier.a(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
    }

    public void setEnableBounding(boolean enableBounding) {
        this.enableBounding = enableBounding;
    }

    private class a {
        private final float a;
        private float b;
        private int c;
        private int d;
        private BitmapShader e;
        private Paint f;
        private Matrix g = new Matrix();
        private float h;
        private float i;
        private float j;
        private Bitmap k;

        a() {
            this.a = 2.0f;
        }

        private Bitmap a(Bitmap bitmap3, int outlineColor2) {
            Paint paint;
            Canvas canvas;
            a this_ = canvas;
            Bitmap bitmap2 = bitmap3;
            this_(bitmap3);
            this_ = paint;
            this_();
            paint.setColor(outlineColor2);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(0.0f);
            float bitmap3 = bitmap2.getWidth() - 1;
            float outlineColor2 = bitmap2.getHeight() - 1;
            canvas.drawRect(0.0f, 0.0f, bitmap3, outlineColor2, (Paint)this_);
            return bitmap3;
        }

        /*
         * WARNING - void declaration
         */
        private boolean a(PointF point) {
            void var1_1;
            return (int)((float)(point.x + this.h < (float)(this.k.getWidth() >> 1) ? (var1_1.y + this.i < (float)(this.k.getHeight() >> 1) ? 1 : 4) : (var1_1.y + this.i < (float)(this.k.getHeight() >> 1) ? 2 : 3)) - (360.0f - this.j) % 360.0f / 90.0f) == 1;
        }

        /*
         * WARNING - void declaration
         */
        void a(int width, int height) {
            void var2_2;
            void var1_1;
            this.c = width;
            this.d = height;
            Bitmap bitmap = this.k;
            if (bitmap != null && var1_1 != false && var2_2 != false) {
                a a2 = this;
                a2.b = Math.max((float)bitmap.getWidth() / (float)this.c, (float)this.k.getHeight() / (float)this.d);
                a2.h = ((float)a2.c - (float)this.k.getWidth() / this.b) / 2.0f;
                a2.i = ((float)a2.d - (float)this.k.getHeight() / this.b) / 2.0f;
            }
        }

        /*
         * WARNING - void declaration
         */
        void a(Bitmap bitmap, float rotation, int outsideColor) {
            if (BitmapUtils.isBitmapValid((Bitmap)bitmap)) {
                void var2_2;
                void var3_3;
                void var1_1;
                if (this.e != null) {
                    this.a();
                }
                a a2 = this;
                a a3 = this;
                a3.k = a3.a((Bitmap)var1_1, (int)var3_3);
                Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                a3.e = new BitmapShader(this.k, tileMode, tileMode);
                a3.f = new Paint();
                a3.f.setShader((Shader)this.e);
                a2.j = var2_2;
                a2.a(a2.MagnifierView.this.getWidth() - MagnifierView.this.getPaddingLeft() - MagnifierView.this.getPaddingRight(), MagnifierView.this.getHeight() - MagnifierView.this.getPaddingTop() - MagnifierView.this.getPaddingBottom());
            }
        }

        void a() {
            Bitmap bitmap = this.k;
            if (bitmap != null) {
                bitmap.recycle();
            }
            a a2 = this;
            a2.k = null;
            a2.f = null;
            a2.e = null;
        }

        /*
         * WARNING - void declaration
         */
        void a(Canvas canvas, PointF zoomPointF2) {
            void var1_1;
            float f2;
            PointF pointF;
            a a2 = this;
            PointF pointF2 = pointF;
            pointF = new PointF(zoomPointF2.x * (float)this.k.getWidth(), zoomPointF2.y * (float)this.k.getHeight());
            float zoomPointF2 = a2.MagnifierView.this.magnifierMargin;
            float f3 = a2.MagnifierView.this.magnifierMargin;
            if (a2.MagnifierView.this.enableBounding && this.a(pointF2)) {
                f2 = (float)MagnifierView.this.getWidth() - MagnifierView.this.magnifierRaduis * 2.0f - MagnifierView.this.magnifierMargin;
            }
            void v2 = var1_1;
            a a3 = this;
            a3.g.setScale(2.0f, 2.0f);
            a3.g.postTranslate(-pointF2.x * 2.0f + MagnifierView.this.magnifierRaduis + f2, -pointF2.y * 2.0f + MagnifierView.this.magnifierRaduis + f3);
            a3.e.setLocalMatrix(this.g);
            var1_1.save();
            var1_1.rotate(this.j, f2 + MagnifierView.this.magnifierRaduis, f3 + MagnifierView.this.magnifierRaduis);
            v2.drawCircle((float)(f2 + MagnifierView.this.magnifierRaduis), f3 + MagnifierView.this.magnifierRaduis, MagnifierView.this.magnifierRaduis, this.f);
            v2.restore();
            var1_1.drawBitmap(MagnifierView.this.magnifierFrameBitmap, f2, f3, null);
        }

        void a(float rotation) {
            this.j = rotation;
        }
    }
}

