/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.content.Context;
import android.net.Uri;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.PDFPageSize;
import io.scanbot.sdk.process.PDFRenderer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.entity.SnappingDraft;
import net.doo.snap.persistence.PageFactory;
import net.doo.snap.persistence.cleanup.Cleaner;
import net.doo.snap.process.DocumentProcessingResult;
import net.doo.snap.process.DocumentProcessor;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.process.util.DocumentDraft;
import net.doo.snap.util.FileChooserUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u0004\u0018\u00010\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/scanbot/sdk/process/ScanbotPDFRenderer;", "Lio/scanbot/sdk/process/PDFRenderer;", "context", "Landroid/content/Context;", "documentDraftExtractor", "Lnet/doo/snap/process/draft/DocumentDraftExtractor;", "pageFactory", "Lnet/doo/snap/persistence/PageFactory;", "documentProcessor", "Lnet/doo/snap/process/DocumentProcessor;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "cleaner", "Lnet/doo/snap/persistence/cleanup/Cleaner;", "sapManager", "Lio/scanbot/sap/SapManager;", "(Landroid/content/Context;Lnet/doo/snap/process/draft/DocumentDraftExtractor;Lnet/doo/snap/persistence/PageFactory;Lnet/doo/snap/process/DocumentProcessor;Lio/scanbot/sdk/persistence/PageFileStorage;Lnet/doo/snap/persistence/cleanup/Cleaner;Lio/scanbot/sap/SapManager;)V", "renderDocumentFromImages", "Ljava/io/File;", "imageFileUris", "", "Landroid/net/Uri;", "pageSize", "Lio/scanbot/sdk/process/PDFPageSize;", "renderDocumentFromPages", "pages", "Lio/scanbot/sdk/persistence/Page;", "sdk-bundle_release"})
public final class ScanbotPDFRenderer
implements PDFRenderer {
    private final Context context;
    private final DocumentDraftExtractor documentDraftExtractor;
    private final PageFactory pageFactory;
    private final DocumentProcessor documentProcessor;
    private final PageFileStorage pageFileStorage;
    private final Cleaner cleaner;
    private final SapManager sapManager;

    @Inject
    public ScanbotPDFRenderer(@NotNull Context context, @NotNull DocumentDraftExtractor documentDraftExtractor, @NotNull PageFactory pageFactory, @NotNull DocumentProcessor documentProcessor, @NotNull PageFileStorage pageFileStorage, @NotNull Cleaner cleaner, @NotNull SapManager sapManager) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)documentDraftExtractor, (String)"documentDraftExtractor");
        Intrinsics.checkParameterIsNotNull((Object)pageFactory, (String)"pageFactory");
        Intrinsics.checkParameterIsNotNull((Object)documentProcessor, (String)"documentProcessor");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkParameterIsNotNull((Object)cleaner, (String)"cleaner");
        Intrinsics.checkParameterIsNotNull((Object)sapManager, (String)"sapManager");
        this.context = context;
        this.documentDraftExtractor = documentDraftExtractor;
        this.pageFactory = pageFactory;
        this.documentProcessor = documentProcessor;
        this.pageFileStorage = pageFileStorage;
        this.cleaner = cleaner;
        this.sapManager = sapManager;
    }

    @Override
    @Nullable
    public File renderDocumentFromImages(@NotNull List<? extends Uri> imageFileUris, @NotNull PDFPageSize pageSize) {
        block16: {
            SnappingDraft snappingDraft;
            SnappingDraft snappingDraft2;
            ArrayList<net.doo.snap.entity.Page> arrayList;
            Object object;
            Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
            Intrinsics.checkParameterIsNotNull((Object)pageSize, (String)"pageSize");
            if (!this.sapManager.checkLicenseStatus(SdkFeature.PDFCreation).booleanValue()) {
                return null;
            }
            void v02 = object;
            ArrayList<net.doo.snap.entity.Page> arrayList2 = arrayList;
            arrayList = new ArrayList<net.doo.snap.entity.Page>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            object = v02.iterator();
            while (true) {
                if (!object.hasNext()) break;
                ArrayList<net.doo.snap.entity.Page> arrayList3 = arrayList2;
                ScanbotPDFRenderer scanbotPDFRenderer = this;
                Uri uri = (Uri)object.next();
                net.doo.snap.entity.Page page = scanbotPDFRenderer.pageFactory.buildPage(new File(FileChooserUtils.getPath(this.context, uri)));
                Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"page");
                page.setPageSize((PDFPageSize)snappingDraft2);
                arrayList3.add(page);
            }
            try {
                object = arrayList2.toArray(new net.doo.snap.entity.Page[0]);
                if (object == null) break block16;
            }
            catch (Throwable throwable) {
                this.cleaner.cleanUp();
                throw throwable;
            }
            ScanbotPDFRenderer scanbotPDFRenderer = this;
            ScanbotPDFRenderer scanbotPDFRenderer2 = scanbotPDFRenderer;
            ScanbotPDFRenderer scanbotPDFRenderer3 = scanbotPDFRenderer;
            object = Arrays.copyOf(object, ((net.doo.snap.entity.Page[])object).length);
            snappingDraft2 = snappingDraft;
            new SnappingDraft((net.doo.snap.entity.Page[])object).setDocumentName(UUID.randomUUID().toString());
            object = scanbotPDFRenderer2.documentDraftExtractor.extract(snappingDraft2);
            object = scanbotPDFRenderer3.documentProcessor.processDocument((DocumentDraft)object[0]);
            if (object != null) {
                this.cleaner.cleanUpDocumentThumbnail(((DocumentProcessingResult)object).getDocument());
            }
            this.cleaner.cleanUp();
            return object != null ? ((DocumentProcessingResult)object).getDocumentFile() : null;
        }
        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
    }

    @Override
    @Nullable
    public File renderDocumentFromPages(@NotNull List<Page> pages, @NotNull PDFPageSize pageSize) {
        block16: {
            SnappingDraft snappingDraft;
            SnappingDraft snappingDraft2;
            ArrayList<net.doo.snap.entity.Page> arrayList;
            Object object;
            Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
            Intrinsics.checkParameterIsNotNull((Object)pageSize, (String)"pageSize");
            if (!this.sapManager.checkLicenseStatus(SdkFeature.PDFCreation).booleanValue()) {
                return null;
            }
            void v02 = object;
            ArrayList<net.doo.snap.entity.Page> arrayList2 = arrayList;
            arrayList = new ArrayList<net.doo.snap.entity.Page>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            object = v02.iterator();
            while (true) {
                if (!object.hasNext()) break;
                ArrayList<net.doo.snap.entity.Page> arrayList3 = arrayList2;
                ScanbotPDFRenderer scanbotPDFRenderer = this;
                Page page = (Page)object.next();
                net.doo.snap.entity.Page page2 = scanbotPDFRenderer.pageFactory.buildPage(page.getPageId(), new File(this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
                net.doo.snap.entity.Page page3 = page2;
                Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
                page3.setPageSize((PDFPageSize)snappingDraft2);
                page3.setProcessed(false);
                page2.setImageFilterType(page.getFilter());
                page2.setPolygon(page.getPolygon());
                arrayList3.add(page2);
            }
            try {
                object = arrayList2.toArray(new net.doo.snap.entity.Page[0]);
                if (object == null) break block16;
            }
            catch (Throwable throwable) {
                this.cleaner.cleanUp();
                throw throwable;
            }
            ScanbotPDFRenderer scanbotPDFRenderer = this;
            ScanbotPDFRenderer scanbotPDFRenderer2 = scanbotPDFRenderer;
            ScanbotPDFRenderer scanbotPDFRenderer3 = scanbotPDFRenderer;
            object = Arrays.copyOf(object, ((net.doo.snap.entity.Page[])object).length);
            snappingDraft2 = snappingDraft;
            new SnappingDraft((net.doo.snap.entity.Page[])object).setDocumentName(UUID.randomUUID().toString());
            object = scanbotPDFRenderer2.documentDraftExtractor.extract(snappingDraft2);
            object = scanbotPDFRenderer3.documentProcessor.processDocument((DocumentDraft)object[0]);
            if (object != null) {
                this.cleaner.cleanUpDocumentThumbnail(((DocumentProcessingResult)object).getDocument());
            }
            this.cleaner.cleanUp();
            return object != null ? ((DocumentProcessingResult)object).getDocumentFile() : null;
        }
        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
    }
}

