/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.draft;

import android.content.SharedPreferences;
import java.util.UUID;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.entity.SnappingDraft;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.process.util.DocumentDraft;

public class MultipleDocumentsDraftExtractor
implements DocumentDraftExtractor {
    private final String a;

    public static MultipleDocumentsDraftExtractor forPdf() {
        return new MultipleDocumentsDraftExtractor(".pdf");
    }

    public static MultipleDocumentsDraftExtractor forJpeg() {
        return new MultipleDocumentsDraftExtractor(".jpg");
    }

    @Inject
    public MultipleDocumentsDraftExtractor(SharedPreferences sharedPreferences) {
        String string = sharedPreferences.getBoolean("SAVE_SINGLE_AS_JPEG", false) ? ".jpg" : ".pdf";
        this(string);
    }

    private MultipleDocumentsDraftExtractor(String extension) {
        this.a = extension;
    }

    private Document a(String name, int size) {
        Document document;
        MultipleDocumentsDraftExtractor multipleDocumentsDraftExtractor = this = document;
        multipleDocumentsDraftExtractor();
        multipleDocumentsDraftExtractor.setId(UUID.randomUUID().toString());
        this.setName(name);
        document.setPagesCount(size);
        document.setOcrStatus(OcrStatus.NOT_SCHEDULED);
        return document;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DocumentDraft[] extract(SnappingDraft draft) {
        DocumentDraft[] documentDraftArray = new DocumentDraft[draft.size()];
        for (int i2 = 0; i2 < documentDraftArray.length; ++i2) {
            void var1_1;
            Document document = this.a(var1_1.getDocumentName() + this.a, 1);
            documentDraftArray[i2] = new DocumentDraft(document, var1_1.getPage(i2));
        }
        return documentDraftArray;
    }
}

