/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.snap;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import java.util.ArrayList;
import java.util.List;
import net.doo.snap.lib.detector.Line2D;

public class PolygonHelper {
    private static final int MIN_EDGE_LENGTH_PX = 35;
    private float[] tmpPoints = new float[8];
    private Matrix matrix = new Matrix();
    private int width;
    private int height;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int rotation = 0;

    public static boolean checkPolygonSize(List<Point> polygon) {
        List<Point> list;
        return !polygon.isEmpty() && Math.abs(list.get((int)1).x - list.get((int)0).x) > 35 && Math.abs(list.get((int)2).x - list.get((int)3).x) > 35 && Math.abs(list.get((int)3).y - list.get((int)0).y) > 35 && Math.abs(list.get((int)2).y - list.get((int)1).y) > 35;
    }

    /*
     * WARNING - void declaration
     */
    public void setRotation(int degrees) {
        void var1_1;
        if (this.rotation == degrees) {
            return;
        }
        this.rotation = var1_1;
        this.matrix.setRotate((float)var1_1, 0.5f, 0.5f);
    }

    public void setImageSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setLayout(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.width = right - left;
        this.height = bottom - top;
    }

    /*
     * WARNING - void declaration
     */
    public void polygonToPoints(List<PointF> polygon, float[] points) {
        void var1_1;
        int n2;
        for (n2 = 0; n2 < var1_1.size(); ++n2) {
            PolygonHelper polygonHelper = this;
            int n3 = n2 * 2;
            polygonHelper.tmpPoints[n3] = ((PointF)var1_1.get((int)n2)).x;
            polygonHelper.tmpPoints[n3 + 1] = ((PointF)var1_1.get((int)n2)).y;
        }
        this.matrix.mapPoints(this.tmpPoints);
        for (n2 = 0; n2 < var1_1.size(); ++n2) {
            int n4;
            int n5 = n2 * 4;
            int n6 = n4 = n5;
            int n7 = n4;
            int n8 = n4;
            PolygonHelper polygonHelper = this;
            n4 = polygonHelper.left;
            float f2 = n4;
            int n9 = polygonHelper.width;
            float[] fArray = this.tmpPoints;
            int n10 = n2 * 2;
            var2_2[n8] = (float)n9 * this.tmpPoints[n10] + f2;
            PolygonHelper polygonHelper2 = this;
            int n11 = polygonHelper2.top;
            float f3 = n11;
            int n12 = polygonHelper2.height;
            var2_2[n7 + 1] = (float)n12 * fArray[n10 + 1] + f3;
            float f4 = n4;
            var2_2[n6 + 2] = (float)n9 * fArray[(n10 + 2) % 8] + f4;
            f4 = n11;
            var2_2[n5 + 3] = (float)n12 * fArray[(n10 + 3) % 8] + f4;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getDrawingPolygon(List<PointF> polygon, List<PointF> drawingPolygon) {
        void var2_2;
        for (int i2 = 0; i2 < var2_2.size(); ++i2) {
            void var1_1;
            PointF pointF = (PointF)var1_1.get(i2);
            PointF pointF2 = (PointF)var2_2.get(i2);
            pointF2.x = pointF.x * (float)this.width;
            pointF2.y = pointF.y * (float)this.height;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getPolygonFromDrawingPolygon(List<PointF> drawingPolygon, List<PointF> polygon) {
        void var1_1;
        for (int i2 = 0; i2 < var1_1.size(); ++i2) {
            void var2_2;
            PointF pointF = (PointF)var2_2.get(i2);
            PointF pointF2 = (PointF)var1_1.get(i2);
            pointF.x = pointF2.x / (float)this.width;
            pointF.y = pointF2.y / (float)this.height;
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Line2D> scaleLines(List<Line2D> lines) {
        void var1_1;
        ArrayList arrayList;
        ArrayList arrayList2 = lines;
        lines = arrayList;
        arrayList = new ArrayList();
        for (Line2D line2D : arrayList2) {
            PolygonHelper polygonHelper = this;
            float f2 = polygonHelper.left;
            line2D.getStart().x = (float)polygonHelper.width * line2D.getStart().x + f2;
            PolygonHelper polygonHelper2 = this;
            f2 = polygonHelper2.top;
            line2D.getStart().y = (float)polygonHelper2.height * line2D.getStart().y + f2;
            PolygonHelper polygonHelper3 = this;
            f2 = polygonHelper3.left;
            line2D.getEnd().x = (float)polygonHelper3.width * line2D.getEnd().x + f2;
            PolygonHelper polygonHelper4 = this;
            f2 = polygonHelper4.top;
            line2D.getEnd().y = (float)polygonHelper4.height * line2D.getEnd().y + f2;
            var1_1.add(line2D);
        }
        return var1_1;
    }

    public static class Line {
        private double a;
        private double b;
        private double c;
        private PointF intersectionPoint = new PointF();

        public PointF getIntersectionPoint(Line line) {
            PointF pointF = this_.intersectionPoint;
            Line line2 = this_;
            double d2 = line2.c;
            double d3 = line.b;
            double d4 = d2 * d3;
            double d5 = line2.b;
            double this_ = line.c;
            double d6 = line.a;
            double d7 = d5 * d6;
            double d8 = line2.a;
            pointF.x = (float)((d4 -= d5 * this_) / (d7 - d8 * d3));
            pointF.y = (float)((d8 * this_ - d2 * d6) / (d5 * d6 - d8 * d3));
            return pointF;
        }

        public void calculateLine(PointF start2, PointF end2) {
            float f2 = start2.y;
            float f3 = end2.y;
            this_.a = f2 - f3;
            float start2 = end2.x;
            float end2 = start2.x;
            this_.b = start2 - end2;
            float this_ = (end2 - start2) * f2;
            this_.c = (f3 - f2) * end2 + this_;
        }

        /*
         * WARNING - void declaration
         */
        public double getDistanceToPoint(PointF point) {
            void var1_2;
            if (this.a == 0.0 && this.b == 0.0) {
                return 0.0;
            }
            Line line = this;
            double d2 = line.a * (double)var1_2.x;
            Line line2 = this;
            double d3 = line2.a;
            double d4 = d3 * d3;
            double d5 = line2.b;
            return Math.abs(line.b * (double)var1_2.y + d2 + this.c) / Math.sqrt(d5 * d5 + d4);
        }
    }

    public static class Edge {
        public PointF pointA;
        public PointF pointB;
        public PointF pointFarA;
        public PointF pointFarB;
        public Line edgeLine = new Line();
        public Line lineA = new Line();
        public Line lineB = new Line();
        private PointF handle = new PointF();
        public float prevX;
        public float prevY;
        public boolean isDetectedLine = false;

        public float getAngleInDegrees() {
            PointF pointF = this22.pointB;
            Edge this22 = this22.pointA;
            float this22 = pointF.x - ((PointF)this22).x;
            return (float)(Math.toDegrees(Math.atan2(pointF.y - ((PointF)this22).y, this22)) + 90.0);
        }

        public PointF getHandle() {
            PointF pointF = this_.pointA;
            Edge this_ = this_.pointB;
            this_.handle.x = (pointF.x + ((PointF)this_).x) / 2.0f;
            this_.handle.y = (pointF.y + ((PointF)this_).y) / 2.0f;
            return this_.handle;
        }

        public boolean isHorizontal() {
            PointF pointF = this_.pointB;
            Edge this_ = this_.pointA;
            float f2 = pointF.y - ((PointF)this_).y;
            return Math.abs(pointF.x - ((PointF)this_).x) > Math.abs(f2);
        }
    }
}

