/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.camera;

import android.graphics.PointF;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.View;
import io.scanbot.sdk.camera.CameraStateCallback;
import io.scanbot.sdk.camera.CameraTakePictureCallback;
import io.scanbot.sdk.camera.PictureCallback;
import io.scanbot.sdk.camera.sensor.SignificantMoveCatcher;
import io.scanbot.sdk.camera.sensor.SignificantMoveListener;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class BaseAutoSnappingController {
    private static final long DEFAULT_CAPTURE_INTERVAL_MS = 1000L;
    private static final long MAXIMUM_CAPTURE_INTERVAL = 3000L;
    private static final int DELAY_AFTER_MOVE_MS = 2000;
    private static final int OK_DETECTIONS_COUNT_FOR_AUTOSNAP = 3;
    private static final double OK_DETECTIONS_THRESHOLD = 0.05;
    protected final IScanbotCameraView cameraView;
    protected final SignificantMoveCatcher significantMoveCatcher;
    protected final SignificantMoveListener significantMoveListener;
    private long lastSignificantMove;
    protected final AtomicLong captureInterval;
    protected final Logger logger;
    protected long lastCapture;
    protected AtomicBoolean capturing;
    protected boolean ignoreBadAspectRatio;
    protected boolean forceAutofocusBeforeSnap;
    protected final Handler mainThreadHandler;
    private boolean isAutoSnapEnabled;
    private AtomicBoolean isAutosnappingShooting;
    private AutoSnappingCallback autoSnappingCallback;
    private final Runnable autosnappingShoot;
    private List<PointF> lastDetectedPolygon;
    private AtomicInteger okDetectionCounter;

    /*
     * WARNING - void declaration
     */
    protected BaseAutoSnappingController(IScanbotCameraView cameraView) {
        void var1_1;
        IScanbotCameraView iScanbotCameraView = cameraView;
        BaseAutoSnappingController baseAutoSnappingController = this;
        this.lastSignificantMove = 0L;
        this.captureInterval = new AtomicLong(1000L);
        this.logger = LoggerProvider.getLogger();
        this.lastCapture = 0L;
        this.capturing = new AtomicBoolean(false);
        this.ignoreBadAspectRatio = false;
        this.forceAutofocusBeforeSnap = false;
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        this.isAutoSnapEnabled = true;
        this.isAutosnappingShooting = new AtomicBoolean(false);
        this.autoSnappingCallback = AutoSnappingCallback.NULL;
        this.autosnappingShoot = new Runnable(this){
            final /* synthetic */ BaseAutoSnappingController a;
            {
                void var1_1;
                this.a = var1_1;
            }

            @Override
            public void run() {
                boolean bl = SystemClock.elapsedRealtime() - this.a.lastSignificantMove <= 2000L;
                if (this.a.isAutoSnapEnabled && !bl) {
                    if (!this.a.autoSnappingCallback.onAutoSnapping()) {
                        bl = this.a.forceAutofocusBeforeSnap || Build.VERSION.SDK_INT < 24;
                        this.a.cameraView.takePicture(bl);
                    }
                } else {
                    this.a.isAutosnappingShooting.set(false);
                }
            }
        };
        this.okDetectionCounter = new AtomicInteger(0);
        baseAutoSnappingController.cameraView = var1_1;
        baseAutoSnappingController.significantMoveCatcher = new SignificantMoveCatcher(((View)var1_1).getContext().getApplicationContext());
        baseAutoSnappingController.significantMoveListener = new SignificantMoveListenerImpl(this);
        iScanbotCameraView.addPictureCallback((PictureCallback)new d());
        iScanbotCameraView.addCameraStateCallback((CameraStateCallback)new b());
        iScanbotCameraView.addTakePictureCallback((CameraTakePictureCallback)new c());
    }

    /*
     * WARNING - void declaration
     */
    private void checkDetectedPolygonAndSnap(List<PointF> polygon) {
        void var1_1;
        if (polygon != null && !var1_1.isEmpty() && this.okDetectionCounter.get() < 3) {
            List<PointF> list = this.lastDetectedPolygon;
            if (list == null) {
                this.lastDetectedPolygon = var1_1;
            } else if (this.polygonsAreClose(list, (List<PointF>)var1_1)) {
                this.okDetectionCounter.incrementAndGet();
            } else {
                this.okDetectionCounter.set(0);
                this.lastDetectedPolygon = var1_1;
            }
        } else {
            BaseAutoSnappingController baseAutoSnappingController = this;
            baseAutoSnappingController.isAutosnappingShooting.set(true);
            baseAutoSnappingController.mainThreadHandler.post(this.autosnappingShoot);
            baseAutoSnappingController.okDetectionCounter.set(0);
            baseAutoSnappingController.lastDetectedPolygon = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean polygonsAreClose(List<PointF> lastDetectedPolygon, List<PointF> polygon) {
        void var1_1;
        void var2_2;
        return (double)Math.abs(lastDetectedPolygon.get((int)0).x - ((PointF)var2_2.get((int)0)).x) < 0.05 && (double)Math.abs(((PointF)var1_1.get((int)0)).y - ((PointF)var2_2.get((int)0)).y) < 0.05 && (double)Math.abs(((PointF)var1_1.get((int)2)).x - ((PointF)var2_2.get((int)2)).x) < 0.05 && (double)Math.abs(((PointF)var1_1.get((int)2)).y - ((PointF)var2_2.get((int)2)).y) < 0.05;
    }

    /*
     * WARNING - void declaration
     */
    private float clamp(float value) {
        void var1_1;
        if (value < 0.0f) {
            return 0.0f;
        }
        if (var1_1 > 1.0f) {
            return 1.0f;
        }
        return (float)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$002(BaseAutoSnappingController x02, long x1) {
        void var1_1;
        var0.lastSignificantMove = var1_1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    protected void onDetectionOK(List<PointF> polygon) {
        if (!this.isAutosnappingShooting.get()) {
            void var1_1;
            this.checkDetectedPolygonAndSnap((List<PointF>)var1_1);
        }
    }

    public abstract void detach();

    /*
     * WARNING - void declaration
     */
    public void setEnabled(boolean enabled) {
        void var1_1;
        this.isAutoSnapEnabled = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setForceAutofocusBeforeSnap(boolean enabled) {
        void var1_1;
        this.forceAutofocusBeforeSnap = var1_1;
    }

    public boolean isEnabled() {
        return this.isAutoSnapEnabled;
    }

    /*
     * WARNING - void declaration
     */
    public void setSensitivity(float sensitivity) {
        void var1_2;
        BaseAutoSnappingController baseAutoSnappingController = this;
        this.logger.logMethod();
        float f2 = 1.0f - baseAutoSnappingController.clamp((float)var1_2);
        baseAutoSnappingController.captureInterval.set((long)(f2 * 3000.0f));
    }

    /*
     * WARNING - void declaration
     */
    public void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        void var1_1;
        this.logger.logMethod();
        this.ignoreBadAspectRatio = var1_1;
    }

    public void setAutoSnappingCallback(AutoSnappingCallback callback) {
        AutoSnappingCallback autoSnappingCallback;
        this.logger.logMethod();
        if (callback == null) {
            autoSnappingCallback = AutoSnappingCallback.NULL;
        }
        this.autoSnappingCallback = autoSnappingCallback;
    }

    private class c
    implements CameraTakePictureCallback {
        private c() {
        }

        public void onTakePictureRequested() {
        }

        public void onTakePictureCancelled() {
            c c2 = this;
            c2.BaseAutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            c2.BaseAutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    protected class SignificantMoveListenerImpl
    implements SignificantMoveListener {
        final /* synthetic */ BaseAutoSnappingController this$0;

        /*
         * WARNING - void declaration
         */
        protected SignificantMoveListenerImpl(BaseAutoSnappingController this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public float getSignificantMoveThreshold() {
            return 0.6f;
        }

        @Override
        public void onSignificantMove() {
            SignificantMoveListenerImpl significantMoveListenerImpl = this;
            BaseAutoSnappingController.access$002(significantMoveListenerImpl.this$0, SystemClock.elapsedRealtime());
            if (significantMoveListenerImpl.this$0.capturing.get() && this.this$0.isAutosnappingShooting.get()) {
                SignificantMoveListenerImpl significantMoveListenerImpl2 = this;
                significantMoveListenerImpl2.this$0.cameraView.continuousFocus();
                significantMoveListenerImpl2.this$0.mainThreadHandler.removeCallbacksAndMessages(null);
                significantMoveListenerImpl2.this$0.isAutosnappingShooting.set(false);
            }
        }
    }

    private class b
    implements CameraStateCallback {
        private b() {
        }

        public void onResume() {
            b b2 = this_;
            b2.BaseAutoSnappingController.this.capturing.set(true);
            BaseAutoSnappingController this_ = b2.BaseAutoSnappingController.this;
            this_.significantMoveCatcher.registerSignificantMoveListener(this_.significantMoveListener);
        }

        public void onPause() {
            b b2 = this_;
            BaseAutoSnappingController this_ = b2.BaseAutoSnappingController.this;
            this_.significantMoveCatcher.unregisterSignificantMoveListener(this_.significantMoveListener);
            b2.BaseAutoSnappingController.this.isAutosnappingShooting.set(false);
            b2.BaseAutoSnappingController.this.capturing.set(false);
            b2.BaseAutoSnappingController.this.lastCapture = 0L;
        }
    }

    private class d
    implements PictureCallback {
        private d() {
        }

        public void onPictureTaken(byte[] image, int imageOrientation) {
            d d2 = this;
            d2.BaseAutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            d2.BaseAutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    public static interface AutoSnappingCallback {
        public static final AutoSnappingCallback NULL = new AutoSnappingCallback(){

            @Override
            public boolean onAutoSnapping() {
                return false;
            }
        };

        public boolean onAutoSnapping();
    }
}

