/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.camera.sensor;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import io.scanbot.sdk.camera.sensor.SignificantMoveListener;

public class SignificantMoveCatcher
implements SensorEventListener {
    private SensorManager sensorManager;
    private Sensor accelerometer;
    private float[] gravity;
    private float acceleration;
    private float currentAcceleration;
    private float lastAcceleration;
    private SignificantMoveListener moveListener;

    /*
     * WARNING - void declaration
     */
    public SignificantMoveCatcher(Context context) {
        void var1_1;
        SignificantMoveCatcher significantMoveCatcher = this;
        this.moveListener = null;
        this.sensorManager = (SensorManager)var1_1.getSystemService("sensor");
        significantMoveCatcher.accelerometer = this.sensorManager.getDefaultSensor(1);
        significantMoveCatcher.acceleration = 0.0f;
        significantMoveCatcher.currentAcceleration = 9.80665f;
        significantMoveCatcher.lastAcceleration = 9.80665f;
    }

    private void registerSensorListener() {
        Sensor sensor = this.accelerometer;
        if (sensor != null) {
            this.sensorManager.registerListener((SensorEventListener)this, sensor, 2);
        }
    }

    private void unregisterSensorListener() {
        this.sensorManager.unregisterListener((SensorEventListener)this);
    }

    /*
     * WARNING - void declaration
     */
    public void registerSignificantMoveListener(SignificantMoveListener listener) {
        void var1_1;
        if (listener != null && this.moveListener != var1_1) {
            this.moveListener = var1_1;
            this.registerSensorListener();
        }
    }

    public void unregisterSignificantMoveListener(SignificantMoveListener listener) {
        this.moveListener = null;
        this.unregisterSensorListener();
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == 1) {
            float[] fArray;
            SignificantMoveCatcher significantMoveCatcher = this;
            fArray = (float[])fArray.values.clone();
            this.gravity = fArray;
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            this.lastAcceleration = this.currentAcceleration;
            float f5 = f3;
            float f6 = f4;
            this.currentAcceleration = f3 = (float)Math.sqrt(f2 * f2 + f5 * f5 + f6 * f6);
            f3 -= this.lastAcceleration;
            significantMoveCatcher.acceleration = f3 = significantMoveCatcher.acceleration * 0.9f + f3;
            SignificantMoveListener significantMoveListener = significantMoveCatcher.moveListener;
            if (significantMoveListener != null && f3 > significantMoveListener.getSignificantMoveThreshold()) {
                this.moveListener.onSignificantMove();
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

