/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui;

import android.animation.Animator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.widget.AppCompatImageView;
import io.scanbot.sdk.ScanbotSDKInitializer;
import io.scanbot.sdk.bundle.R;
import io.scanbot.sdk.core.contourdetector.Line2D;
import io.scanbot.sdk.ui.MagnifierView;
import io.scanbot.sdk.util.PolygonHelper;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import io.scanbot.sdk.util.view.PolygonHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.jetbrains.annotations.Nullable;

public class EditPolygonImageView
extends AppCompatImageView {
    private static final int CORNERS_COUNT = 4;
    private EditPolygonAnimationEndListener editPolygonAnimationEndListener = null;
    private EditPolygonDragListener editPolygonDragListener = null;
    private final float magneticLineTreshold;
    private final int edgeColor;
    private final int edgeColorOnLine;
    private final Drawable cornerDrawable;
    private final Drawable edgeDrawable;
    private Paint paint;
    private Paint paintOnLine;
    private Paint handlePaint;
    private io.scanbot.sdk.util.view.PolygonHelper polygonHelper;
    private float rotationScale = 1.0f;
    private boolean isPointsDraggable = true;
    private final List<Line2D> horizontalLines2D = new ArrayList<Line2D>();
    private final List<Line2D> verticalLines2D = new ArrayList<Line2D>();
    private final List<PolygonHelper.Line> horizontalLines = new ArrayList<PolygonHelper.Line>();
    private final List<PolygonHelper.Line> verticalLines = new ArrayList<PolygonHelper.Line>();
    private PointF finger = new PointF();
    private List<PointF> polygon;
    private List<PointF> corners;
    private List<PolygonHelper.Edge> edges;
    private float offsetX;
    private float offsetY;
    private Bitmap cornerBitmap;
    private Bitmap edgeBitmap;
    private int handleSize;
    private PointF selectedCorner;
    private PolygonHelper.Edge selectedEdge;
    private PointF tmpPointA = new PointF();
    private PointF tmpPointB = new PointF();
    private float medianX;
    private float medianY;
    private PriorityQueue<PointF> pointsQueue;
    @Nullable
    private MagnifierView magnifierView;
    private float[] imageMatrix;
    private RectF touchRect;
    private float polygonStrokeWidth;
    private int lastKnownImageWidth;
    private int lastKnownImageHeight;
    private float scaleLandscape;
    private float scalePortrait;
    boolean fullPolygonSelected;

    public static List<PointF> getDefaultPolygon() {
        return new ArrayList<PointF>(){
            {
                PointF pointF;
                PointF pointF2;
                PointF pointF3;
                PointF pointF4;
                a a2 = this_;
                a this_ = pointF4;
                pointF4 = new PointF(0.0f, 0.0f);
                a2.add(this_);
                this_ = pointF3;
                pointF3 = new PointF(1.0f, 0.0f);
                a2.add(this_);
                this_ = pointF2;
                pointF2 = new PointF(1.0f, 1.0f);
                a2.add(this_);
                this_ = pointF;
                pointF = new PointF(0.0f, 1.0f);
                a2.add(this_);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public EditPolygonImageView(Context context, AttributeSet attrs) {
        super((Context)typedArray, (AttributeSet)var2_5);
        Comparator<PointF> comparator;
        void var2_5;
        TypedArray typedArray;
        Comparator<PointF> comparator2 = comparator;
        comparator = new Comparator<PointF>(this){
            final /* synthetic */ EditPolygonImageView a;
            {
                void var1_1;
                this.a = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public int a(PointF lhs, PointF rhs) {
                void var2_2;
                void var1_1;
                return Double.compare(Math.atan2(lhs.y - this.a.medianY, var1_1.x - this.a.medianX), Math.atan2(var2_2.y - this.a.medianY, var2_2.x - this.a.medianX));
            }
        };
        this.pointsQueue = new PriorityQueue<PointF>(4, comparator2);
        this.imageMatrix = new float[9];
        this.touchRect = new RectF();
        this.lastKnownImageWidth = -1;
        this.lastKnownImageHeight = -1;
        this.scaleLandscape = 1.0f;
        this.scalePortrait = 1.0f;
        if (ScanbotSDKInitializer.isInitialized()) {
            ArrayList<PolygonHelper.Edge> arrayList;
            Paint paint;
            Paint paint2;
            EditPolygonImageView editPolygonImageView = this;
            typedArray = typedArray.getTheme().obtainStyledAttributes((AttributeSet)var2_5, R.styleable.EditPolygonImageView, 0, 0);
            EditPolygonImageView editPolygonImageView2 = this;
            TypedArray typedArray2 = typedArray;
            EditPolygonImageView editPolygonImageView3 = this;
            TypedArray typedArray3 = typedArray;
            EditPolygonImageView editPolygonImageView4 = this;
            TypedArray typedArray4 = typedArray;
            EditPolygonImageView editPolygonImageView5 = this;
            TypedArray typedArray5 = typedArray;
            EditPolygonImageView editPolygonImageView6 = this;
            TypedArray typedArray6 = typedArray;
            EditPolygonImageView editPolygonImageView7 = this;
            TypedArray typedArray7 = typedArray;
            EditPolygonImageView editPolygonImageView8 = this;
            int n2 = typedArray.getColor(R.styleable.EditPolygonImageView_edgeColor, 0);
            editPolygonImageView8.edgeColor = n2;
            int n3 = typedArray7.getColor(R.styleable.EditPolygonImageView_edgeColorOnLine, n2);
            try {
                editPolygonImageView7.edgeColorOnLine = n3;
                editPolygonImageView6.cornerDrawable = typedArray6.getDrawable(R.styleable.EditPolygonImageView_cornerImageSrc);
                editPolygonImageView5.edgeDrawable = typedArray5.getDrawable(R.styleable.EditPolygonImageView_edgeImageSrc);
                editPolygonImageView4.magneticLineTreshold = typedArray4.getDimension(R.styleable.EditPolygonImageView_magneticLineTreshold, this.getResources().getDimension(R.dimen.magnetic_line_treshold));
                editPolygonImageView3.polygonStrokeWidth = typedArray3.getDimension(R.styleable.EditPolygonImageView_editPolygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
                editPolygonImageView2.handleSize = typedArray2.getDimensionPixelSize(R.styleable.EditPolygonImageView_editPolygonHandleSize, this.getResources().getDimensionPixelSize(R.dimen.edit_polygon_handle_size));
            }
            catch (Throwable throwable) {
                typedArray.recycle();
                throw throwable;
            }
            typedArray.recycle();
            editPolygonImageView.polygon = Collections.emptyList();
            TypedArray typedArray8 = typedArray = paint2;
            super();
            this.paint = typedArray8;
            paint2.setColor(n2);
            editPolygonImageView.paint.setStyle(Paint.Style.STROKE);
            editPolygonImageView.paint.setStrokeWidth(this.polygonStrokeWidth);
            editPolygonImageView.paint.setAntiAlias(true);
            editPolygonImageView.paint.setStrokeCap(Paint.Cap.SQUARE);
            TypedArray typedArray9 = typedArray = paint;
            super();
            this.paintOnLine = typedArray9;
            paint.setColor(n3);
            editPolygonImageView.paintOnLine.setStyle(Paint.Style.STROKE);
            editPolygonImageView.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
            editPolygonImageView.paintOnLine.setAntiAlias(true);
            editPolygonImageView.paintOnLine.setStrokeCap(Paint.Cap.SQUARE);
            this.handlePaint = new Paint();
            this.handlePaint.setAntiAlias(true);
            editPolygonImageView.handlePaint.setFilterBitmap(true);
            editPolygonImageView.polygonHelper = new io.scanbot.sdk.util.view.PolygonHelper();
            editPolygonImageView.corners = new ArrayList<PointF>();
            for (int i2 = 0; i2 < 4; ++i2) {
                this.corners.add(new PointF());
            }
            ArrayList<PolygonHelper.Edge> arrayList2 = arrayList;
            arrayList = new ArrayList<PolygonHelper.Edge>();
            this.edges = arrayList2;
            int n4 = 0;
            while (n4 < this.corners.size()) {
                PolygonHelper.Edge edge;
                PolygonHelper.Edge edge2 = edge;
                edge2();
                edge2.pointA = this.corners.get(n4);
                n3 = n4 + 1;
                edge2.pointB = this.corners.get(n3 % 4);
                edge2.pointFarA = this.corners.get((n4 + 3) % 4);
                edge.pointFarB = this.corners.get((n4 + 2) % 4);
                this.edges.add(edge2);
                n4 = n3;
            }
            return;
        }
        throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.");
    }

    /*
     * WARNING - void declaration
     */
    private float getRotationScale(float currentRotation, float rotateBy) {
        void var2_2;
        if (Math.abs((currentRotation + var2_2) % 360.0f) / 90.0f % 2.0f == 0.0f) {
            return this.scalePortrait;
        }
        return this.scaleLandscape;
    }

    private void checkWhetherImageSizeUpdated() {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return;
        }
        if (drawable.getIntrinsicWidth() != this.lastKnownImageWidth || drawable.getIntrinsicHeight() != this.lastKnownImageHeight) {
            this.lastKnownImageWidth = drawable.getIntrinsicWidth();
            this.lastKnownImageHeight = drawable.getIntrinsicHeight();
            this.onImageSizeUpdated();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void drawHandle(Canvas canvas, PointF point, Bitmap handle, float degrees) {
        void var3_7;
        void var2_4;
        void var1_2;
        var1_2.save();
        if (degrees != 0.0f) {
            void var4_8;
            void v02 = var2_4;
            float f2 = v02.x;
            float f3 = v02.y;
            var1_2.rotate((float)var4_8, f2, f3);
        }
        void v1 = var1_2;
        void v2 = var2_4;
        void v3 = var2_4;
        EditPolygonImageView editPolygonImageView = this;
        float f4 = 1.0f / editPolygonImageView.getRotationScale(editPolygonImageView.getRotation(), 0.0f);
        float f5 = v3.x;
        float f6 = v3.y;
        float f7 = f4;
        var1_2.scale(f7, f7, f5, f6);
        f4 = v2.x - (float)(var3_7.getWidth() >> 1);
        f5 = v2.y - (float)(var3_7.getHeight() >> 1);
        Paint paint = this.handlePaint;
        v1.drawBitmap((Bitmap)var3_7, f4, f5, paint);
        v1.restore();
    }

    /*
     * WARNING - void declaration
     */
    private void keepInsideView(PointF point) {
        void var1_1;
        PointF pointF = point;
        pointF.set(Math.max(0.0f, Math.min(pointF.x, (float)this.getWidth() - this.offsetX * 2.0f)), Math.max(0.0f, Math.min(var1_1.y, (float)this.getHeight() - this.offsetY * 2.0f)));
    }

    private void checkPolygonSelection() {
        EditPolygonImageView editPolygonImageView = this;
        boolean bl = editPolygonImageView.getPolygon().containsAll(PolygonHelper.getFullPolygon());
        if (editPolygonImageView.fullPolygonSelected != bl) {
            EditPolygonDragListener editPolygonDragListener = this.editPolygonDragListener;
            if (editPolygonDragListener != null) {
                editPolygonDragListener.onPolygonSelectedStateChanged(bl);
            }
            this.fullPolygonSelected = bl;
        }
    }

    private void restoreSelectedEdge() {
        EditPolygonImageView editPolygonImageView = this_;
        editPolygonImageView.selectedEdge.pointA.set(this_.tmpPointA);
        editPolygonImageView.selectedEdge.pointB.set(this_.tmpPointB);
        PolygonHelper.Edge edge = editPolygonImageView.selectedEdge;
        EditPolygonImageView editPolygonImageView2 = this_ = edge;
        EditPolygonImageView this_ = ((PolygonHelper.Edge)editPolygonImageView2).pointA;
        edge.edgeLine.calculateLine((PointF)this_, ((PolygonHelper.Edge)editPolygonImageView2).pointB);
    }

    private void ensureNoPolygonIntersection() {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.calculateMedian();
        if (editPolygonImageView.ensureCornersOrder()) {
            this.ensureEdgesOrder();
        }
    }

    private boolean ensureCornersOrder() {
        boolean bl = false;
        this.pointsQueue.addAll(this.corners);
        for (int i2 = 0; i2 < 4; ++i2) {
            PointF pointF = (PointF)this.pointsQueue.remove();
            if (!pointF.equals((Object)this.corners.get(i2))) {
                bl = true;
            }
            this.corners.set(i2, pointF);
        }
        return bl;
    }

    private void calculateMedian() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            float f4 = f3;
            PointF pointF = this.corners.get(i2);
            f3 = f2 + pointF.x;
            f2 = f4 + pointF.y;
            float f5 = f3;
            f3 = f2;
            f2 = f5;
        }
        this.medianX = f2 / 4.0f;
        this.medianY = f3 / 4.0f;
    }

    private void ensureEdgesOrder() {
        int n2 = 0;
        while (n2 < 4) {
            PolygonHelper.Edge edge = this.edges.get(n2);
            edge.pointA = this.corners.get(n2);
            int n3 = n2 + 1;
            edge.pointB = this.corners.get(n3 % 4);
            edge.pointFarA = this.corners.get((n2 + 3) % 4);
            this.edges.get(n2).pointFarB = this.corners.get((n2 + 2) % 4);
            n2 = n3;
        }
    }

    private void onImageSizeUpdated() {
        if (this_.getDrawable() != null) {
            float f2;
            EditPolygonImageView editPolygonImageView = this_;
            editPolygonImageView.offsetX = 0.0f;
            editPolygonImageView.offsetY = 0.0f;
            editPolygonImageView.getImageMatrix().getValues(this_.imageMatrix);
            Drawable drawable = editPolygonImageView.getDrawable();
            int n2 = drawable.getIntrinsicHeight();
            float f3 = drawable.getIntrinsicWidth();
            EditPolygonImageView editPolygonImageView2 = this_;
            float f4 = f3 * this_.getScaleX();
            float f5 = n2;
            float f6 = f5 * this_.getScaleY();
            RectF rectF = new RectF(0.0f, 0.0f, f4, f6);
            editPolygonImageView2.scalePortrait = io.scanbot.sdk.d.a.a((View)editPolygonImageView2, 0.0f, rectF) * this_.getScaleX();
            editPolygonImageView2.scaleLandscape = io.scanbot.sdk.d.a.a((View)editPolygonImageView2, 90.0f, rectF) * this_.getScaleY();
            if (f2 * editPolygonImageView2.scalePortrait < (float)this_.getWidth()) {
                this_.offsetX = this_.getWidth() - (int)(f3 * this_.scalePortrait) >> 1;
            }
            if (f5 * this_.scalePortrait < (float)this_.getHeight()) {
                this_.offsetY = this_.getHeight() - (int)(f5 * this_.scalePortrait) >> 1;
            }
            EditPolygonImageView editPolygonImageView3 = this_;
            int n3 = (int)Math.ceil(f3 * this_.scalePortrait);
            editPolygonImageView3.polygonHelper.setImageSize(n3, (int)Math.ceil(f5 * this_.scalePortrait));
            editPolygonImageView3.scaleLandscape /= this_.scalePortrait;
            editPolygonImageView3.scalePortrait = 1.0f;
            if (editPolygonImageView3.getRotation() / 90.0f % 2.0f == 1.0f) {
                EditPolygonImageView editPolygonImageView4 = this_;
                editPolygonImageView4.setScaleX(editPolygonImageView4.scaleLandscape);
                editPolygonImageView4.setScaleY(editPolygonImageView4.scaleLandscape);
            }
            if (!this_.polygon.isEmpty()) {
                EditPolygonImageView editPolygonImageView5 = this_;
                Object this_ = editPolygonImageView5.polygon;
                this_.polygonHelper.getDrawingPolygon((List)this_, editPolygonImageView5.corners);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ List access$202(EditPolygonImageView x02, List x1) {
        void var1_1;
        var0.polygon = var1_1;
        return x1;
    }

    protected void onAttachedToWindow() {
        EditPolygonImageView editPolygonImageView = this;
        super.onAttachedToWindow();
        editPolygonImageView.cornerBitmap = BitmapUtils.drawableToBitmap((Drawable)editPolygonImageView.cornerDrawable);
        editPolygonImageView.edgeBitmap = BitmapUtils.drawableToBitmap((Drawable)editPolygonImageView.edgeDrawable);
    }

    protected void onDetachedFromWindow() {
        EditPolygonImageView editPolygonImageView = this;
        super.onDetachedFromWindow();
        editPolygonImageView.cornerBitmap.recycle();
        editPolygonImageView.edgeBitmap.recycle();
        editPolygonImageView.editPolygonAnimationEndListener = null;
        editPolygonImageView.editPolygonDragListener = null;
    }

    /*
     * WARNING - void declaration
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        void var2_2;
        void var1_1;
        EditPolygonImageView editPolygonImageView = this;
        super.onMeasure((int)var1_1, (int)var2_2);
        editPolygonImageView.onImageSizeUpdated();
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        super.onLayout((boolean)var1_1, (int)var2_2, (int)var3_3, (int)var4_4, (int)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    public void setPolygon(List<PointF> newPolygon) {
        void var1_1;
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(this, (List)var1_1){
            final /* synthetic */ List a;
            final /* synthetic */ EditPolygonImageView b;
            {
                void var1_1;
                this.b = var1_1;
                this.a = list;
            }

            @Override
            public void run() {
                if (!this.a.isEmpty()) {
                    c c2 = this;
                    EditPolygonImageView.access$202(c2.b, this.a);
                    if (!c2.b.corners.isEmpty()) {
                        this.b.polygonHelper.getDrawingPolygon(this.a, this.b.corners);
                    }
                    c c3 = this;
                    c3.b.checkPolygonSelection();
                    c3.b.invalidate();
                }
            }
        };
        this.post(runnable2);
    }

    public List<PointF> getPolygon() {
        if (!this.corners.isEmpty() && !this.polygon.isEmpty()) {
            EditPolygonImageView editPolygonImageView = this;
            List<PointF> list = editPolygonImageView.corners;
            this.polygonHelper.getPolygonFromDrawingPolygon(list, editPolygonImageView.polygon);
        }
        return this.polygon;
    }

    /*
     * WARNING - void declaration
     */
    public void setRotation(float rotation) {
        void var1_1;
        if (rotation % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        float f2 = editPolygonImageView.getRotation() - var1_1;
        f2 = editPolygonImageView.getRotationScale(editPolygonImageView.getRotation(), f2);
        MagnifierView magnifierView = editPolygonImageView.magnifierView;
        if (magnifierView != null) {
            magnifierView.setImageRotation((float)var1_1);
        }
        EditPolygonImageView editPolygonImageView2 = this;
        editPolygonImageView2.setScaleX(f2);
        editPolygonImageView2.setScaleY(f2);
        editPolygonImageView2.invalidate();
        super.setRotation((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setLines(List<Line2D> horizontalLines, List<Line2D> verticalLines) {
        void var2_2;
        void var1_1;
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(this, (List)var1_1, (List)var2_2){
            final /* synthetic */ List a;
            final /* synthetic */ List b;
            final /* synthetic */ EditPolygonImageView c;
            {
                void var1_1;
                this.c = var1_1;
                this.a = list;
                this.b = list2;
            }

            @Override
            public void run() {
                ArrayList arrayList;
                Object object;
                PointF pointF;
                ArrayList<Line2D> arrayList2;
                Iterator<Line2D> iterator = arrayList2;
                arrayList2 = new ArrayList<Line2D>(this.a.size());
                for (Line2D line2D : this.a) {
                    PointF pointF2;
                    PointF pointF3 = line2D.start;
                    float f2 = pointF3.x;
                    pointF = pointF2;
                    PointF pointF4 = line2D.end;
                    float f3 = pointF4.x;
                    pointF2 = new PointF(f3, pointF4.y);
                    iterator.add(new Line2D(new PointF(f2, pointF3.y), pointF));
                }
                d d2 = this;
                d2.c.horizontalLines2D.clear();
                d2.c.horizontalLines2D.addAll(this.c.polygonHelper.scaleLines(iterator));
                d2.c.horizontalLines.clear();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    PolygonHelper.Line line;
                    object = (Line2D)iterator.next();
                    PolygonHelper.Line line2 = line;
                    Line2D line2D = object;
                    line2();
                    object = line2D.start;
                    line.calculateLine((PointF)object, line2D.end);
                    this.c.horizontalLines.add(line2);
                }
                iterator = arrayList;
                arrayList = new ArrayList(this.b.size());
                for (Line2D line2D : this.b) {
                    PointF pointF5;
                    PointF pointF6 = line2D.start;
                    float f4 = pointF6.x;
                    pointF = pointF5;
                    PointF pointF7 = line2D.end;
                    float f5 = pointF7.x;
                    pointF5 = new PointF(f5, pointF7.y);
                    iterator.add(new Line2D(new PointF(f4, pointF6.y), pointF));
                }
                d d3 = this;
                d3.c.verticalLines2D.clear();
                d3.c.verticalLines2D.addAll(this.c.polygonHelper.scaleLines((List)((Object)iterator)));
                d3.c.verticalLines.clear();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    PolygonHelper.Line line;
                    object = (Line2D)iterator.next();
                    PolygonHelper.Line line3 = line;
                    Object object2 = object;
                    line3();
                    object = ((Line2D)object2).start;
                    line.calculateLine((PointF)object, ((Line2D)object2).end);
                    this.c.verticalLines.add(line3);
                }
            }
        };
        this.post(runnable2);
    }

    /*
     * WARNING - void declaration
     */
    public void setEdgeColor(int color) {
        void var1_1;
        this.paint.setColor((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setEdgeColorOnLine(int color) {
        void var1_1;
        this.paintOnLine.setColor((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setEdgeWidth(float width) {
        void var1_1;
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.polygonStrokeWidth = var1_1;
        editPolygonImageView.paint.setStrokeWidth((float)var1_1);
        editPolygonImageView.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
    }

    public void rotateClockwise() {
        float f2 = this.getRotation();
        if (f2 % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        f2 = editPolygonImageView.getRotationScale(f2, 90.0f);
        editPolygonImageView.animate().rotationBy(90.0f).scaleX(f2).scaleY(f2).setListener(new Animator.AnimatorListener(this){
            final /* synthetic */ EditPolygonImageView a;
            {
                void var1_1;
                this.a = var1_1;
            }

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (this.a.magnifierView != null) {
                    this.a.magnifierView.setImageRotation(this.a.getRotation());
                }
                if (this.a.editPolygonAnimationEndListener != null) {
                    this.a.editPolygonAnimationEndListener.onAnimationEnded();
                }
                this.a.invalidate();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }).start();
    }

    public void rotateCounterClockwise() {
        float f2 = this.getRotation();
        if (f2 % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        f2 = editPolygonImageView.getRotationScale(f2, -90.0f);
        editPolygonImageView.animate().rotationBy(-90.0f).scaleX(f2).scaleY(f2).setListener(new Animator.AnimatorListener(this){
            final /* synthetic */ EditPolygonImageView a;
            {
                void var1_1;
                this.a = var1_1;
            }

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (this.a.magnifierView != null) {
                    this.a.magnifierView.setImageRotation(this.a.getRotation());
                }
                if (this.a.editPolygonAnimationEndListener != null) {
                    this.a.editPolygonAnimationEndListener.onAnimationEnded();
                }
                this.a.invalidate();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }).start();
    }

    /*
     * WARNING - void declaration
     */
    protected void dispatchDraw(Canvas canvas) {
        void var1_1;
        EditPolygonImageView editPolygonImageView = this_;
        super.dispatchDraw((Canvas)var1_1);
        editPolygonImageView.checkWhetherImageSizeUpdated();
        if (!editPolygonImageView.polygon.isEmpty()) {
            float f2;
            float f3;
            EditPolygonImageView editPolygonImageView2 = this_;
            var1_1.save();
            float f4 = editPolygonImageView2.offsetX;
            var1_1.translate(f4, editPolygonImageView2.offsetY);
            for (PolygonHelper.Edge edge : this_.edges) {
                PointF pointF = edge.pointA;
                f3 = pointF.x;
                float f5 = pointF.y;
                PointF pointF2 = edge.pointB;
                f2 = pointF2.x;
                float f6 = pointF2.y;
                Paint paint = edge.isDetectedLine ? this_.paintOnLine : this_.paint;
                var1_1.drawLine(f3, f5, f2, f6, paint);
            }
            Object object = this_.selectedCorner;
            if (object != null) {
                this_.drawHandle((Canvas)var1_1, (PointF)object, this_.cornerBitmap, 0.0f);
                var1_1.save();
                var1_1.translate(-this_.offsetX, -this_.offsetY);
                if (this_.magnifierView != null) {
                    PointF pointF;
                    object = pointF;
                    pointF = new PointF(this_.selectedCorner.x / ((float)this_.getWidth() - this_.offsetX * 2.0f), this_.selectedCorner.y / ((float)this_.getHeight() - this_.offsetY * 2.0f));
                    this_.magnifierView.drawMagnifier((PointF)object);
                }
                var1_1.restore();
            } else {
                object = this_.selectedEdge;
                if (object != null) {
                    EditPolygonImageView editPolygonImageView3 = this_;
                    EditPolygonImageView editPolygonImageView4 = this_;
                    EditPolygonImageView this_ = object.getHandle();
                    object = editPolygonImageView4.edgeBitmap;
                    f3 = editPolygonImageView4.selectedEdge.getAngleInDegrees();
                    editPolygonImageView3.drawHandle((Canvas)var1_1, (PointF)this_, (Bitmap)object, f3);
                } else {
                    for (PolygonHelper.Edge edge : this_.edges) {
                        PointF pointF = edge.getHandle();
                        Bitmap bitmap = this_.edgeBitmap;
                        f2 = edge.getAngleInDegrees();
                        this_.drawHandle((Canvas)var1_1, pointF, bitmap, f2);
                    }
                    for (PointF pointF : this_.corners) {
                        this_.drawHandle((Canvas)var1_1, pointF, this_.cornerBitmap, 0.0f);
                    }
                }
            }
            var1_1.restore();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isPointsDraggable) {
            return true;
        }
        switch (var1_1.getAction()) {
            default: {
                return super.onTouchEvent((MotionEvent)var1_1);
            }
            case 2: {
                var2_2 = this.selectedCorner;
                if (var2_2 == null) ** GOTO lbl15
                v0 = this;
                var2_2.set(var1_1.getX() - this.offsetX, var1_1.getY() - this.offsetY);
                v0.keepInsideView(v0.selectedCorner);
                v0.ensureNoPolygonIntersection();
                v0.invalidate();
                ** GOTO lbl82
lbl15:
                // 1 sources

                if (this.selectedEdge == null) ** GOTO lbl82
                v1 = this;
                v2 = var1_1;
                var2_3 = v2.getX() - this.selectedEdge.prevX;
                var3_11 = v2.getY() - this.selectedEdge.prevY;
                v1.finger.offset(var2_3, var3_11);
                v1.tmpPointA.set(this.selectedEdge.pointA);
                v1.tmpPointB.set(this.selectedEdge.pointB);
                var2_4 = 1.7976931348623157E308;
                var4_15 = null;
                if (v1.selectedEdge.isHorizontal()) {
                    for (var5_18 = 0; var5_18 < this.horizontalLines.size(); ++var5_18) {
                        var6_21 = this.horizontalLines.get(var5_18).getDistanceToPoint(this.finger);
                        if (v3 < var2_4) {
                            var4_15 = this.horizontalLines2D.get(var5_18);
                        } else {
                            var6_21 = var2_4;
                        }
                        var2_4 = var6_21;
                    }
                } else {
                    for (var5_19 = 0; var5_19 < this.verticalLines.size(); ++var5_19) {
                        var6_22 = this.verticalLines.get(var5_19).getDistanceToPoint(this.finger);
                        if (v4 < var2_4) {
                            var4_15 = this.verticalLines2D.get(var5_19);
                        } else {
                            var6_22 = var2_4;
                        }
                        var2_4 = var6_22;
                    }
                }
                if (var4_15 != null && var2_4 < (double)this.magneticLineTreshold) {
                    v5 = this;
                    v5.selectedEdge.pointA.set(var4_15.start);
                    v5.selectedEdge.pointB.set(var4_15.end);
                    v5.selectedEdge.isDetectedLine = true;
                } else {
                    v6 = this;
                    v6.selectedEdge.isDetectedLine = false;
                    var2_5 = v6.selectedEdge.getHandle();
                    v7 = v6.finger;
                    var3_11 = v7.x - var2_5.x;
                    var2_6 = v7.y - var2_5.y;
                    v6.selectedEdge.pointA.offset(var3_11, var2_6);
                    v6.selectedEdge.pointB.offset(var3_11, var2_6);
                }
                v8 = this;
                v9 = v8.selectedEdge;
                v10 = var2_7 = v9;
                var2_7 = v10.pointA;
                v9.edgeLine.calculateLine((PointF)var2_7, v10.pointB);
                var2_7 = v8.selectedEdge;
                var2_7 = var2_7.edgeLine.getIntersectionPoint(var2_7.lineA);
                if (Float.isNaN(var2_7.x) || Float.isNaN(var2_7.y)) ** GOTO lbl80
                v11 = this;
                v11.selectedEdge.pointA.set((PointF)var2_7);
                var2_7 = v11.selectedEdge;
                var2_7 = var2_7.edgeLine.getIntersectionPoint(var2_7.lineB);
                if (!Float.isNaN(var2_7.x) && !Float.isNaN(var2_7.y)) {
                    v12 = this;
                    v12.selectedEdge.pointB.set((PointF)var2_7);
                    v12.keepInsideView(v12.selectedEdge.pointA);
                    v12.keepInsideView(v12.selectedEdge.pointB);
                    v12.selectedEdge.prevX = var1_1.getX();
                    v12.selectedEdge.prevY = var1_1.getY();
                    v12.invalidate();
                } else {
                    this.restoreSelectedEdge();
                    return false;
lbl80:
                    // 1 sources

                    this.restoreSelectedEdge();
                    return false;
                }
lbl82:
                // 3 sources

                this.checkPolygonSelection();
                return true;
            }
            case 1: 
            case 3: {
                this.selectedCorner = null;
                this.selectedEdge = null;
                var1_1 = this.magnifierView;
                if (var1_1 != null) {
                    var1_1.eraseMagnifier();
                }
                this.invalidate();
                return true;
            }
            case 0: 
        }
        v13 = this;
        var2_8 = v13.handleSize >> 1;
        v14 = var2_8;
        var2_9 = v14;
        v15 = var1_1;
        var3_12 = v15.getY() - this.offsetY - var2_9;
        var4_16 = v15.getX() - this.offsetX + var2_9;
        var2_9 = v15.getY() - this.offsetY + var2_9;
        v13.touchRect.set(var1_1.getX() - this.offsetX - v14, var3_12, var4_16, var2_9);
        var2_10 = v13.corners.iterator();
        while (var2_10.hasNext()) {
            v16 = var3_13 = var2_10.next();
            var4_16 = v16.x;
            if (!this.touchRect.contains(var4_16, v16.y)) continue;
            this.selectedCorner = var3_13;
            this.invalidate();
            return true;
        }
        for (PolygonHelper.Edge var3_14 : this.edges) {
            v17 = var4_17 = var3_14.getHandle();
            var5_20 = v17.x;
            if (!this.touchRect.contains(var5_20, v17.y)) continue;
            v18 = this;
            v19 = this.selectedEdge = var3_14;
            var3_14.prevX = var1_1.getX();
            v19.prevY = var1_1.getY();
            v20 = var3_14;
            this = v20.pointA;
            v19.lineA.calculateLine((PointF)this, v20.pointFarA);
            v21 = var3_14;
            this = v21.pointB;
            v19.lineB.calculateLine((PointF)this, v21.pointFarB);
            v18.finger.set(var4_17);
            v18.invalidate();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    void setMagnifier(MagnifierView magnifier) {
        void var1_1;
        this.magnifierView = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setEditPolygonAnimationEndListener(EditPolygonAnimationEndListener editPolygonAnimationEndListener) {
        void var1_1;
        this.editPolygonAnimationEndListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setEditPolygonDragListener(EditPolygonDragListener editPolygonDragListener) {
        void var1_1;
        this.editPolygonDragListener = var1_1;
    }

    public boolean isPointsDraggable() {
        return this.isPointsDraggable;
    }

    /*
     * WARNING - void declaration
     */
    public void setPointsDraggable(boolean pointsDraggable) {
        void var1_1;
        this.isPointsDraggable = var1_1;
    }

    public static interface EditPolygonDragListener {
        public void onPolygonSelectedStateChanged(boolean var1);
    }

    public static interface EditPolygonAnimationEndListener {
        public void onAnimationEnded();
    }
}

