/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;
import android.text.TextUtils;
import io.scanbot.sdk.bundle.R;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CameraConfiguration {
    private List<String> supportedFlashModes;
    private List<String> supportedFocusModes;
    private List<Integer> supportedPreviewFormats;
    private List<Integer> supportedPictureFormats;
    private List<Camera.Size> supportedPreviewSizes;
    private List<Camera.Size> supportedPictureSizes;
    private boolean isConigured = false;

    @Inject
    public CameraConfiguration() {
    }

    /*
     * WARNING - void declaration
     */
    private String joinSizes(String separator, List<Camera.Size> sizes) {
        Object object = "";
        for (Camera.Size size : sizes) {
            if (!((String)object).isEmpty()) {
                void var1_1;
                object = (String)object + (String)var1_1;
            }
            object = (String)object + size.width + "x" + size.height;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public void loadCameraParameters(Camera.Parameters parameters) {
        void var1_1;
        CameraConfiguration cameraConfiguration = this;
        this.supportedFlashModes = var1_1.getSupportedFlashModes();
        this.supportedFocusModes = var1_1.getSupportedFocusModes();
        this.supportedPreviewFormats = var1_1.getSupportedPreviewFormats();
        this.supportedPictureFormats = var1_1.getSupportedPictureFormats();
        this.supportedPreviewSizes = var1_1.getSupportedPreviewSizes();
        cameraConfiguration.supportedPictureSizes = var1_1.getSupportedPictureSizes();
        cameraConfiguration.isConigured = true;
    }

    public List<String> getSupportedFlashModes() {
        return this.supportedFlashModes;
    }

    public List<String> getSupportedFocusModes() {
        return this.supportedFocusModes;
    }

    public List<Integer> getSupportedPreviewFormats() {
        return this.supportedPreviewFormats;
    }

    public List<Integer> getSupportedPictureFormats() {
        return this.supportedPictureFormats;
    }

    public List<Camera.Size> getSupportedPreviewSizes() {
        return this.supportedPreviewSizes;
    }

    public List<Camera.Size> getSupportedPictureSizes() {
        return this.supportedPictureSizes;
    }

    public boolean isConigured() {
        return this.isConigured;
    }

    /*
     * WARNING - void declaration
     */
    public String toString(Context context) {
        void var1_1;
        Object[] objectArray = new Object[10];
        objectArray[0] = Build.PRODUCT;
        objectArray[1] = Build.DEVICE;
        objectArray[2] = Build.BOARD;
        CharSequence charSequence = Build.HARDWARE;
        objectArray[3] = charSequence;
        objectArray[4] = Build.MANUFACTURER;
        objectArray[5] = Build.BRAND;
        objectArray[6] = Build.MODEL;
        objectArray[7] = charSequence;
        objectArray[8] = Build.SERIAL;
        objectArray[9] = Build.FINGERPRINT;
        charSequence = var1_1.getString(R.string.device_configuration, objectArray);
        if (((CameraConfiguration)this_).isConigured) {
            Object this_;
            charSequence = new StringBuilder().append((String)charSequence);
            int n2 = R.string.camera_configuration;
            Object[] objectArray2 = new Object[6];
            int n3 = 0;
            String string2 = ((CameraConfiguration)this_).getSupportedFlashModes() == null ? "" : TextUtils.join((CharSequence)", ", ((CameraConfiguration)this_).getSupportedFlashModes());
            objectArray2[n3] = string2;
            n3 = 1;
            string2 = ((CameraConfiguration)this_).getSupportedFocusModes() == null ? "" : TextUtils.join((CharSequence)", ", ((CameraConfiguration)this_).getSupportedFocusModes());
            objectArray2[n3] = string2;
            n3 = 2;
            string2 = ((CameraConfiguration)this_).getSupportedPreviewFormats() == null ? "" : TextUtils.join((CharSequence)", ", ((CameraConfiguration)this_).getSupportedPreviewFormats());
            objectArray2[n3] = string2;
            n3 = 3;
            string2 = ((CameraConfiguration)this_).getSupportedPictureFormats() == null ? "" : TextUtils.join((CharSequence)", ", ((CameraConfiguration)this_).getSupportedPictureFormats());
            objectArray2[n3] = string2;
            n3 = 4;
            if (((CameraConfiguration)this_).getSupportedPreviewSizes() == null) {
                string2 = "";
            } else {
                CameraConfiguration cameraConfiguration = this_;
                string2 = cameraConfiguration.joinSizes(", ", cameraConfiguration.getSupportedPreviewSizes());
            }
            objectArray2[n3] = string2;
            n3 = 5;
            if (((CameraConfiguration)this_).getSupportedPictureSizes() == null) {
                this_ = "";
            } else {
                CameraConfiguration cameraConfiguration = this_;
                this_ = cameraConfiguration.joinSizes(", ", cameraConfiguration.getSupportedPictureSizes());
            }
            objectArray2[n3] = this_;
            charSequence = ((StringBuilder)charSequence).append(var1_1.getString(n2, objectArray2)).toString();
        }
        return charSequence;
    }
}

