/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import io.scanbot.sdk.bundle.R;
import io.scanbot.sdk.ui.EditPolygonImageView;
import io.scanbot.sdk.util.bitmap.BitmapUtils;

public class MagnifierView
extends View {
    private final float magnifierRaduis;
    private final float magnifierMargin;
    private final int magnifierDrawableResourceId;
    private a magnifier = new a();
    private PointF zoomPoint;
    private Bitmap magnifierFrameBitmap;
    private boolean enableBounding;

    /*
     * WARNING - void declaration
     */
    public MagnifierView(Context context, AttributeSet attrs) {
        super((Context)typedArray, (AttributeSet)var2_2);
        void var2_2;
        TypedArray typedArray;
        typedArray = context.getTheme().obtainStyledAttributes((AttributeSet)var2_2, R.styleable.MagnifierView, 0, 0);
        try {
            this.magnifierDrawableResourceId = typedArray.getResourceId(R.styleable.MagnifierView_magnifierImageSrc, 0);
            this.magnifierRaduis = typedArray.getDimension(R.styleable.MagnifierView_magnifierRadius, this.getResources().getDimension(R.dimen.magnifier_raduis));
            this.magnifierMargin = typedArray.getDimension(R.styleable.MagnifierView_magnifierMargin, this.getResources().getDimension(R.dimen.magnifier_margin));
            this.enableBounding = typedArray.getBoolean(R.styleable.MagnifierView_magnifierEnableBounding, true);
        }
        catch (Throwable throwable) {
            typedArray.recycle();
            throw throwable;
        }
        typedArray.recycle();
    }

    /*
     * WARNING - void declaration
     */
    void drawMagnifier(PointF zoomPoint) {
        void var1_1;
        this.zoomPoint = var1_1;
        this.invalidate();
    }

    void eraseMagnifier() {
        this.zoomPoint = null;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setImageRotation(float rotation) {
        void var1_1;
        MagnifierView magnifierView = this;
        magnifierView.magnifier.a((float)var1_1);
        magnifierView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setupMagnifier(EditPolygonImageView view) {
        void var1_1;
        MagnifierView magnifierView = magnifierView2;
        MagnifierView magnifierView2 = BitmapUtils.drawableToBitmap((Drawable)var1_1.getDrawable());
        magnifierView.magnifier.a((Bitmap)magnifierView2, var1_1.getRotation(), -16777216);
        view.setMagnifier(magnifierView);
    }

    /*
     * WARNING - void declaration
     */
    protected void dispatchDraw(Canvas canvas) {
        void var1_1;
        MagnifierView magnifierView = this;
        super.dispatchDraw((Canvas)var1_1);
        PointF pointF = magnifierView.zoomPoint;
        if (pointF != null) {
            this.magnifier.a((Canvas)var1_1, pointF);
        } else {
            var1_1.drawColor(0);
        }
    }

    public void onAttachedToWindow() {
        BitmapFactory.Options options;
        MagnifierView magnifierView = this;
        super.onAttachedToWindow();
        BitmapFactory.Options options2 = options;
        new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
        this.magnifierFrameBitmap = BitmapFactory.decodeResource((Resources)magnifierView.getResources(), (int)this.magnifierDrawableResourceId, (BitmapFactory.Options)options2);
        if (this.magnifierFrameBitmap == null) {
            this.magnifierFrameBitmap = BitmapUtils.drawableToBitmap((Drawable)this.getResources().getDrawable(this.magnifierDrawableResourceId));
        }
    }

    public void onDetachedFromWindow() {
        MagnifierView magnifierView = this;
        super.onDetachedFromWindow();
        magnifierView.magnifierFrameBitmap.recycle();
        magnifierView.magnifierFrameBitmap = null;
        magnifierView.magnifier.a();
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        MagnifierView magnifierView = this;
        super.onLayout((boolean)var1_1, (int)var2_2, (int)var3_3, (int)var4_4, (int)var5_5);
        magnifierView.magnifier.a(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableBounding(boolean enableBounding) {
        void var1_1;
        this.enableBounding = var1_1;
    }

    private class a {
        private final float a;
        private float b;
        private int c;
        private int d;
        private BitmapShader e;
        private Paint f;
        private Matrix g;
        private float h;
        private float i;
        private float j;
        private Bitmap k;

        a() {
            Matrix matrix;
            this_.a = 2.0f;
            a this_ = matrix;
            matrix = new Matrix();
            v1.g = this_;
        }

        /*
         * WARNING - void declaration
         */
        private Bitmap a(Bitmap bitmap, int outlineColor) {
            void var2_3;
            Paint paint;
            void var1_1;
            Canvas canvas;
            a a2 = canvas;
            void v1 = var1_1;
            a2((Bitmap)var1_1);
            a2 = paint;
            a2();
            paint.setColor((int)var2_3);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(0.0f);
            float f2 = v1.getWidth() - 1;
            float f3 = v1.getHeight() - 1;
            canvas.drawRect(0.0f, 0.0f, f2, f3, (Paint)a2);
            return bitmap;
        }

        /*
         * WARNING - void declaration
         */
        private boolean a(PointF point) {
            void var1_1;
            return (int)((float)(point.x + this.h < (float)(this.k.getWidth() >> 1) ? (var1_1.y + this.i < (float)(this.k.getHeight() >> 1) ? 1 : 4) : (var1_1.y + this.i < (float)(this.k.getHeight() >> 1) ? 2 : 3)) - (360.0f - this.j) % 360.0f / 90.0f) == 1;
        }

        /*
         * WARNING - void declaration
         */
        void a(int width, int height) {
            void var2_2;
            void var1_1;
            this.c = var1_1;
            this.d = var2_2;
            Bitmap bitmap = this.k;
            if (bitmap != null && var1_1 != false && var2_2 != false) {
                a a2 = this;
                a2.b = Math.max((float)bitmap.getWidth() / (float)this.c, (float)this.k.getHeight() / (float)this.d);
                a2.h = ((float)a2.c - (float)this.k.getWidth() / this.b) / 2.0f;
                a2.i = ((float)a2.d - (float)this.k.getHeight() / this.b) / 2.0f;
            }
        }

        /*
         * WARNING - void declaration
         */
        void a(Bitmap bitmap, float rotation, int outsideColor) {
            if (BitmapUtils.isBitmapValid((Bitmap)bitmap)) {
                void var2_2;
                Paint paint;
                void var3_3;
                Paint paint2;
                if (this.e != null) {
                    this.a();
                }
                a a2 = this;
                this.k = this.a((Bitmap)paint2, (int)var3_3);
                Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                this.e = new BitmapShader(this.k, tileMode, tileMode);
                Paint paint3 = paint2 = paint;
                paint3();
                this.f = paint3;
                paint.setShader((Shader)this.e);
                a2.j = var2_2;
                a2.a(a2.MagnifierView.this.getWidth() - MagnifierView.this.getPaddingLeft() - MagnifierView.this.getPaddingRight(), MagnifierView.this.getHeight() - MagnifierView.this.getPaddingTop() - MagnifierView.this.getPaddingBottom());
            }
        }

        void a() {
            Bitmap bitmap = this.k;
            if (bitmap != null) {
                bitmap.recycle();
            }
            a a2 = this;
            a2.k = null;
            a2.f = null;
            a2.e = null;
        }

        /*
         * WARNING - void declaration
         */
        void a(Canvas canvas, PointF zoomPointF) {
            void var1_2;
            void var2_4;
            PointF pointF;
            a a2 = this;
            PointF pointF2 = pointF;
            pointF = new PointF(var2_4.x * (float)this.k.getWidth(), var2_4.y * (float)this.k.getHeight());
            float f2 = a2.MagnifierView.this.magnifierMargin;
            float f3 = a2.MagnifierView.this.magnifierMargin;
            if (a2.MagnifierView.this.enableBounding && this.a(pointF2)) {
                f2 = (float)MagnifierView.this.getWidth() - MagnifierView.this.magnifierRaduis * 2.0f - MagnifierView.this.magnifierMargin;
            }
            void v2 = var1_2;
            a a3 = this;
            a a4 = this;
            a a5 = this;
            a5.g.setScale(2.0f, 2.0f);
            a5.g.postTranslate(-pointF2.x * 2.0f + MagnifierView.this.magnifierRaduis + f2, -pointF2.y * 2.0f + MagnifierView.this.magnifierRaduis + f3);
            a5.e.setLocalMatrix(this.g);
            var1_2.save();
            float f4 = a4.j;
            float f5 = f2 + a4.MagnifierView.this.magnifierRaduis;
            float f6 = f3 + MagnifierView.this.magnifierRaduis;
            var1_2.rotate(f4, f5, f6);
            f4 = f2 + MagnifierView.this.magnifierRaduis;
            f5 = f3 + MagnifierView.this.magnifierRaduis;
            f6 = a3.MagnifierView.this.magnifierRaduis;
            Paint paint = a3.f;
            v2.drawCircle(f4, f5, f6, paint);
            v2.restore();
            var1_2.drawBitmap(MagnifierView.this.magnifierFrameBitmap, f2, f3, null);
        }

        /*
         * WARNING - void declaration
         */
        void a(float rotation) {
            void var1_1;
            this.j = var1_1;
        }
    }
}

