/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.docprocessing.DocumentProcessor;
import io.scanbot.sdk.docprocessing.draft.DocumentDraftExtractor;
import io.scanbot.sdk.entity.DocumentDraft;
import io.scanbot.sdk.entity.SnappingDraft;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.persistence.cleanup.Cleaner;
import io.scanbot.sdk.process.PDFPageSize;
import io.scanbot.sdk.process.PDFRenderer;
import io.scanbot.sdk.util.FileChooserUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010\b\u001a\u0004\u0018\u00010\u00072\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\f\u001a\u0004\u0018\u00010\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\f\u0010\tR\u0016\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\u00108\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0014\u001a\u00020\u00138\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001a\u001a\u00020\u00198\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\u001c8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lio/scanbot/sdk/process/ScanbotPDFRenderer;", "Lio/scanbot/sdk/process/PDFRenderer;", "", "Landroid/net/Uri;", "imageFileUris", "Lio/scanbot/sdk/process/PDFPageSize;", "pageSize", "Ljava/io/File;", "renderDocumentFromImages", "(Ljava/util/List;Lio/scanbot/sdk/process/PDFPageSize;)Ljava/io/File;", "Lio/scanbot/sdk/persistence/Page;", "pages", "renderDocumentFromPages", "Lio/scanbot/sap/SapManager;", "sapManager", "Lio/scanbot/sap/SapManager;", "Landroid/content/Context;", "context", "Landroid/content/Context;", "Lio/scanbot/sdk/persistence/PageFileStorage;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "Lio/scanbot/sdk/docprocessing/DocumentProcessor;", "documentProcessor", "Lio/scanbot/sdk/docprocessing/DocumentProcessor;", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "documentDraftExtractor", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "Lio/scanbot/sdk/persistence/cleanup/Cleaner;", "cleaner", "Lio/scanbot/sdk/persistence/cleanup/Cleaner;", "<init>", "(Landroid/content/Context;Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;Lio/scanbot/sdk/docprocessing/DocumentProcessor;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/persistence/cleanup/Cleaner;Lio/scanbot/sap/SapManager;)V", "sdk-bundle_release"})
public final class ScanbotPDFRenderer
implements PDFRenderer {
    private final Context context;
    private final DocumentDraftExtractor documentDraftExtractor;
    private final DocumentProcessor documentProcessor;
    private final PageFileStorage pageFileStorage;
    private final Cleaner cleaner;
    private final SapManager sapManager;

    public ScanbotPDFRenderer(@NotNull Context context, @NotNull DocumentDraftExtractor documentDraftExtractor, @NotNull DocumentProcessor documentProcessor, @NotNull PageFileStorage pageFileStorage, @NotNull Cleaner cleaner, @NotNull SapManager sapManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)documentDraftExtractor, (String)"documentDraftExtractor");
        Intrinsics.checkNotNullParameter((Object)documentProcessor, (String)"documentProcessor");
        Intrinsics.checkNotNullParameter((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)cleaner, (String)"cleaner");
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"sapManager");
        this.context = context;
        this.documentDraftExtractor = documentDraftExtractor;
        this.documentProcessor = documentProcessor;
        this.pageFileStorage = pageFileStorage;
        this.cleaner = cleaner;
        this.sapManager = sapManager;
    }

    @Override
    @Nullable
    public File renderDocumentFromImages(@NotNull List<? extends Uri> object, @NotNull PDFPageSize pDFPageSize) {
        block13: {
            SnappingDraft snappingDraft;
            ArrayList<Page> arrayList;
            Intrinsics.checkNotNullParameter(object, (String)"imageFileUris");
            Intrinsics.checkNotNullParameter((Object)pDFPageSize, (String)"pageSize");
            if (!this.sapManager.checkLicenseStatus(SdkFeature.PDFCreation).booleanValue()) {
                return null;
            }
            List<? extends Uri> list = object;
            ArrayList<Page> arrayList2 = arrayList;
            arrayList = new ArrayList<Page>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
            object = list.iterator();
            while (true) {
                if (!object.hasNext()) break;
                ArrayList<Page> arrayList3 = arrayList2;
                ScanbotPDFRenderer scanbotPDFRenderer = this;
                ScanbotPDFRenderer scanbotPDFRenderer2 = scanbotPDFRenderer;
                ScanbotPDFRenderer scanbotPDFRenderer3 = scanbotPDFRenderer;
                Object object2 = (Uri)object.next();
                object2 = BitmapFactory.decodeFile((String)FileChooserUtils.getPath((Context)scanbotPDFRenderer2.context, (Uri)object2));
                PageFileStorage pageFileStorage = scanbotPDFRenderer3.pageFileStorage;
                Uri uri = object2;
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"bitmap");
                object2 = pageFileStorage.add((Bitmap)uri);
                arrayList3.add(new Page((String)object2, null, null, 6, null));
            }
            ScanbotPDFRenderer scanbotPDFRenderer = this;
            ScanbotPDFRenderer scanbotPDFRenderer4 = scanbotPDFRenderer;
            ScanbotPDFRenderer scanbotPDFRenderer5 = scanbotPDFRenderer;
            object = snappingDraft;
            new SnappingDraft((List)CollectionsKt.toMutableList(arrayList2), null, (boolean)false, null, (int)14, null).documentName = UUID.randomUUID().toString();
            object = scanbotPDFRenderer4.documentDraftExtractor.extract((SnappingDraft)object)[0];
            v12.pageSize = pDFPageSize;
            object = scanbotPDFRenderer5.documentProcessor.processDocument((DocumentDraft)object);
            if (object == null) break block13;
            this.cleaner.cleanUpDocumentThumbnail(object.getDocument());
        }
        return object != null ? object.getDocumentFile() : null;
    }

    @Override
    @Nullable
    public File renderDocumentFromPages(@NotNull List<Page> documentDraft, @NotNull PDFPageSize pDFPageSize) {
        block5: {
            SnappingDraft snappingDraft;
            Intrinsics.checkNotNullParameter(documentDraft, (String)"pages");
            Intrinsics.checkNotNullParameter((Object)pDFPageSize, (String)"pageSize");
            if (!this.sapManager.checkLicenseStatus(SdkFeature.PDFCreation).booleanValue()) {
                return null;
            }
            ScanbotPDFRenderer scanbotPDFRenderer = this;
            ScanbotPDFRenderer scanbotPDFRenderer2 = scanbotPDFRenderer;
            ScanbotPDFRenderer scanbotPDFRenderer3 = scanbotPDFRenderer;
            SnappingDraft snappingDraft2 = snappingDraft;
            new SnappingDraft((List)CollectionsKt.toMutableList(documentDraft), null, (boolean)false, null, (int)14, null).documentName = UUID.randomUUID().toString();
            documentDraft = scanbotPDFRenderer2.documentDraftExtractor.extract(snappingDraft2)[0];
            v4.pageSize = pDFPageSize;
            documentDraft = scanbotPDFRenderer3.documentProcessor.processDocument(documentDraft);
            if (documentDraft == null) break block5;
            this.cleaner.cleanUpDocumentThumbnail(documentDraft.getDocument());
        }
        return documentDraft != null ? documentDraft.getDocumentFile() : null;
    }
}

