/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process.compose;

import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerFactory;
import io.scanbot.sdk.docprocessing.compose.JpegComposer;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.ocr.process.compose.OcrComposer;
import io.scanbot.sdk.util.device.DeviceUtils;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\tR\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0016\u001a\u00020\u00158\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lio/scanbot/sdk/process/compose/P2ComposerFactory;", "Lio/scanbot/sdk/docprocessing/compose/ComposerFactory;", "Lio/scanbot/sdk/entity/Document;", "document", "", "isJpeg", "(Lio/scanbot/sdk/entity/Document;)Z", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "buildSimpleOrDummyComposer", "(Lio/scanbot/sdk/entity/Document;)Lio/scanbot/sdk/docprocessing/compose/Composer;", "buildJpegOrDummyComposer", "composerForDocument", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "simpleComposer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "Lio/scanbot/sdk/docprocessing/compose/JpegComposer;", "jpegComposer", "Lio/scanbot/sdk/docprocessing/compose/JpegComposer;", "Lio/scanbot/sdk/ocr/process/compose/OcrComposer;", "ocrComposer", "Lio/scanbot/sdk/ocr/process/compose/OcrComposer;", "Lio/scanbot/sdk/util/device/DeviceUtils;", "deviceUtils", "Lio/scanbot/sdk/util/device/DeviceUtils;", "<init>", "(Lio/scanbot/sdk/util/device/DeviceUtils;Lio/scanbot/sdk/ocr/process/compose/OcrComposer;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sdk/docprocessing/compose/JpegComposer;)V", "sdk-bundle_release"})
public final class P2ComposerFactory
implements ComposerFactory {
    private final DeviceUtils deviceUtils;
    private final OcrComposer ocrComposer;
    private final SimpleComposer simpleComposer;
    private final JpegComposer jpegComposer;

    private final boolean isJpeg(Document document) {
        Object object = document.name;
        if (object != null) {
            object = ((String)object).toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(this as java.lang.String).toLowerCase()");
            return StringsKt.endsWith$default((String)object, (String)".jpg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)object, (String)".jpeg", (boolean)false, (int)2, null);
        }
        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
    }

    private final Composer buildSimpleOrDummyComposer(Document document) {
        P2ComposerFactory p2ComposerFactory;
        if (document.size > 0L) {
            ComposerFactory.DummyComposer dummyComposer;
            p2ComposerFactory = dummyComposer;
            dummyComposer = new ComposerFactory.DummyComposer();
        } else {
            p2ComposerFactory = p2ComposerFactory.simpleComposer;
        }
        return p2ComposerFactory;
    }

    private final Composer buildJpegOrDummyComposer(Document document) {
        P2ComposerFactory p2ComposerFactory;
        if (document.size > 0L) {
            ComposerFactory.DummyComposer dummyComposer;
            p2ComposerFactory = dummyComposer;
            dummyComposer = new ComposerFactory.DummyComposer();
        } else {
            p2ComposerFactory = p2ComposerFactory.jpegComposer;
        }
        return p2ComposerFactory;
    }

    @Inject
    public P2ComposerFactory(@NotNull DeviceUtils deviceUtils, @NotNull OcrComposer ocrComposer, @NotNull SimpleComposer simpleComposer, @NotNull JpegComposer jpegComposer) {
        Intrinsics.checkNotNullParameter((Object)deviceUtils, (String)"deviceUtils");
        Intrinsics.checkNotNullParameter((Object)ocrComposer, (String)"ocrComposer");
        Intrinsics.checkNotNullParameter((Object)simpleComposer, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)jpegComposer, (String)"jpegComposer");
        this.deviceUtils = deviceUtils;
        this.ocrComposer = ocrComposer;
        this.simpleComposer = simpleComposer;
        this.jpegComposer = jpegComposer;
    }

    @NotNull
    public Composer composerForDocument(@NotNull Document document) {
        Document document2 = document;
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        if (this.isJpeg(document2)) {
            return this.buildJpegOrDummyComposer(document);
        }
        OcrStatus ocrStatus = document.ocrStatus;
        return ocrStatus == OcrStatus.PENDING_FORCED ? this.ocrComposer : (ocrStatus == OcrStatus.PENDING_ON_CHARGER && this.deviceUtils.isDeviceOnCharger() ? this.ocrComposer : (ocrStatus == OcrStatus.PENDING ? this.ocrComposer : this.buildSimpleOrDummyComposer(document)));
    }
}

