/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.bundle.R;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.camera.autosnapping.IAutoSnappingController;
import io.scanbot.sdk.contourdetector.ContourDetectorFrameHandler;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.ui.BasePolygonView;
import io.scanbot.sdk.ui.PolygonView;
import io.scanbot.sdk.util.view.PolygonHelper;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001uB\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\bs\u0010tB\u001b\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\bs\u0010\nJ!\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0017\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0013\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001cJ\u0017\u0010!\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\b2\b\b\u0001\u0010#\u001a\u00020\u0017\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010&\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b&\u0010\u000fJ\u0017\u0010(\u001a\u00020\b2\b\b\u0001\u0010'\u001a\u00020\u0017\u00a2\u0006\u0004\b(\u0010%J\u0017\u0010*\u001a\u00020\b2\b\b\u0001\u0010)\u001a\u00020\u0017\u00a2\u0006\u0004\b*\u0010%J\u0017\u0010+\u001a\u00020\b2\b\b\u0001\u0010)\u001a\u00020\u0017\u00a2\u0006\u0004\b+\u0010%J\u0017\u0010-\u001a\u00020\b2\b\b\u0001\u0010,\u001a\u00020\u0017\u00a2\u0006\u0004\b-\u0010%J\u0017\u0010/\u001a\u00020\b2\b\b\u0001\u0010.\u001a\u00020\u0017\u00a2\u0006\u0004\b/\u0010%J\u0017\u00100\u001a\u00020\b2\b\b\u0001\u0010.\u001a\u00020\u0017\u00a2\u0006\u0004\b0\u0010%J\u0017\u00102\u001a\u00020\b2\b\b\u0001\u00101\u001a\u00020\u0017\u00a2\u0006\u0004\b2\u0010%J/\u00107\u001a\u00020\b2\u0006\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00172\u0006\u00106\u001a\u00020\u0017H\u0014\u00a2\u0006\u0004\b7\u00108J-\u0010=\u001a\u00020\b2\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u00020\u00172\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0004\u00a2\u0006\u0004\b=\u0010>J\u0017\u0010A\u001a\u00020\b2\u0006\u0010@\u001a\u00020?H\u0014\u00a2\u0006\u0004\bA\u0010BR\u0016\u0010C\u001a\u00020\u00178\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u0016\u0010F\u001a\u00020E8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u0016\u0010\u0016\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010HR\u0016\u0010I\u001a\u0002098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bI\u0010JR(\u0010L\u001a\b\u0012\u0004\u0012\u00020K0\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010M\u001a\u0004\bN\u0010O\"\u0004\bP\u0010\u0014R\u0016\u0010Q\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bQ\u0010HR\u0016\u0010R\u001a\u00020E8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bR\u0010GR\u0016\u0010S\u001a\u00020E8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010GR\u0016\u0010T\u001a\u00020E8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bT\u0010GR\u0016\u0010V\u001a\u00020U8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bV\u0010WR*\u0010Y\u001a\u00020\f2\u0006\u0010X\u001a\u00020\f8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bY\u0010Z\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010\u000fR\u0016\u0010^\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b^\u0010ZR\u0016\u0010`\u001a\u00020_8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b`\u0010aR\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010DR\u0016\u0010b\u001a\u00020U8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bb\u0010WR\u0016\u0010d\u001a\u00020c8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bd\u0010eR\u0016\u0010f\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bf\u0010ZR\u001e\u0010h\u001a\n g*\u0004\u0018\u00010c0c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bh\u0010eR\u0016\u0010i\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bi\u0010ZR\u0016\u0010j\u001a\u00020E8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bj\u0010GR\u0016\u0010k\u001a\u00020E8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bk\u0010GR\u0016\u0010m\u001a\u00020l8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\bm\u0010nR\u0016\u0010o\u001a\u00020E8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bo\u0010GR\u0016\u0010p\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bp\u0010ZR\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010MR\u0016\u0010q\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bq\u0010ZR\u0016\u0010r\u001a\u0002098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\br\u0010J\u00a8\u0006v"}, d2={"Lio/scanbot/sdk/ui/PolygonView;", "Landroid/view/View;", "Lio/scanbot/sdk/ui/BasePolygonView;", "Lio/scanbot/sdk/camera/autosnapping/IAutoSnappingController$AutoSnappingStateListener;", "Landroid/content/Context;", "context", "Landroid/util/AttributeSet;", "attrs", "", "initView", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "loadAttributes", "", "drawShadows", "updateShadows", "(Z)V", "", "Landroid/graphics/PointF;", "polygonToAnimate", "animateToPolygon", "(Ljava/util/List;)V", "", "points", "", "autoSnappingProgress", "updatePath", "([FI)V", "onAttachedToWindow", "()V", "onDetachedFromWindow", "onAutoSnappingCanceled", "", "ms", "onAutoSnappingIn", "(J)V", "fillColor", "setFillColor", "(I)V", "setDrawShadows", "fillColorOK", "setFillColorOK", "strokeColor", "setStrokeColor", "setAutoSnappingProgressStrokeColor", "strokeColorOK", "setStrokeColorOK", "strokeWidth", "setStrokeWidth", "setAutoSnappingProgressStrokeWidth", "cornerRadius", "setCornerRadius", "w", "h", "oldw", "oldh", "onSizeChanged", "(IIII)V", "Lio/scanbot/sdk/core/contourdetector/DetectionResult;", "detectionResult", "frameOrientation", "polygon", "updatePolygon", "(Lio/scanbot/sdk/core/contourdetector/DetectionResult;ILjava/util/List;)V", "Landroid/graphics/Canvas;", "canvas", "onDraw", "(Landroid/graphics/Canvas;)V", "animationProgressMaxValue", "I", "Landroid/graphics/Paint;", "strokePaintOK", "Landroid/graphics/Paint;", "[F", "lastState", "Lio/scanbot/sdk/core/contourdetector/DetectionResult;", "Landroidx/dynamicanimation/animation/SpringAnimation;", "animators", "Ljava/util/List;", "getAnimators", "()Ljava/util/List;", "setAnimators", "animationPoints", "strokePaint", "fillPaintOK", "currentFillPaint", "Landroid/graphics/Path;", "autoSnappingProgressPath", "Landroid/graphics/Path;", "value", "autoSnapProgressEnabled", "Z", "getAutoSnapProgressEnabled", "()Z", "setAutoSnapProgressEnabled", "useFillOK", "Lio/scanbot/sdk/util/view/PolygonHelper;", "polygonHelper", "Lio/scanbot/sdk/util/view/PolygonHelper;", "path", "Landroid/animation/ValueAnimator;", "frameAnimator", "Landroid/animation/ValueAnimator;", "useFill", "kotlin.jvm.PlatformType", "autoSnappingState", "isShouldDrawPoly", "autoSnappingProgressPaint", "currentStrokePaint", "Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "contourDetectorResultHandler", "Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "fillPaint", "isShouldDrawShadows", "drawFill", "lastResult", "<init>", "(Landroid/content/Context;)V", "e", "sdk-bundle_release"})
public class PolygonView
extends View
implements BasePolygonView,
IAutoSnappingController.AutoSnappingStateListener {
    @JvmField
    @NotNull
    protected List<? extends PointF> polygon;
    private float[] points;
    private float[] animationPoints;
    private int autoSnappingProgress;
    private boolean isShouldDrawPoly;
    private boolean isShouldDrawShadows;
    private final Paint strokePaint;
    private final Paint fillPaint;
    private final Paint strokePaintOK;
    private final Paint fillPaintOK;
    private final Paint autoSnappingProgressPaint;
    private boolean useFill;
    private boolean useFillOK;
    private final Path path;
    private final Path autoSnappingProgressPath;
    private PolygonHelper polygonHelper;
    private DetectionResult lastResult;
    private Paint currentFillPaint;
    private Paint currentStrokePaint;
    private boolean drawFill;
    private final ValueAnimator frameAnimator;
    private boolean autoSnapProgressEnabled;
    private final int animationProgressMaxValue;
    private ValueAnimator autoSnappingState;
    private DetectionResult lastState;
    @JvmField
    @NotNull
    public ContourDetectorFrameHandler.ResultHandler contourDetectorResultHandler;
    @NotNull
    private List<SpringAnimation> animators;

    private final void initView(Context context, AttributeSet attributeSet) {
        Paint paint;
        CornerPathEffect cornerPathEffect;
        PolygonView polygonView = this;
        CornerPathEffect cornerPathEffect2 = cornerPathEffect;
        cornerPathEffect = new CornerPathEffect(this.getResources().getDimension(R.dimen.polygon_stroke_radius));
        Paint paint2 = paint = polygonView.strokePaint;
        Paint paint3 = paint;
        paint3.setColor(-1);
        paint3.setStyle(Paint.Style.STROKE);
        paint2.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        paint2.setAntiAlias(true);
        paint.setPathEffect((PathEffect)cornerPathEffect2);
        paint.setStrokeCap(Paint.Cap.SQUARE);
        polygonView.fillPaint.setColor(-16711936);
        polygonView.fillPaint.setStyle(Paint.Style.FILL);
        Paint paint4 = paint = polygonView.strokePaintOK;
        Paint paint5 = paint;
        paint5.setColor(-1);
        paint5.setStyle(Paint.Style.STROKE);
        paint4.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        paint4.setAntiAlias(true);
        paint4.setStrokeCap(Paint.Cap.SQUARE);
        paint.setPathEffect((PathEffect)cornerPathEffect2);
        Paint paint6 = polygonView.fillPaintOK;
        paint6.setColor(-16711936);
        paint6.setStyle(Paint.Style.FILL);
        paint6.setPathEffect((PathEffect)cornerPathEffect2);
        Paint paint7 = polygonView.autoSnappingProgressPaint;
        paint7.setColor(-1);
        paint7.setStyle(Paint.Style.STROKE);
        paint7.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_autosnap_stroke_width));
        paint7.setAntiAlias(true);
        paint7.setStrokeCap(Paint.Cap.SQUARE);
        polygonView.polygon = CollectionsKt.emptyList();
        if (attributeSet != null) {
            this.loadAttributes(context, attributeSet);
        }
    }

    private final void loadAttributes(Context context, AttributeSet attributeSet) {
        CornerPathEffect cornerPathEffect;
        int n2;
        int n3;
        context = context.obtainStyledAttributes(attributeSet, R.styleable.PolygonView);
        try {
            n3 = context.getColor(R.styleable.PolygonView_polygonFillColor, 0);
            n2 = n3 != 0 ? 1 : 0;
        }
        catch (Throwable throwable) {
            context.recycle();
            throw throwable;
        }
        Context context2 = context;
        PolygonView polygonView = this;
        this.useFill = n2;
        this.fillPaint.setColor(n3);
        n2 = context.getColor(R.styleable.PolygonView_polygonStrokeColor, -1);
        polygonView.strokePaint.setColor(n2);
        n3 = context2.getColor(R.styleable.PolygonView_polygonFillColorOK, n3);
        boolean bl = n3 != 0;
        Context context3 = context;
        PolygonView polygonView2 = this;
        PolygonView polygonView3 = polygonView2;
        PolygonView polygonView4 = polygonView2;
        Context context4 = context;
        PolygonView polygonView5 = this;
        PolygonView polygonView6 = polygonView5;
        PolygonView polygonView7 = polygonView5;
        PolygonView polygonView8 = polygonView5;
        PolygonView polygonView9 = polygonView5;
        Context context5 = context;
        Context context6 = context5;
        Context context7 = context5;
        Context context8 = context5;
        PolygonView polygonView10 = this;
        PolygonView polygonView11 = polygonView10;
        PolygonView polygonView12 = polygonView10;
        PolygonView polygonView13 = polygonView10;
        Context context9 = context;
        PolygonView polygonView14 = this;
        this.useFillOK = bl;
        this.fillPaintOK.setColor(n3);
        n3 = context.getColor(R.styleable.PolygonView_polygonStrokeColorOK, n2);
        polygonView14.strokePaintOK.setColor(n3);
        float f2 = context9.getDimension(R.styleable.PolygonView_polygonRoundedCornersRadius, this.getResources().getDimension(R.dimen.polygon_stroke_radius));
        CornerPathEffect cornerPathEffect2 = cornerPathEffect;
        cornerPathEffect = new CornerPathEffect(f2);
        polygonView12.strokePaintOK.setPathEffect((PathEffect)cornerPathEffect2);
        polygonView13.fillPaintOK.setPathEffect((PathEffect)cornerPathEffect2);
        polygonView11.strokePaint.setPathEffect((PathEffect)cornerPathEffect2);
        f2 = context7.getDimension(R.styleable.PolygonView_polygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
        float f3 = context8.getDimension(R.styleable.PolygonView_polygonAutoSnapStrokeWidth, this.getResources().getDimension(R.dimen.polygon_autosnap_stroke_width));
        n2 = context6.getColor(R.styleable.PolygonView_polygonAutoSnapingProgressStrokeColor, n2);
        polygonView6.autoSnappingProgressPaint.setStrokeWidth(f3);
        polygonView7.autoSnappingProgressPaint.setColor(n2);
        polygonView8.strokePaint.setStrokeWidth(f2);
        polygonView9.strokePaintOK.setStrokeWidth(f2);
        boolean bl2 = context4.getBoolean(R.styleable.PolygonView_drawShadow, false);
        polygonView3.isShouldDrawShadows = bl2;
        polygonView4.updateShadows(bl2);
        context3.recycle();
    }

    private final void updateShadows(boolean bl) {
        boolean bl2 = Build.VERSION.SDK_INT >= 26;
        if (!this.useFill && bl && bl2) {
            this.strokePaint.setShadowLayer(35.0f, 0.0f, 0.0f, -16777216);
        } else {
            this.strokePaint.clearShadowLayer();
        }
        if (!this.useFillOK && bl && bl2) {
            this.strokePaintOK.setShadowLayer(35.0f, 0.0f, 0.0f, -16777216);
        } else {
            this.strokePaintOK.clearShadowLayer();
        }
    }

    private final void animateToPolygon(List<? extends PointF> list) {
        if (!this.isShouldDrawPoly) {
            this.polygonHelper.polygonToPoints(list, this.points);
        }
        PolygonView polygonView = this;
        polygonView.isShouldDrawPoly = true;
        polygonView.polygonHelper.polygonToPoints(list, this.animationPoints);
        int n2 = 0;
        for (Object t2 : polygonView.animators) {
            int n3 = n2 + 1;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ((SpringAnimation)t2).animateToFinalPosition(this.animationPoints[n2]);
            n2 = n3;
        }
    }

    private final void updatePath(float[] object, int n2) {
        PolygonView polygonView = this;
        polygonView.path.rewind();
        float f2 = object[0];
        polygonView.path.moveTo(f2, object[1]);
        for (int i2 = 2; i2 < ((float[])object).length; i2 += 2) {
            float f3 = object[i2];
            this.path.lineTo(f3, object[i2 + 1]);
        }
        PolygonView polygonView2 = this;
        polygonView2.path.close();
        PathMeasure pathMeasure = new PathMeasure(this.path, false);
        float f4 = pathMeasure.getLength();
        this.autoSnappingProgressPath.rewind();
        float f5 = f4 * (float)n2 / 100.0f;
        object = this.autoSnappingProgressPath;
        pathMeasure.getSegment(0.0f, f5, (Path)object, true);
        polygonView2.autoSnappingProgressPath.rLineTo(0.0f, 0.0f);
    }

    public PolygonView(@NotNull Context context) {
        ArrayList<SpringAnimation> arrayList;
        PolygonView polygonView = this;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        polygonView.polygon = CollectionsKt.emptyList();
        polygonView.points = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        polygonView.animationPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        polygonView.strokePaint = new Paint();
        polygonView.fillPaint = new Paint();
        polygonView.strokePaintOK = new Paint();
        polygonView.fillPaintOK = new Paint();
        polygonView.autoSnappingProgressPaint = new Paint();
        polygonView.path = new Path();
        polygonView.autoSnappingProgressPath = new Path();
        polygonView.polygonHelper = new PolygonHelper();
        polygonView.lastResult = DetectionResult.ERROR_NOTHING_DETECTED;
        ValueAnimator valueAnimator = ObjectAnimator.ofInt((int[])new int[]{1000});
        Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"it");
        valueAnimator.setDuration(1000L);
        valueAnimator.setRepeatMode(1);
        valueAnimator.setRepeatCount(-1);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ PolygonView a;
            {
                this.a = polygonView;
            }

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                if (this.a.getVisibility() == 0) {
                    a a2 = this;
                    PolygonView polygonView = a2.a;
                    PolygonView.access$updatePath(polygonView, PolygonView.access$getPoints$p(polygonView), PolygonView.access$getAutoSnappingProgress$p(this.a));
                    a2.a.invalidate();
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"ObjectAnimator.ofInt(100\u2026        }\n        }\n    }");
        polygonView.frameAnimator = valueAnimator;
        polygonView.autoSnapProgressEnabled = true;
        polygonView.animationProgressMaxValue = 100;
        ValueAnimator valueAnimator2 = ObjectAnimator.ofInt((int[])new int[]{100});
        Intrinsics.checkNotNullExpressionValue((Object)valueAnimator2, (String)"it");
        valueAnimator2.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        valueAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ PolygonView a;
            {
                this.a = polygonView;
            }

            public final void onAnimationUpdate(ValueAnimator object) {
                if (this.a.getVisibility() == 0 && this.a.getAutoSnapProgressEnabled()) {
                    ValueAnimator valueAnimator = object;
                    object = this.a;
                    Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"it");
                    Object object2 = valueAnimator.getAnimatedValue();
                    if (object2 != null) {
                        PolygonView.access$setAutoSnappingProgress$p((PolygonView)((Object)object), (Integer)object2);
                        PolygonView polygonView = this.a;
                        PolygonView.access$updatePath(polygonView, PolygonView.access$getPoints$p(polygonView), PolygonView.access$getAutoSnappingProgress$p(this.a));
                    } else {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                }
            }
        });
        polygonView.autoSnappingState = valueAnimator2;
        polygonView.lastState = DetectionResult.ERROR_NOTHING_DETECTED;
        polygonView.contourDetectorResultHandler = new ContourDetectorFrameHandler.ResultHandler(this){
            final /* synthetic */ PolygonView a;
            {
                this.a = polygonView;
            }

            public final boolean handle(final @NotNull FrameHandlerResult<ContourDetectorFrameHandler.DetectedFrame, SdkLicenseError> detectedFrame) {
                ContourDetectorFrameHandler.DetectedFrame detectedFrame2 = detectedFrame;
                Intrinsics.checkNotNullParameter(detectedFrame2, (String)"result");
                if (detectedFrame2 instanceof FrameHandlerResult.Success) {
                    detectedFrame = (ContourDetectorFrameHandler.DetectedFrame)((FrameHandlerResult.Success)detectedFrame).getValue();
                    this.a.post(new Runnable(){

                        @Override
                        public final void run() {
                            ContourDetectorFrameHandler.DetectedFrame detectedFrame2 = a2.detectedFrame;
                            a a2 = detectedFrame2.detectionResult;
                            int n2 = detectedFrame2.frameOrientation;
                            List list = detectedFrame2.polygon;
                            a.updatePolygon((DetectionResult)a2, n2, list);
                        }
                    });
                }
                return false;
            }
        };
        float[] fArray = polygonView.points;
        ArrayList<SpringAnimation> arrayList2 = arrayList;
        arrayList = new ArrayList<SpringAnimation>(fArray.length);
        int n2 = 0;
        int n3 = polygonView.points.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            e e2;
            float cfr_ignored_0 = fArray[i2];
            int n4 = n2 + 1;
            PolygonView polygonView2 = this;
            e e3 = e2;
            e2 = new e(n2);
            SpringAnimation springAnimation = new SpringAnimation((Object)polygonView2, (FloatPropertyCompat)e3, polygonView2.animationPoints[n2]);
            SpringForce springForce = springAnimation.getSpring();
            Intrinsics.checkNotNullExpressionValue((Object)springForce, (String)"it");
            springForce.setStiffness(300.0f);
            springForce.setDampingRatio(0.9f);
            arrayList2.add(springAnimation);
            n2 = n4;
        }
        this.animators = arrayList2;
        this.initView(context, null);
    }

    public PolygonView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        ArrayList<SpringAnimation> arrayList;
        PolygonView polygonView = this;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet);
        polygonView.polygon = CollectionsKt.emptyList();
        polygonView.points = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        polygonView.animationPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        polygonView.strokePaint = new Paint();
        polygonView.fillPaint = new Paint();
        polygonView.strokePaintOK = new Paint();
        polygonView.fillPaintOK = new Paint();
        polygonView.autoSnappingProgressPaint = new Paint();
        polygonView.path = new Path();
        polygonView.autoSnappingProgressPath = new Path();
        polygonView.polygonHelper = new PolygonHelper();
        polygonView.lastResult = DetectionResult.ERROR_NOTHING_DETECTED;
        ValueAnimator valueAnimator = ObjectAnimator.ofInt((int[])new int[]{1000});
        Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"it");
        valueAnimator.setDuration(1000L);
        valueAnimator.setRepeatMode(1);
        valueAnimator.setRepeatCount(-1);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ PolygonView a;
            {
                this.a = polygonView;
            }

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                if (this.a.getVisibility() == 0) {
                    c c2 = this;
                    PolygonView polygonView = c2.a;
                    PolygonView.access$updatePath(polygonView, PolygonView.access$getPoints$p(polygonView), PolygonView.access$getAutoSnappingProgress$p(this.a));
                    c2.a.invalidate();
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"ObjectAnimator.ofInt(100\u2026        }\n        }\n    }");
        polygonView.frameAnimator = valueAnimator;
        polygonView.autoSnapProgressEnabled = true;
        polygonView.animationProgressMaxValue = 100;
        ValueAnimator valueAnimator2 = ObjectAnimator.ofInt((int[])new int[]{100});
        Intrinsics.checkNotNullExpressionValue((Object)valueAnimator2, (String)"it");
        valueAnimator2.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        valueAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ PolygonView a;
            {
                this.a = polygonView;
            }

            public final void onAnimationUpdate(ValueAnimator object) {
                if (this.a.getVisibility() == 0 && this.a.getAutoSnapProgressEnabled()) {
                    ValueAnimator valueAnimator = object;
                    object = this.a;
                    Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"it");
                    Object object2 = valueAnimator.getAnimatedValue();
                    if (object2 != null) {
                        PolygonView.access$setAutoSnappingProgress$p((PolygonView)((Object)object), (Integer)object2);
                        PolygonView polygonView = this.a;
                        PolygonView.access$updatePath(polygonView, PolygonView.access$getPoints$p(polygonView), PolygonView.access$getAutoSnappingProgress$p(this.a));
                    } else {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                }
            }
        });
        polygonView.autoSnappingState = valueAnimator2;
        polygonView.lastState = DetectionResult.ERROR_NOTHING_DETECTED;
        polygonView.contourDetectorResultHandler = new /* invalid duplicate definition of identical inner class */;
        float[] fArray = polygonView.points;
        ArrayList<SpringAnimation> arrayList2 = arrayList;
        arrayList = new ArrayList<SpringAnimation>(fArray.length);
        int n2 = 0;
        int n3 = polygonView.points.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            e e2;
            float cfr_ignored_0 = fArray[i2];
            int n4 = n2 + 1;
            PolygonView polygonView2 = this;
            e e3 = e2;
            e2 = new e(n2);
            SpringAnimation springAnimation = new SpringAnimation((Object)polygonView2, (FloatPropertyCompat)e3, polygonView2.animationPoints[n2]);
            SpringForce springForce = springAnimation.getSpring();
            Intrinsics.checkNotNullExpressionValue((Object)springForce, (String)"it");
            springForce.setStiffness(300.0f);
            springForce.setDampingRatio(0.9f);
            arrayList2.add(springAnimation);
            n2 = n4;
        }
        this.animators = arrayList2;
        this.initView(context, attributeSet);
    }

    public static final /* synthetic */ void access$setPoints$p(PolygonView polygonView, float[] fArray) {
        polygonView.points = fArray;
    }

    public static final /* synthetic */ void access$setAutoSnappingState$p(PolygonView polygonView, ValueAnimator valueAnimator) {
        polygonView.autoSnappingState = valueAnimator;
    }

    public static final /* synthetic */ int access$getAutoSnappingProgress$p(PolygonView polygonView) {
        return polygonView.autoSnappingProgress;
    }

    public static final /* synthetic */ void access$updatePath(PolygonView polygonView, float[] fArray, int n2) {
        polygonView.updatePath(fArray, n2);
    }

    public final boolean getAutoSnapProgressEnabled() {
        return this.autoSnapProgressEnabled;
    }

    public final void setAutoSnapProgressEnabled(boolean bl) {
        if (!bl) {
            this.autoSnappingState.cancel();
        }
        this.autoSnapProgressEnabled = bl;
    }

    protected void onAttachedToWindow() {
        PolygonView polygonView = this;
        super.onAttachedToWindow();
        polygonView.frameAnimator.start();
    }

    protected void onDetachedFromWindow() {
        PolygonView polygonView = this;
        super.onDetachedFromWindow();
        polygonView.frameAnimator.cancel();
    }

    public void onAutoSnappingCanceled() {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public final void run() {
                g g2 = this;
                autoSnappingState.cancel();
                autoSnappingProgress = 0;
                g2.this.invalidate();
            }
        };
        this.post(runnable2);
    }

    public void onAutoSnappingIn(final long l2) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public final void run() {
                ValueAnimator valueAnimator = autoSnappingState;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"autoSnappingState");
                if (!valueAnimator.isRunning() && this.getAutoSnapProgressEnabled()) {
                    h h2 = this;
                    ValueAnimator valueAnimator2 = autoSnappingState;
                    Intrinsics.checkNotNullExpressionValue((Object)valueAnimator2, (String)"autoSnappingState");
                    valueAnimator2.setDuration(l2);
                    autoSnappingState.start();
                }
            }
        };
        this.post(runnable2);
    }

    public final void setFillColor(@ColorInt int n2) {
        boolean bl = n2 != 0;
        PolygonView polygonView = this;
        polygonView.useFill = bl;
        polygonView.fillPaint.setColor(n2);
        polygonView.updateShadows(polygonView.isShouldDrawShadows);
        polygonView.postInvalidate();
    }

    public final void setDrawShadows(boolean bl) {
        PolygonView polygonView = this;
        polygonView.isShouldDrawShadows = bl;
        polygonView.updateShadows(bl);
        polygonView.postInvalidate();
    }

    public final void setFillColorOK(@ColorInt int n2) {
        boolean bl = n2 != 0;
        PolygonView polygonView = this;
        polygonView.useFillOK = bl;
        polygonView.fillPaintOK.setColor(n2);
        polygonView.updateShadows(polygonView.isShouldDrawShadows);
        polygonView.postInvalidate();
    }

    public final void setStrokeColor(@ColorInt int n2) {
        PolygonView polygonView = this;
        polygonView.strokePaint.setColor(n2);
        polygonView.postInvalidate();
    }

    public final void setAutoSnappingProgressStrokeColor(@ColorInt int n2) {
        PolygonView polygonView = this;
        polygonView.autoSnappingProgressPaint.setColor(n2);
        polygonView.postInvalidate();
    }

    public final void setStrokeColorOK(@ColorInt int n2) {
        PolygonView polygonView = this;
        polygonView.strokePaintOK.setColor(n2);
        polygonView.postInvalidate();
    }

    public final void setStrokeWidth(@Px int n2) {
        PolygonView polygonView = this;
        float f2 = n2;
        polygonView.strokePaint.setStrokeWidth(f2);
        polygonView.strokePaintOK.setStrokeWidth(f2);
        polygonView.postInvalidate();
    }

    public final void setAutoSnappingProgressStrokeWidth(@Px int n2) {
        PolygonView polygonView = this;
        polygonView.autoSnappingProgressPaint.setStrokeWidth((float)n2);
        polygonView.postInvalidate();
    }

    public final void setCornerRadius(@Px int n2) {
        CornerPathEffect cornerPathEffect;
        PolygonView polygonView = polygonView2;
        PolygonView polygonView2 = cornerPathEffect;
        cornerPathEffect = new CornerPathEffect((float)n2);
        polygonView.strokePaintOK.setPathEffect((PathEffect)polygonView2);
        polygonView.fillPaintOK.setPathEffect((PathEffect)polygonView2);
        polygonView.strokePaint.setPathEffect((PathEffect)polygonView2);
        polygonView.postInvalidate();
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        PolygonView polygonView = this;
        super.onSizeChanged(n2, n3, n4, n5);
        polygonView.polygonHelper.setLayout(0, 0, n2, n3);
    }

    protected final void updatePolygon(@NotNull DetectionResult detectionResult, int n2, @NotNull List<? extends PointF> list) {
        Intrinsics.checkNotNullParameter((Object)detectionResult, (String)"detectionResult");
        Intrinsics.checkNotNullParameter(list, (String)"polygon");
        this.lastResult = detectionResult;
        DetectionResult detectionResult2 = DetectionResult.OK;
        Paint paint = detectionResult == detectionResult2 ? this.fillPaintOK : this.fillPaint;
        this.currentFillPaint = paint;
        paint = detectionResult == detectionResult2 ? this.strokePaintOK : this.strokePaint;
        this.currentStrokePaint = paint;
        boolean bl = detectionResult == detectionResult2 ? this.useFillOK : this.useFill;
        this.drawFill = bl;
        this.polygonHelper.setRotation(n2);
        this.polygon = list;
        if (list.isEmpty()) {
            this.isShouldDrawPoly = false;
            return;
        }
        this.animateToPolygon(list);
    }

    @NotNull
    public final List<SpringAnimation> getAnimators() {
        return this.animators;
    }

    public final void setAnimators(@NotNull List<SpringAnimation> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.animators = list;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        PolygonView polygonView = polygonView5;
        Canvas canvas2 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas2, (String)"canvas");
        super.onDraw(canvas2);
        if (polygonView.isShouldDrawPoly) {
            Paint paint;
            Path path;
            if (polygonView5.drawFill) {
                PolygonView polygonView2 = polygonView5;
                path = polygonView2.path;
                paint = polygonView2.currentFillPaint;
                if (paint == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentFillPaint");
                }
                canvas.drawPath(path, paint);
            }
            PolygonView polygonView3 = polygonView5;
            path = polygonView3.path;
            paint = polygonView3.currentStrokePaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentStrokePaint");
            }
            PolygonView polygonView4 = polygonView5;
            canvas.drawPath(path, paint);
            PolygonView polygonView5 = polygonView4.autoSnappingProgressPath;
            canvas.drawPath((Path)polygonView5, polygonView4.autoSnappingProgressPaint);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\tR\u0016\u0010\f\u001a\u00020\n8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u000b\u00a8\u0006\u000f"}, d2={"io/scanbot/sdk/ui/PolygonView$e", "Landroidx/dynamicanimation/animation/FloatPropertyCompat;", "Lio/scanbot/sdk/ui/PolygonView;", "view", "", "value", "", "a", "(Lio/scanbot/sdk/ui/PolygonView;F)V", "(Lio/scanbot/sdk/ui/PolygonView;)F", "", "I", "coordinate", "<init>", "(I)V", "sdk-bundle_release"})
    private static final class e
    extends FloatPropertyCompat<PolygonView> {
        private final int a;

        public e(int n2) {
            super("coordinate" + n2);
            this.a = n2;
        }

        public void a(@NotNull PolygonView polygonView, float f2) {
            PolygonView polygonView2 = polygonView;
            Intrinsics.checkNotNullParameter((Object)((Object)polygonView2), (String)"view");
            ((PolygonView)polygonView2).points[this.a] = f2;
        }

        public float a(@NotNull PolygonView polygonView) {
            PolygonView polygonView2 = polygonView;
            Intrinsics.checkNotNullParameter((Object)((Object)polygonView2), (String)"view");
            return polygonView2.points[this.a];
        }
    }
}

