/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.widget.AppCompatImageView;
import io.scanbot.sdk.ScanbotSDKInitializer;
import io.scanbot.sdk.bundle.R;
import io.scanbot.sdk.core.contourdetector.Line2D;
import io.scanbot.sdk.ui.EditPolygonImageView;
import io.scanbot.sdk.ui.MagnifierView;
import io.scanbot.sdk.util.PolygonHelper;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import io.scanbot.sdk.util.view.PolygonHelper;
import io.scanbot.sdk.utils.ViewUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u009f\u00012\u00020\u0001:\u0006\u009f\u0001\u00a0\u0001\u00a1\u0001B\u001f\u0012\b\u0010\u009a\u0001\u001a\u00030\u0099\u0001\u0012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009b\u0001\u00a2\u0006\u0006\b\u009d\u0001\u0010\u009e\u0001J\u001f\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ1\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\tJ\u000f\u0010\u0016\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\tJ\u000f\u0010\u0017\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0017\u0010\tJ\u000f\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001b\u0010\tJ\u000f\u0010\u001c\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001c\u0010\tJ\u000f\u0010\u001d\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001d\u0010\tJ\u000f\u0010\u001e\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\u001e\u0010\tJ\u000f\u0010\u001f\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\u001f\u0010\tJ\u001f\u0010#\u001a\u00020\u00072\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 H\u0014\u00a2\u0006\u0004\b#\u0010$J7\u0010*\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020 H\u0014\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b-\u0010.J)\u00103\u001a\u00020\u00072\f\u00101\u001a\b\u0012\u0004\u0012\u0002000/2\f\u00102\u001a\b\u0012\u0004\u0012\u0002000/\u00a2\u0006\u0004\b3\u00104J\u0015\u00106\u001a\u00020\u00072\u0006\u00105\u001a\u00020 \u00a2\u0006\u0004\b6\u00107J\u0015\u00108\u001a\u00020\u00072\u0006\u00105\u001a\u00020 \u00a2\u0006\u0004\b8\u00107J\u0015\u0010:\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0002\u00a2\u0006\u0004\b:\u0010.J\r\u0010;\u001a\u00020\u0007\u00a2\u0006\u0004\b;\u0010\tJ\r\u0010<\u001a\u00020\u0007\u00a2\u0006\u0004\b<\u0010\tJ\u0017\u0010=\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b=\u0010>J\u0017\u0010A\u001a\u00020\u00182\u0006\u0010@\u001a\u00020?H\u0016\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010E\u001a\u00020\u00072\b\u0010D\u001a\u0004\u0018\u00010C\u00a2\u0006\u0004\bE\u0010FJ\u0017\u0010I\u001a\u00020\u00072\b\u0010H\u001a\u0004\u0018\u00010G\u00a2\u0006\u0004\bI\u0010JJ\u0017\u0010M\u001a\u00020\u00072\b\u0010L\u001a\u0004\u0018\u00010K\u00a2\u0006\u0004\bM\u0010NR\u0016\u0010O\u001a\u00020\u00028\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bO\u0010PR\u0018\u0010R\u001a\u0004\u0018\u00010Q8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010SR\u0018\u0010U\u001a\u0004\u0018\u00010T8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bU\u0010VR\u0016\u0010W\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bW\u0010PR\u0016\u0010X\u001a\u00020\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bX\u0010YR\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020[0Z8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u0010\\R\u0016\u0010]\u001a\u00020\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b]\u0010YR\u001c\u0010^\u001a\b\u0012\u0004\u0012\u0002000Z8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b^\u0010\\R\u0016\u0010`\u001a\u00020_8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b`\u0010aR\u001c\u0010b\u001a\b\u0012\u0004\u0012\u00020\f0Z8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bb\u0010\\R\u0016\u0010d\u001a\u00020c8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bd\u0010eR\u0018\u0010f\u001a\u0004\u0018\u00010T8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bf\u0010VR\"\u0010g\u001a\u00020\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bg\u0010h\u001a\u0004\bg\u0010\u001a\"\u0004\bi\u0010jR\u0016\u0010k\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bk\u0010PR\u0016\u0010l\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bl\u0010PR\"\u0010m\u001a\u00020\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bm\u0010h\u001a\u0004\bn\u0010\u001a\"\u0004\bo\u0010jR\u0018\u0010p\u001a\u0004\u0018\u00010C8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bp\u0010qR\u0018\u0010r\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\br\u0010sR\u0016\u0010t\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bt\u0010PR\u0016\u0010u\u001a\u00020c8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bu\u0010eR\u0016\u0010v\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bv\u0010PR\u0018\u0010H\u001a\u0004\u0018\u00010G8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010wR0\u0010}\u001a\b\u0012\u0004\u0012\u00020\f0/2\f\u0010x\u001a\b\u0012\u0004\u0012\u00020\f0/8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\by\u0010z\"\u0004\b{\u0010|R\u0017\u0010\u007f\u001a\u00020~8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u007f\u0010\u0080\u0001R\u0019\u0010\u0081\u0001\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0081\u0001\u0010\u0082\u0001R\u001e\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020\f0/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0083\u0001\u0010\\R\u0019\u0010\u0084\u0001\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0084\u0001\u0010\u0082\u0001R\u0019\u0010\u0085\u0001\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0085\u0001\u0010\u0082\u0001R\u001a\u0010\u0087\u0001\u001a\u00030\u0086\u00018\u0002@\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0087\u0001\u0010\u0088\u0001R\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020[0Z8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u0010\\R\u001e\u0010\u0089\u0001\u001a\b\u0012\u0004\u0012\u0002000Z8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0089\u0001\u0010\\R\u0019\u0010L\u001a\u0004\u0018\u00010K8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\bL\u0010\u008a\u0001R\u001e\u0010\u008b\u0001\u001a\b\u0012\u0004\u0012\u00020Q0Z8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u008b\u0001\u0010\\R\u0018\u0010\u008c\u0001\u001a\u00020\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u008c\u0001\u0010YR\u0018\u0010\u008d\u0001\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u008d\u0001\u0010PR)\u0010\u0090\u0001\u001a\u0012\u0012\r\u0012\u000b \u008f\u0001*\u0004\u0018\u00010\f0\f0\u008e\u00018\u0002@\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0090\u0001\u0010\u0091\u0001R\u0019\u0010\u0092\u0001\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0092\u0001\u0010\u0082\u0001R\u0018\u0010\u0093\u0001\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0093\u0001\u0010PR\u001a\u0010\u0094\u0001\u001a\u0004\u0018\u00010\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0094\u0001\u0010YR\u0018\u0010\u0095\u0001\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0095\u0001\u0010PR\u0018\u0010\u0096\u0001\u001a\u00020c8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0096\u0001\u0010eR\u001a\u0010\u0097\u0001\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0097\u0001\u0010sR\u0019\u0010\u0098\u0001\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0098\u0001\u0010\u0082\u0001\u00a8\u0006\u00a2\u0001"}, d2={"Lio/scanbot/sdk/ui/EditPolygonImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "", "currentRotation", "rotateBy", "getRotationScale", "(FF)F", "", "checkWhetherImageSizeUpdated", "()V", "Landroid/graphics/Canvas;", "canvas", "Landroid/graphics/PointF;", "point", "Landroid/graphics/Bitmap;", "handle", "degrees", "drawHandle", "(Landroid/graphics/Canvas;Landroid/graphics/PointF;Landroid/graphics/Bitmap;F)V", "keepInsideView", "(Landroid/graphics/PointF;)V", "checkPolygonSelection", "restoreSelectedEdge", "ensureNoPolygonIntersection", "", "ensureCornersOrder", "()Z", "calculateMedian", "ensureEdgesOrder", "onImageSizeUpdated", "onAttachedToWindow", "onDetachedFromWindow", "", "widthMeasureSpec", "heightMeasureSpec", "onMeasure", "(II)V", "changed", "left", "top", "right", "bottom", "onLayout", "(ZIIII)V", "rotation", "setRotation", "(F)V", "", "Lio/scanbot/sdk/core/contourdetector/Line2D;", "horizontalLines", "verticalLines", "setLines", "(Ljava/util/List;Ljava/util/List;)V", "color", "setEdgeColor", "(I)V", "setEdgeColorOnLine", "width", "setEdgeWidth", "rotateClockwise", "rotateCounterClockwise", "dispatchDraw", "(Landroid/graphics/Canvas;)V", "Landroid/view/MotionEvent;", "event", "onTouchEvent", "(Landroid/view/MotionEvent;)Z", "Lio/scanbot/sdk/ui/MagnifierView;", "magnifier", "setMagnifier", "(Lio/scanbot/sdk/ui/MagnifierView;)V", "Lio/scanbot/sdk/ui/EditPolygonImageView$EditPolygonAnimationEndListener;", "editPolygonAnimationEndListener", "setEditPolygonAnimationEndListener", "(Lio/scanbot/sdk/ui/EditPolygonImageView$EditPolygonAnimationEndListener;)V", "Lio/scanbot/sdk/ui/EditPolygonImageView$EditPolygonDragListener;", "editPolygonDragListener", "setEditPolygonDragListener", "(Lio/scanbot/sdk/ui/EditPolygonImageView$EditPolygonDragListener;)V", "rotationScale", "F", "Lio/scanbot/sdk/util/view/PolygonHelper$Edge;", "selectedEdge", "Lio/scanbot/sdk/util/view/PolygonHelper$Edge;", "Landroid/graphics/drawable/Drawable;", "cornerDrawable", "Landroid/graphics/drawable/Drawable;", "polygonStrokeWidth", "finger", "Landroid/graphics/PointF;", "", "Lio/scanbot/sdk/util/view/PolygonHelper$Line;", "Ljava/util/List;", "tmpPointA", "verticalLines2D", "Lio/scanbot/sdk/util/view/PolygonHelper;", "polygonHelper", "Lio/scanbot/sdk/util/view/PolygonHelper;", "corners", "Landroid/graphics/Paint;", "paintOnLine", "Landroid/graphics/Paint;", "edgeDrawable", "isPointsDraggable", "Z", "setPointsDraggable", "(Z)V", "medianX", "offsetY", "fullPolygonSelected", "getFullPolygonSelected", "setFullPolygonSelected", "magnifierView", "Lio/scanbot/sdk/ui/MagnifierView;", "edgeBitmap", "Landroid/graphics/Bitmap;", "magneticLineTreshold", "handlePaint", "scalePortrait", "Lio/scanbot/sdk/ui/EditPolygonImageView$EditPolygonAnimationEndListener;", "newPolygon", "getPolygon", "()Ljava/util/List;", "setPolygon", "(Ljava/util/List;)V", "polygon", "", "imageMatrix", "[F", "edgeColorOnLine", "I", "_polygon", "edgeColor", "handleSize", "Landroid/graphics/RectF;", "touchRect", "Landroid/graphics/RectF;", "horizontalLines2D", "Lio/scanbot/sdk/ui/EditPolygonImageView$EditPolygonDragListener;", "edges", "tmpPointB", "medianY", "Ljava/util/PriorityQueue;", "kotlin.jvm.PlatformType", "pointsQueue", "Ljava/util/PriorityQueue;", "lastKnownImageHeight", "scaleLandscape", "selectedCorner", "offsetX", "paint", "cornerBitmap", "lastKnownImageWidth", "Landroid/content/Context;", "context", "Landroid/util/AttributeSet;", "attrs", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "Companion", "EditPolygonAnimationEndListener", "EditPolygonDragListener", "sdk-bundle_release"})
public final class EditPolygonImageView
extends AppCompatImageView {
    private static final int CORNERS_COUNT = 4;
    public static final Companion Companion = new Companion(null);
    private EditPolygonAnimationEndListener editPolygonAnimationEndListener;
    private EditPolygonDragListener editPolygonDragListener;
    private float magneticLineTreshold;
    private int edgeColor;
    private int edgeColorOnLine;
    private Drawable cornerDrawable;
    private Drawable edgeDrawable;
    private final Paint paint;
    private final Paint paintOnLine;
    private final Paint handlePaint;
    private final io.scanbot.sdk.util.view.PolygonHelper polygonHelper;
    private final float rotationScale;
    private boolean isPointsDraggable;
    private final List<Line2D> horizontalLines2D;
    private final List<Line2D> verticalLines2D;
    private final List<PolygonHelper.Line> horizontalLines;
    private final List<PolygonHelper.Line> verticalLines;
    private final PointF finger;
    private List<? extends PointF> _polygon;
    private final List<PointF> corners;
    private final List<PolygonHelper.Edge> edges;
    private float offsetX;
    private float offsetY;
    private Bitmap cornerBitmap;
    private Bitmap edgeBitmap;
    private int handleSize;
    private PointF selectedCorner;
    private PolygonHelper.Edge selectedEdge;
    private final PointF tmpPointA;
    private final PointF tmpPointB;
    private float medianX;
    private float medianY;
    private final PriorityQueue<PointF> pointsQueue;
    private MagnifierView magnifierView;
    private final float[] imageMatrix;
    private final RectF touchRect;
    private float polygonStrokeWidth;
    private int lastKnownImageWidth;
    private int lastKnownImageHeight;
    private float scaleLandscape;
    private float scalePortrait;
    private boolean fullPolygonSelected;

    private final float getRotationScale(float f2, float f3) {
        return Math.abs((f2 + f3) % (float)360) / (float)90 % (float)2 == 0.0f ? this.scalePortrait : this.scaleLandscape;
    }

    private final void checkWhetherImageSizeUpdated() {
        Drawable drawable = this.getDrawable();
        if (drawable != null) {
            if (drawable.getIntrinsicWidth() != this.lastKnownImageWidth || drawable.getIntrinsicHeight() != this.lastKnownImageHeight) {
                this.lastKnownImageWidth = drawable.getIntrinsicWidth();
                this.lastKnownImageHeight = drawable.getIntrinsicHeight();
                this.onImageSizeUpdated();
            }
            return;
        }
    }

    private final void drawHandle(Canvas canvas, PointF pointF, Bitmap bitmap, float f2) {
        if (bitmap != null) {
            canvas.save();
            if (f2 != 0.0f) {
                PointF pointF2 = pointF;
                float f3 = pointF2.x;
                float f4 = pointF2.y;
                canvas.rotate(f2, f3, f4);
            }
            Canvas canvas2 = canvas;
            PointF pointF3 = pointF;
            PointF pointF4 = pointF;
            EditPolygonImageView editPolygonImageView = this;
            float f5 = 1.0f / editPolygonImageView.getRotationScale(editPolygonImageView.getRotation(), 0.0f);
            float f6 = pointF4.x;
            float f7 = pointF4.y;
            float f8 = f5;
            canvas.scale(f8, f8, f6, f7);
            f5 = pointF3.x - (float)(bitmap.getWidth() >> 1);
            f6 = pointF3.y - (float)(bitmap.getHeight() >> 1);
            Paint paint = this.handlePaint;
            canvas2.drawBitmap(bitmap, f5, f6, paint);
            canvas2.restore();
        }
    }

    private final void keepInsideView(PointF pointF) {
        PointF pointF2 = pointF;
        float f2 = 2;
        pointF2.set(RangesKt.coerceIn((float)pointF2.x, (float)0.0f, (float)((float)this.getWidth() - f2 * this.offsetX)), RangesKt.coerceIn((float)pointF.y, (float)0.0f, (float)((float)this.getHeight() - f2 * this.offsetY)));
    }

    private final void checkPolygonSelection() {
        EditPolygonImageView editPolygonImageView = this;
        boolean bl = editPolygonImageView._polygon.containsAll(PolygonHelper.Companion.getFullPolygon());
        if (editPolygonImageView.fullPolygonSelected != bl) {
            EditPolygonDragListener editPolygonDragListener = this.editPolygonDragListener;
            if (editPolygonDragListener != null) {
                EditPolygonDragListener editPolygonDragListener2 = editPolygonDragListener;
                Intrinsics.checkNotNull((Object)editPolygonDragListener2);
                editPolygonDragListener2.onPolygonSelectedStateChanged(bl);
            }
            this.fullPolygonSelected = bl;
        }
    }

    private final void restoreSelectedEdge() {
        PolygonHelper.Edge edge = editPolygonImageView.selectedEdge;
        if (edge != null) {
            PolygonHelper.Edge edge2 = edge;
            edge2.pointA.set(editPolygonImageView.tmpPointA);
            edge2.pointB.set(editPolygonImageView.tmpPointB);
            PolygonHelper.Edge edge3 = edge;
            EditPolygonImageView editPolygonImageView = edge3.pointA;
            edge2.edgeLine.calculateLine((PointF)editPolygonImageView, edge3.pointB);
        }
    }

    private final void ensureNoPolygonIntersection() {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.calculateMedian();
        if (editPolygonImageView.ensureCornersOrder()) {
            this.ensureEdgesOrder();
        }
    }

    private final boolean ensureCornersOrder() {
        boolean bl = false;
        this.pointsQueue.addAll(this.corners);
        int n = 4;
        for (int i = 0; i < n; ++i) {
            PointF pointF = (PointF)this.pointsQueue.remove();
            if (Intrinsics.areEqual((Object)pointF, (Object)this.corners.get(i)) ^ true) {
                bl = true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)pointF, (String)"pointF");
            this.corners.set(i, pointF);
        }
        return bl;
    }

    private final void calculateMedian() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n = 4;
        for (int i = 0; i < n; ++i) {
            float f4 = f3;
            PointF pointF = this.corners.get(i);
            f3 = f2 + pointF.x;
            f2 = f4 + pointF.y;
            float f5 = f3;
            f3 = f2;
            f2 = f5;
        }
        float f6 = 4;
        this.medianX = f2 / f6;
        this.medianY = f3 / f6;
    }

    private final void ensureEdgesOrder() {
        int n = 0;
        int n2 = 4;
        while (n < n2) {
            PolygonHelper.Edge edge = this.edges.get(n);
            edge.pointA = this.corners.get(n);
            int n3 = n + 1;
            edge.pointB = this.corners.get(n3 % 4);
            edge.pointFarA = this.corners.get((n + 3) % 4);
            this.edges.get(n).pointFarB = this.corners.get((n + 2) % 4);
            n = n3;
        }
    }

    private final void onImageSizeUpdated() {
        if (object.getDrawable() != null) {
            float f2;
            EditPolygonImageView editPolygonImageView = object;
            editPolygonImageView.offsetX = 0.0f;
            editPolygonImageView.offsetY = 0.0f;
            editPolygonImageView.getImageMatrix().getValues(object.imageMatrix);
            Drawable drawable = editPolygonImageView.getDrawable();
            Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"d");
            int n = drawable.getIntrinsicWidth();
            int n2 = drawable.getIntrinsicHeight();
            float f3 = n;
            EditPolygonImageView editPolygonImageView2 = object;
            float f4 = f3 * object.getScaleX();
            float f5 = n2;
            float f6 = f5 * object.getScaleY();
            RectF rectF = new RectF(0.0f, 0.0f, f4, f6);
            editPolygonImageView2.scalePortrait = ViewUtils.fitRectToView((View)editPolygonImageView2, 0.0f, rectF) * object.getScaleX();
            editPolygonImageView2.scaleLandscape = ViewUtils.fitRectToView((View)editPolygonImageView2, 90.0f, rectF) * object.getScaleY();
            if (f2 * editPolygonImageView2.scalePortrait < (float)object.getWidth()) {
                object.offsetX = object.getWidth() - (int)(f3 * object.scalePortrait) >> 1;
            }
            if (f5 * object.scalePortrait < (float)object.getHeight()) {
                object.offsetY = object.getHeight() - (int)(f5 * object.scalePortrait) >> 1;
            }
            EditPolygonImageView editPolygonImageView3 = object;
            editPolygonImageView3.polygonHelper.setImageSize((int)Math.ceil((double)n * (double)object.scalePortrait), (int)Math.ceil((double)n2 * (double)object.scalePortrait));
            editPolygonImageView3.scaleLandscape /= object.scalePortrait;
            editPolygonImageView3.scalePortrait = 1.0f;
            if (editPolygonImageView3.getRotation() / (float)90 % (float)2 == 1.0f) {
                EditPolygonImageView editPolygonImageView4 = object;
                editPolygonImageView4.setScaleX(editPolygonImageView4.scaleLandscape);
                editPolygonImageView4.setScaleY(editPolygonImageView4.scaleLandscape);
            }
            if (!object._polygon.isEmpty()) {
                EditPolygonImageView editPolygonImageView5 = object;
                Object object = editPolygonImageView5._polygon;
                object.polygonHelper.getDrawingPolygon((List)object, editPolygonImageView5.corners);
            }
        }
    }

    public EditPolygonImageView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        int n;
        Paint paint;
        Paint paint2;
        Comparator<PointF> comparator;
        EditPolygonImageView editPolygonImageView = this;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet);
        editPolygonImageView.rotationScale = 1.0f;
        editPolygonImageView.isPointsDraggable = true;
        editPolygonImageView.horizontalLines2D = new ArrayList<Line2D>();
        editPolygonImageView.verticalLines2D = new ArrayList<Line2D>();
        editPolygonImageView.horizontalLines = new ArrayList<PolygonHelper.Line>();
        editPolygonImageView.verticalLines = new ArrayList<PolygonHelper.Line>();
        editPolygonImageView.finger = new PointF();
        editPolygonImageView.tmpPointA = new PointF();
        editPolygonImageView.tmpPointB = new PointF();
        Comparator<PointF> comparator2 = comparator;
        comparator = new Comparator<PointF>(){

            public final int a(PointF pointF, PointF pointF2) {
                return Double.compare(Math.atan2((double)pointF.y - (double)medianY, (double)pointF.x - (double)medianX), Math.atan2((double)pointF2.y - (double)medianY, (double)pointF2.x - (double)medianX));
            }
        };
        editPolygonImageView.pointsQueue = new PriorityQueue<PointF>(4, comparator2);
        editPolygonImageView.imageMatrix = new float[9];
        editPolygonImageView.touchRect = new RectF();
        editPolygonImageView.lastKnownImageWidth = -1;
        editPolygonImageView.lastKnownImageHeight = -1;
        editPolygonImageView.scaleLandscape = 1.0f;
        editPolygonImageView.scalePortrait = 1.0f;
        if (!editPolygonImageView.isInEditMode() && !ScanbotSDKInitializer.Companion.isInitialized()) {
            throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.".toString());
        }
        EditPolygonImageView editPolygonImageView2 = this;
        context = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.EditPolygonImageView, 0, 0);
        EditPolygonImageView editPolygonImageView3 = this;
        Context context3 = context;
        EditPolygonImageView editPolygonImageView4 = this;
        Context context4 = context;
        EditPolygonImageView editPolygonImageView5 = this;
        Context context5 = context;
        EditPolygonImageView editPolygonImageView6 = this;
        Context context6 = context;
        EditPolygonImageView editPolygonImageView7 = this;
        Context context7 = context;
        EditPolygonImageView editPolygonImageView8 = this;
        Context context8 = context;
        EditPolygonImageView editPolygonImageView9 = this;
        int n2 = context.getColor(R.styleable.EditPolygonImageView_edgeColor, 0);
        try {
            editPolygonImageView9.edgeColor = n2;
            editPolygonImageView8.edgeColorOnLine = context8.getColor(R.styleable.EditPolygonImageView_edgeColorOnLine, n2);
            editPolygonImageView7.cornerDrawable = context7.getDrawable(R.styleable.EditPolygonImageView_cornerImageSrc);
            editPolygonImageView6.edgeDrawable = context6.getDrawable(R.styleable.EditPolygonImageView_edgeImageSrc);
            editPolygonImageView5.magneticLineTreshold = context5.getDimension(R.styleable.EditPolygonImageView_magneticLineTreshold, this.getResources().getDimension(R.dimen.magnetic_line_treshold));
            editPolygonImageView4.polygonStrokeWidth = context4.getDimension(R.styleable.EditPolygonImageView_editPolygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
            editPolygonImageView3.handleSize = context3.getDimensionPixelSize(R.styleable.EditPolygonImageView_editPolygonHandleSize, this.getResources().getDimensionPixelSize(R.dimen.edit_polygon_handle_size));
        }
        catch (Throwable throwable) {
            context.recycle();
            throw throwable;
        }
        context.recycle();
        editPolygonImageView2._polygon = CollectionsKt.emptyList();
        Context context9 = context = paint2;
        Context context10 = context;
        super();
        this.paint = context10;
        context9.setColor(this.edgeColor);
        context9.setStyle(Paint.Style.STROKE);
        paint2.setStrokeWidth(this.polygonStrokeWidth);
        paint2.setAntiAlias(true);
        paint2.setStrokeCap(Paint.Cap.SQUARE);
        Context context11 = context = paint;
        Context context12 = context;
        super();
        this.paintOnLine = context12;
        context11.setColor(this.edgeColorOnLine);
        context11.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(this.polygonStrokeWidth);
        paint.setAntiAlias(true);
        paint.setStrokeCap(Paint.Cap.SQUARE);
        this.handlePaint = new Paint();
        this.handlePaint.setAntiAlias(true);
        this.handlePaint.setFilterBitmap(true);
        editPolygonImageView2.polygonHelper = new io.scanbot.sdk.util.view.PolygonHelper();
        editPolygonImageView2.corners = new ArrayList<PointF>();
        n2 = 4;
        for (n = 0; n < n2; ++n) {
            this.corners.add(new PointF());
        }
        this.edges = new ArrayList<PolygonHelper.Edge>();
        n = 0;
        n2 = this.corners.size();
        while (n < n2) {
            Comparator<PointF> comparator3;
            comparator2 = comparator3;
            comparator2();
            ((PolygonHelper.Edge)comparator2).pointA = this.corners.get(n);
            int n3 = n + 1;
            ((PolygonHelper.Edge)comparator2).pointB = this.corners.get(n3 % 4);
            ((PolygonHelper.Edge)comparator2).pointFarA = this.corners.get((n + 3) % 4);
            ((PolygonHelper.Edge)comparator3).pointFarB = this.corners.get((n + 2) % 4);
            this.edges.add((PolygonHelper.Edge)comparator2);
            n = n3;
        }
        return;
    }

    public static final /* synthetic */ List access$get_polygon$p(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView._polygon;
    }

    public static final /* synthetic */ MagnifierView access$getMagnifierView$p(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView.magnifierView;
    }

    public static final /* synthetic */ void access$setMagnifierView$p(EditPolygonImageView editPolygonImageView, MagnifierView magnifierView) {
        editPolygonImageView.magnifierView = magnifierView;
    }

    public static final /* synthetic */ EditPolygonAnimationEndListener access$getEditPolygonAnimationEndListener$p(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView.editPolygonAnimationEndListener;
    }

    public static final /* synthetic */ void access$setEditPolygonAnimationEndListener$p(EditPolygonImageView editPolygonImageView, EditPolygonAnimationEndListener editPolygonAnimationEndListener) {
        editPolygonImageView.editPolygonAnimationEndListener = editPolygonAnimationEndListener;
    }

    public static final /* synthetic */ void access$setMedianY$p(EditPolygonImageView editPolygonImageView, float f2) {
        editPolygonImageView.medianY = f2;
    }

    public static final /* synthetic */ void access$setMedianX$p(EditPolygonImageView editPolygonImageView, float f2) {
        editPolygonImageView.medianX = f2;
    }

    @NotNull
    public static final List<PointF> getDefaultPolygon() {
        return Companion.getDefaultPolygon();
    }

    public final boolean isPointsDraggable() {
        return this.isPointsDraggable;
    }

    public final void setPointsDraggable(boolean bl) {
        this.isPointsDraggable = bl;
    }

    @NotNull
    public final List<PointF> getPolygon() {
        if (this.corners.isEmpty() ^ true && this._polygon.isEmpty() ^ true) {
            EditPolygonImageView editPolygonImageView = this;
            List<PointF> list = editPolygonImageView.corners;
            this.polygonHelper.getPolygonFromDrawingPolygon(list, editPolygonImageView._polygon);
        }
        return this._polygon;
    }

    public final void setPolygon(final @NotNull List<? extends PointF> list) {
        Runnable runnable;
        Intrinsics.checkNotNullParameter(list, (String)"newPolygon");
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public final void run() {
                if (list.isEmpty() ^ true) {
                    b b2 = this;
                    _polygon = list;
                    if (corners.isEmpty() ^ true) {
                        polygonHelper.getDrawingPolygon(list, corners);
                    }
                    b b3 = this;
                    b3.this.checkPolygonSelection();
                    b3.this.invalidate();
                }
            }
        };
        this.post(runnable2);
    }

    public final boolean getFullPolygonSelected() {
        return this.fullPolygonSelected;
    }

    public final void setFullPolygonSelected(boolean bl) {
        this.fullPolygonSelected = bl;
    }

    protected void onAttachedToWindow() {
        EditPolygonImageView editPolygonImageView = this;
        super.onAttachedToWindow();
        Drawable drawable = editPolygonImageView.cornerDrawable;
        if (drawable != null) {
            this.cornerBitmap = BitmapUtils.drawableToBitmap((Drawable)drawable);
        }
        if ((drawable = this.edgeDrawable) != null) {
            this.edgeBitmap = BitmapUtils.drawableToBitmap((Drawable)drawable);
        }
    }

    protected void onDetachedFromWindow() {
        EditPolygonImageView editPolygonImageView = this;
        super.onDetachedFromWindow();
        Bitmap bitmap = editPolygonImageView.cornerBitmap;
        if (bitmap != null) {
            bitmap.recycle();
        }
        if ((bitmap = this.edgeBitmap) != null) {
            bitmap.recycle();
        }
        EditPolygonImageView editPolygonImageView2 = this;
        editPolygonImageView2.editPolygonAnimationEndListener = null;
        editPolygonImageView2.editPolygonDragListener = null;
    }

    protected void onMeasure(int n, int n2) {
        EditPolygonImageView editPolygonImageView = this;
        super.onMeasure(n, n2);
        editPolygonImageView.onImageSizeUpdated();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
    }

    public void setRotation(float f2) {
        if (f2 % (float)90 != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        float f3 = editPolygonImageView.getRotation() - f2;
        f3 = editPolygonImageView.getRotationScale(editPolygonImageView.getRotation(), f3);
        MagnifierView magnifierView = editPolygonImageView.magnifierView;
        if (magnifierView != null) {
            magnifierView.setImageRotation(f2);
        }
        EditPolygonImageView editPolygonImageView2 = this;
        editPolygonImageView2.setScaleX(f3);
        editPolygonImageView2.setScaleY(f3);
        editPolygonImageView2.invalidate();
        super.setRotation(f2);
    }

    public final void setLines(final @NotNull List<Line2D> list, final @NotNull List<Line2D> list2) {
        Runnable runnable;
        Intrinsics.checkNotNullParameter(list, (String)"horizontalLines");
        Intrinsics.checkNotNullParameter(list2, (String)"verticalLines");
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public final void run() {
                ArrayList arrayList;
                Object object;
                PointF pointF;
                ArrayList<Line2D> arrayList2;
                Iterator<Line2D> iterator = arrayList2;
                arrayList2 = new ArrayList<Line2D>(list.size());
                for (Line2D line2D : list) {
                    PointF pointF2;
                    pointF = line2D.component1();
                    PointF pointF3 = line2D.component2();
                    PointF pointF4 = pointF;
                    float f2 = pointF4.x;
                    pointF = pointF2;
                    PointF pointF5 = pointF3;
                    float f3 = pointF5.x;
                    pointF2 = new PointF(f3, pointF5.y);
                    iterator.add(new Line2D(new PointF(f2, pointF4.y), pointF));
                }
                c c2 = this;
                horizontalLines2D.clear();
                List list5 = horizontalLines2D;
                List list22 = polygonHelper.scaleLines(iterator);
                Intrinsics.checkNotNullExpressionValue((Object)list22, (String)"polygonHelper.scaleLines(copyHorizontalLines)");
                list5.addAll(list22);
                horizontalLines.clear();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    PolygonHelper.Line line;
                    Line2D line2D = (Line2D)iterator.next();
                    object = line2D.component1();
                    pointF = line2D.component2();
                    PolygonHelper.Line line2 = line;
                    line2();
                    line.calculateLine((PointF)object, pointF);
                    horizontalLines.add(line2);
                }
                iterator = arrayList;
                arrayList = new ArrayList(list2.size());
                for (Line2D line2D : list2) {
                    PointF pointF6;
                    pointF = line2D.component1();
                    PointF pointF7 = line2D.component2();
                    PointF pointF8 = pointF;
                    float f4 = pointF8.x;
                    pointF = pointF6;
                    PointF pointF9 = pointF7;
                    float f5 = pointF9.x;
                    pointF6 = new PointF(f5, pointF9.y);
                    iterator.add(new Line2D(new PointF(f4, pointF8.y), pointF));
                }
                c c3 = this;
                verticalLines2D.clear();
                List list3 = verticalLines2D;
                List list4 = polygonHelper.scaleLines((List)((Object)iterator));
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"polygonHelper.scaleLines(copyVerticalLines)");
                list3.addAll(list4);
                verticalLines.clear();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    PolygonHelper.Line line;
                    Line2D line2D = (Line2D)iterator.next();
                    object = line2D.component1();
                    pointF = line2D.component2();
                    PolygonHelper.Line line3 = line;
                    line3();
                    line.calculateLine((PointF)object, pointF);
                    verticalLines.add(line3);
                }
            }
        };
        this.post(runnable2);
    }

    public final void setEdgeColor(int n) {
        this.paint.setColor(n);
    }

    public final void setEdgeColorOnLine(int n) {
        this.paintOnLine.setColor(n);
    }

    public final void setEdgeWidth(float f2) {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.polygonStrokeWidth = f2;
        editPolygonImageView.paint.setStrokeWidth(f2);
        editPolygonImageView.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
    }

    public final void rotateClockwise() {
        float f2 = this.getRotation();
        if (f2 % (float)90 != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        f2 = editPolygonImageView.getRotationScale(f2, 90.0f);
        editPolygonImageView.animate().rotationBy(90.0f).scaleX(f2).scaleY(f2).setListener(new Animator.AnimatorListener(this){
            final /* synthetic */ EditPolygonImageView this$0;
            {
                this.this$0 = editPolygonImageView;
            }

            public void onAnimationStart(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animation");
            }

            public void onAnimationEnd(@NotNull Animator object) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"animation");
                object = EditPolygonImageView.access$getMagnifierView$p(this.this$0);
                if (object != null) {
                    ((MagnifierView)((Object)object)).setImageRotation(this.this$0.getRotation());
                }
                if ((object = EditPolygonImageView.access$getEditPolygonAnimationEndListener$p(this.this$0)) != null) {
                    object.onAnimationEnded();
                }
                this.this$0.invalidate();
            }

            public void onAnimationCancel(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animation");
            }

            public void onAnimationRepeat(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animation");
            }
        }).start();
    }

    public final void rotateCounterClockwise() {
        float f2 = this.getRotation();
        if (f2 % (float)90 != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        f2 = editPolygonImageView.getRotationScale(f2, -90.0f);
        editPolygonImageView.animate().rotationBy(-90.0f).scaleX(f2).scaleY(f2).setListener(new Animator.AnimatorListener(this){
            final /* synthetic */ EditPolygonImageView this$0;
            {
                this.this$0 = editPolygonImageView;
            }

            public void onAnimationStart(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animation");
            }

            public void onAnimationEnd(@NotNull Animator object) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"animation");
                object = EditPolygonImageView.access$getMagnifierView$p(this.this$0);
                if (object != null) {
                    ((MagnifierView)((Object)object)).setImageRotation(this.this$0.getRotation());
                }
                if ((object = EditPolygonImageView.access$getEditPolygonAnimationEndListener$p(this.this$0)) != null) {
                    object.onAnimationEnded();
                }
                this.this$0.invalidate();
            }

            public void onAnimationCancel(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animation");
            }

            public void onAnimationRepeat(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animation");
            }
        }).start();
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        EditPolygonImageView editPolygonImageView = editPolygonImageView5;
        Canvas canvas2 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas2, (String)"canvas");
        super.dispatchDraw(canvas2);
        editPolygonImageView.checkWhetherImageSizeUpdated();
        if (editPolygonImageView._polygon.isEmpty() ^ true) {
            float f2;
            float f3;
            float f4;
            EditPolygonImageView editPolygonImageView2 = editPolygonImageView5;
            canvas.save();
            float f5 = editPolygonImageView2.offsetX;
            canvas.translate(f5, editPolygonImageView2.offsetY);
            for (PolygonHelper.Edge edge : editPolygonImageView5.edges) {
                PointF pointF = edge.pointA;
                f4 = pointF.x;
                f3 = pointF.y;
                PointF pointF2 = edge.pointB;
                f2 = pointF2.x;
                float f6 = pointF2.y;
                Paint paint = edge.isDetectedLine ? editPolygonImageView5.paintOnLine : editPolygonImageView5.paint;
                canvas.drawLine(f4, f3, f2, f6, paint);
            }
            Object object = editPolygonImageView5.selectedCorner;
            if (object != null) {
                Intrinsics.checkNotNull((Object)object);
                editPolygonImageView5.drawHandle(canvas, (PointF)object, editPolygonImageView5.cornerBitmap, 0.0f);
                canvas.save();
                canvas.translate(-editPolygonImageView5.offsetX, -editPolygonImageView5.offsetY);
                if (editPolygonImageView5.magnifierView != null) {
                    PointF pointF;
                    object = pointF;
                    EditPolygonImageView editPolygonImageView3 = editPolygonImageView5;
                    PointF pointF3 = editPolygonImageView3.selectedCorner;
                    Intrinsics.checkNotNull((Object)pointF3);
                    f4 = 2;
                    f3 = pointF3.x / ((float)editPolygonImageView5.getWidth() - f4 * editPolygonImageView5.offsetX);
                    PointF pointF4 = editPolygonImageView3.selectedCorner;
                    Intrinsics.checkNotNull((Object)pointF4);
                    pointF = new PointF(f3, pointF4.y / ((float)editPolygonImageView5.getHeight() - f4 * editPolygonImageView5.offsetY));
                    MagnifierView magnifierView = editPolygonImageView5.magnifierView;
                    Intrinsics.checkNotNull((Object)((Object)magnifierView));
                    magnifierView.drawMagnifier((PointF)object);
                }
                canvas.restore();
            } else {
                object = editPolygonImageView5.selectedEdge;
                if (object != null) {
                    EditPolygonImageView editPolygonImageView4 = editPolygonImageView5;
                    PointF pointF = object;
                    Intrinsics.checkNotNull((Object)pointF);
                    EditPolygonImageView editPolygonImageView5 = pointF.getHandle();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)editPolygonImageView5), (String)"selectedEdge!!.handle");
                    object = editPolygonImageView4.edgeBitmap;
                    PolygonHelper.Edge edge = editPolygonImageView4.selectedEdge;
                    Intrinsics.checkNotNull((Object)edge);
                    f4 = edge.getAngleInDegrees();
                    editPolygonImageView4.drawHandle(canvas, (PointF)editPolygonImageView5, (Bitmap)object, f4);
                } else {
                    for (PolygonHelper.Edge edge : editPolygonImageView5.edges) {
                        PointF pointF = edge.getHandle();
                        Intrinsics.checkNotNullExpressionValue((Object)pointF, (String)"edge.handle");
                        Bitmap bitmap = editPolygonImageView5.edgeBitmap;
                        f2 = edge.getAngleInDegrees();
                        editPolygonImageView5.drawHandle(canvas, pointF, bitmap, f2);
                    }
                    for (PointF pointF : editPolygonImageView5.corners) {
                        editPolygonImageView5.drawHandle(canvas, pointF, editPolygonImageView5.cornerBitmap, 0.0f);
                    }
                }
            }
            canvas.restore();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean onTouchEvent(@NotNull MotionEvent var1_1) {
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"event");
        if (!this.isPointsDraggable) {
            return true;
        }
        switch (var1_1.getAction()) {
            default: {
                return super.onTouchEvent((MotionEvent)var1_1);
            }
            case 2: {
                var2_2 = this.selectedCorner;
                if (var2_2 == null) ** GOTO lbl19
                v0 = this;
                Intrinsics.checkNotNull((Object)var2_2);
                var2_2.set(var1_1.getX() - this.offsetX, var1_1.getY() - this.offsetY);
                v1 = v0.selectedCorner;
                Intrinsics.checkNotNull((Object)v1);
                v0.keepInsideView(v1);
                v0.ensureNoPolygonIntersection();
                v0.invalidate();
                ** GOTO lbl140
lbl19:
                // 1 sources

                if (this.selectedEdge == null) ** GOTO lbl140
                v2 = this;
                v3 = var1_1;
                v4 = v3.getX();
                v5 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v5);
                var2_3 = v4 - v5.prevX;
                v6 = v3.getY();
                v7 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v7);
                var3_11 = v6 - v7.prevY;
                v2.finger.offset(var2_3, var3_11);
                v8 = v2.tmpPointA;
                v9 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v9);
                v8.set(v9.pointA);
                v10 = v2.tmpPointB;
                v11 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v11);
                v10.set(v11.pointB);
                var2_4 = 1.7976931348623157E308;
                var4_15 = null;
                v12 = v2.selectedEdge;
                Intrinsics.checkNotNull((Object)v12);
                if (v12.isHorizontal()) {
                    for (var5_18 = 0; var5_18 < this.horizontalLines.size(); ++var5_18) {
                        var6_21 = this.horizontalLines.get(var5_18).getDistanceToPoint(this.finger);
                        if (v13 < var2_4) {
                            var4_15 = this.horizontalLines2D.get(var5_18);
                        } else {
                            var6_21 = var2_4;
                        }
                        var2_4 = var6_21;
                    }
                } else {
                    for (var5_19 = 0; var5_19 < this.verticalLines.size(); ++var5_19) {
                        var6_22 = this.verticalLines.get(var5_19).getDistanceToPoint(this.finger);
                        if (v14 < var2_4) {
                            var4_15 = this.verticalLines2D.get(var5_19);
                        } else {
                            var6_22 = var2_4;
                        }
                        var2_4 = var6_22;
                    }
                }
                if (var4_15 != null && var2_4 < (double)this.magneticLineTreshold) {
                    v15 = this;
                    v16 = v15.selectedEdge;
                    Intrinsics.checkNotNull((Object)v16);
                    v16.pointA.set(var4_15.start);
                    v17 = v15.selectedEdge;
                    Intrinsics.checkNotNull((Object)v17);
                    v17.pointB.set(var4_15.end);
                    Intrinsics.checkNotNull((Object)v15.selectedEdge);
                    v15.selectedEdge.isDetectedLine = true;
                } else {
                    v18 = this;
                    Intrinsics.checkNotNull((Object)v18.selectedEdge);
                    v18.selectedEdge.isDetectedLine = false;
                    v19 = v18.selectedEdge;
                    Intrinsics.checkNotNull((Object)v19);
                    var2_5 = v19.getHandle();
                    v20 = v18.finger;
                    var3_11 = v20.x - var2_5.x;
                    var2_6 = v20.y - var2_5.y;
                    v21 = v18.selectedEdge;
                    Intrinsics.checkNotNull((Object)v21);
                    v21.pointA.offset(var3_11, var2_6);
                    v22 = v18.selectedEdge;
                    Intrinsics.checkNotNull((Object)v22);
                    v22.pointB.offset(var3_11, var2_6);
                }
                v23 = this;
                v24 = v23.selectedEdge;
                Intrinsics.checkNotNull((Object)v24);
                v25 = v24.edgeLine;
                v26 = this;
                v27 = v26.selectedEdge;
                Intrinsics.checkNotNull((Object)v27);
                var2_7 = v27.pointA;
                v28 = v26.selectedEdge;
                Intrinsics.checkNotNull((Object)v28);
                v25.calculateLine(var2_7, v28.pointB);
                v29 = v23.selectedEdge;
                Intrinsics.checkNotNull((Object)v29);
                v30 = v29.edgeLine;
                v31 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v31);
                var2_7 = v30.getIntersectionPoint(v31.lineA);
                if (Float.isNaN(var2_7.x) || Float.isNaN(var2_7.y)) ** GOTO lbl138
                v32 = this;
                v33 = v32.selectedEdge;
                Intrinsics.checkNotNull((Object)v33);
                v33.pointA.set(var2_7);
                v34 = v32.selectedEdge;
                Intrinsics.checkNotNull((Object)v34);
                v35 = v34.edgeLine;
                v36 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v36);
                var2_7 = v35.getIntersectionPoint(v36.lineB);
                if (!Float.isNaN(var2_7.x) && !Float.isNaN(var2_7.y)) {
                    v37 = this;
                    v38 = v37.selectedEdge;
                    Intrinsics.checkNotNull((Object)v38);
                    v38.pointB.set(var2_7);
                    v39 = v37.selectedEdge;
                    Intrinsics.checkNotNull((Object)v39);
                    v40 = v39.pointA;
                    Intrinsics.checkNotNullExpressionValue((Object)v40, (String)"selectedEdge!!.pointA");
                    v37.keepInsideView(v40);
                    v41 = v37.selectedEdge;
                    Intrinsics.checkNotNull((Object)v41);
                    v42 = v41.pointB;
                    Intrinsics.checkNotNullExpressionValue((Object)v42, (String)"selectedEdge!!.pointB");
                    v37.keepInsideView(v42);
                    Intrinsics.checkNotNull((Object)v37.selectedEdge);
                    v37.selectedEdge.prevX = var1_1.getX();
                    Intrinsics.checkNotNull((Object)v37.selectedEdge);
                    v37.selectedEdge.prevY = var1_1.getY();
                    v37.invalidate();
                } else {
                    this.restoreSelectedEdge();
                    return false;
lbl138:
                    // 1 sources

                    this.restoreSelectedEdge();
                    return false;
                }
lbl140:
                // 3 sources

                this.checkPolygonSelection();
                return true;
            }
            case 1: 
            case 3: {
                this.selectedCorner = null;
                this.selectedEdge = null;
                var1_1 = this.magnifierView;
                if (var1_1 != null) {
                    v43 = var1_1;
                    Intrinsics.checkNotNull((Object)v43);
                    v43.eraseMagnifier();
                }
                this.invalidate();
                return true;
            }
            case 0: 
        }
        v44 = this;
        var2_8 = v44.handleSize >> 1;
        v45 = var2_8;
        var2_9 = v45;
        v46 = var1_1;
        var3_12 = v46.getY() - this.offsetY - var2_9;
        var4_16 = v46.getX() - this.offsetX + var2_9;
        var2_9 = v46.getY() - this.offsetY + var2_9;
        v44.touchRect.set(var1_1.getX() - this.offsetX - v45, var3_12, var4_16, var2_9);
        var2_10 = v44.corners.iterator();
        while (var2_10.hasNext()) {
            v47 = var3_13 = var2_10.next();
            var4_16 = v47.x;
            if (!this.touchRect.contains(var4_16, v47.y)) continue;
            this.selectedCorner = var3_13;
            this.invalidate();
            return true;
        }
        for (PolygonHelper.Edge var3_14 : this.edges) {
            v48 = var4_17 = var3_14.getHandle();
            var5_20 = v48.x;
            if (!this.touchRect.contains(var5_20, v48.y)) continue;
            v49 = this;
            v50 = this.selectedEdge = var3_14;
            var3_14.prevX = var1_1.getX();
            v50.prevY = var1_1.getY();
            v51 = var3_14;
            this = v51.pointA;
            v50.lineA.calculateLine((PointF)this, v51.pointFarA);
            v52 = var3_14;
            this = v52.pointB;
            v50.lineB.calculateLine((PointF)this, v52.pointFarB);
            v49.finger.set(var4_17);
            v49.invalidate();
            return true;
        }
        return false;
    }

    public final void setMagnifier(@Nullable MagnifierView magnifierView) {
        this.magnifierView = magnifierView;
        this.invalidate();
    }

    public final void setEditPolygonAnimationEndListener(@Nullable EditPolygonAnimationEndListener editPolygonAnimationEndListener) {
        this.editPolygonAnimationEndListener = editPolygonAnimationEndListener;
    }

    public final void setEditPolygonDragListener(@Nullable EditPolygonDragListener editPolygonDragListener) {
        this.editPolygonDragListener = editPolygonDragListener;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u000f\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/ui/EditPolygonImageView$EditPolygonAnimationEndListener;", "", "", "onAnimationEnded", "()V", "sdk-bundle_release"})
    public static interface EditPolygonAnimationEndListener {
        public void onAnimationEnded();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/EditPolygonImageView$EditPolygonDragListener;", "", "", "isFullPolygonSelected", "", "onPolygonSelectedStateChanged", "(Z)V", "sdk-bundle_release"})
    public static interface EditPolygonDragListener {
        public void onPolygonSelectedStateChanged(boolean var1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\f\u0010\u0007R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028F@\u0007X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005R\u0016\u0010\n\u001a\u00020\t8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lio/scanbot/sdk/ui/EditPolygonImageView$Companion;", "", "", "Landroid/graphics/PointF;", "getDefaultPolygon", "()Ljava/util/List;", "getDefaultPolygon$annotations", "()V", "defaultPolygon", "", "CORNERS_COUNT", "I", "<init>", "sdk-bundle_release"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getDefaultPolygon$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @NotNull
        public final List<PointF> getDefaultPolygon() {
            return new ArrayList<PointF>(){
                {
                    PointF pointF;
                    PointF pointF2;
                    PointF pointF3;
                    PointF pointF4;
                    defaultPolygon.1 v0 = this_;
                    defaultPolygon.1 this_ = pointF4;
                    pointF4 = new PointF(0.0f, 0.0f);
                    v0.add(this_);
                    this_ = pointF3;
                    pointF3 = new PointF(1.0f, 0.0f);
                    v0.add(this_);
                    this_ = pointF2;
                    pointF2 = new PointF(1.0f, 1.0f);
                    v0.add(this_);
                    this_ = pointF;
                    pointF = new PointF(0.0f, 1.0f);
                    v0.add(this_);
                }
            };
        }
    }
}

