/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.barcodescanner.model;

import android.graphics.Bitmap;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.adapters.PolymorphicJsonAdapterFactory;
import io.scanbot.barcodescanner.model.BarCodeScannerDocumentFormat;
import io.scanbot.barcodescanner.model.BarCodeType;
import io.scanbot.barcodescanner.model.DEMedicalPlan.DEMedicalPlanDocument;
import io.scanbot.barcodescanner.model.DisabilityCertificate.DisabilityCertificateDocument;
import io.scanbot.barcodescanner.model.IDCardPDF417.IDCardPDF417Document;
import io.scanbot.barcodescanner.model.SEPA.SEPADocument;
import io.scanbot.barcodescanner.model.VCard.VCardDocument;
import io.scanbot.barcodescanner.model.aamva.AAMVADocument;
import io.scanbot.barcodescanner.model.boardingPass.BoardingPassDocument;
import java.io.IOException;

public class BarCodeItem {
    public final String rawString;
    public final BarCodeType type;
    public final BarCodeScannerDocumentFormat documentFormat;
    public final Bitmap image;

    public BarCodeItem(String decodedRawString, String jsonString, int decodedType, Bitmap image) {
        this.rawString = decodedRawString;
        this.type = this.typeFromInt(decodedType);
        this.documentFormat = this.barCodeDocumentFromJSON(jsonString);
        this.image = image;
    }

    private BarCodeScannerDocumentFormat barCodeDocumentFromJSON(String jsonString) {
        if (jsonString.equals("")) {
            return null;
        }
        JsonAdapter documentFormatAdapter = new Moshi.Builder().add((JsonAdapter.Factory)PolymorphicJsonAdapterFactory.of(BarCodeScannerDocumentFormat.class, (String)"documentFormat").withSubtype(AAMVADocument.class, "AAMVA").withSubtype(BoardingPassDocument.class, "BoardingPass").withSubtype(DEMedicalPlanDocument.class, "DEMedicalPlan").withSubtype(DisabilityCertificateDocument.class, "DisabilityCertificate").withSubtype(IDCardPDF417Document.class, "IDCardPDF417").withSubtype(SEPADocument.class, "SEPA").withSubtype(VCardDocument.class, "VCard")).build().adapter(BarCodeScannerDocumentFormat.class);
        try {
            return (BarCodeScannerDocumentFormat)documentFormatAdapter.fromJson(jsonString);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private BarCodeType typeFromInt(int value) {
        switch (value) {
            case 0: {
                return BarCodeType.AZTEC;
            }
            case 1: {
                return BarCodeType.CODABAR;
            }
            case 2: {
                return BarCodeType.CODE_39;
            }
            case 3: {
                return BarCodeType.CODE_93;
            }
            case 4: {
                return BarCodeType.CODE_128;
            }
            case 5: {
                return BarCodeType.DATA_MATRIX;
            }
            case 6: {
                return BarCodeType.EAN_8;
            }
            case 7: {
                return BarCodeType.EAN_13;
            }
            case 8: {
                return BarCodeType.ITF;
            }
            case 10: {
                return BarCodeType.PDF_417;
            }
            case 11: {
                return BarCodeType.QR_CODE;
            }
            case 12: {
                return BarCodeType.RSS_14;
            }
            case 13: {
                return BarCodeType.RSS_EXPANDED;
            }
            case 14: {
                return BarCodeType.UPC_A;
            }
            case 15: {
                return BarCodeType.UPC_E;
            }
            case 17: {
                return BarCodeType.UNKNOWN;
            }
        }
        return BarCodeType.UNKNOWN;
    }
}

