/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.detector;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import androidx.annotation.RestrictTo;
import com.github.rjeschke.neetutils.dispose.Disposable;
import com.github.rjeschke.neetutils.dispose.Disposer;
import java.io.IOException;
import java.util.List;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.detector.Line2D;
import net.doo.snap.lib.detector.PageAspectRatio;
import org.jetbrains.annotations.Nullable;

public class ContourDetector
implements Disposable {
    private final Disposer disposer;
    private final long pointer;
    private static final int[] COLOR_CLAMP_RED = new int[768];
    private static final int[] COLOR_CLAMP_GREEN = new int[768];
    private static final int[] COLOR_CLAMP_BLUE = new int[768];
    public static final int IMAGE_FILTER_NONE = 0;
    public static final int IMAGE_FILTER_COLOR_ENHANCED = 1;
    public static final int IMAGE_FILTER_GRAY = 2;
    public static final int IMAGE_FILTER_BINARIZED = 3;
    public static final int IMAGE_FILTER_COLOR_DOCUMENT = 4;
    public static final int IMAGE_FILTER_PURE_BINARIZED = 11;
    public static final int IMAGE_FILTER_BACKGROUND_CLEAN = 13;
    public static final int IMAGE_FILTER_BLACK_AND_WHITE = 14;
    public static final int IMAGE_FILTER_OTSU_BINARIZATION = 15;
    public static final int IMAGE_FILTER_DEEP_BINARIZATION = 16;
    public static final int IMAGE_FILTER_EDGE_HIGHLIGHT = 17;
    public static final int IMAGE_FILTER_LOW_LIGHT_BINARIZATION = 18;
    public static final int IMAGE_FILTER_LOW_LIGHT_BINARIZATION_2 = 19;

    @Deprecated
    public ContourDetector() {
        this(null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public ContourDetector(@Nullable String modelFolderPath) {
        this.pointer = ContourDetector.ctor(modelFolderPath == null ? "" : modelFolderPath);
        this.disposer = new Disposer(this, new ContourDetectorDisposer(this.pointer));
        if (this.pointer == 0L) {
            throw new IllegalStateException("Failed to create native resources.");
        }
    }

    public final DetectionResult detect(byte[] nv21, int width, int height) {
        return ContourDetector.detectNV21(this.pointer, nv21, width, height);
    }

    public final DetectionResult detect(byte[] data) {
        Bitmap bitmap = ContourDetector.createBitmapFromEncodedData(data);
        DetectionResult ret = ContourDetector.detect(this.pointer, bitmap);
        bitmap.recycle();
        return ret;
    }

    public final DetectionResult detect(String fileName) throws IOException {
        Bitmap bitmap = ContourDetector.createBitmapFromEncodedFile(fileName);
        DetectionResult ret = ContourDetector.detect(this.pointer, bitmap);
        bitmap.recycle();
        return ret;
    }

    public final DetectionResult detect(Bitmap bitmap) {
        return ContourDetector.detect(this.pointer, bitmap);
    }

    public final Bitmap processImage(byte[] nv21, int width, int height, List<Point> polygon, int imageFilter) {
        Bitmap bitmap = ContourDetector.createBitmapFromNV21(nv21, width, height);
        Bitmap ret = ContourDetector.processImage(this.pointer, bitmap, polygon, imageFilter);
        bitmap.recycle();
        return ret;
    }

    public final Bitmap processImage(byte[] data, List<Point> polygon, int imageFilter) {
        Bitmap bitmap = ContourDetector.createBitmapFromEncodedData(data);
        Bitmap ret = ContourDetector.processImage(this.pointer, bitmap, polygon, imageFilter);
        bitmap.recycle();
        return ret;
    }

    public final Bitmap processImage(Bitmap bitmap, List<Point> polygon, int imageFilter) {
        return ContourDetector.processImage(this.pointer, bitmap, polygon, imageFilter);
    }

    public Bitmap processImageF(String fileName, List<PointF> polygon, int imageFilter) throws IOException {
        Bitmap bitmap = ContourDetector.createBitmapFromEncodedFile(fileName);
        Bitmap ret = ContourDetector.processImageF(this.pointer, bitmap, polygon, imageFilter);
        bitmap.recycle();
        return ret;
    }

    public final Bitmap processImageF(byte[] nv21, int width, int height, List<PointF> polygon, int imageFilter) {
        Bitmap bitmap = ContourDetector.createBitmapFromNV21(nv21, width, height);
        Bitmap ret = ContourDetector.processImageF(this.pointer, bitmap, polygon, imageFilter);
        bitmap.recycle();
        return ret;
    }

    public final Bitmap processImageF(byte[] data, List<PointF> polygon, int imageFilter) {
        Bitmap bitmap = ContourDetector.createBitmapFromEncodedData(data);
        Bitmap ret = ContourDetector.processImageF(this.pointer, bitmap, polygon, imageFilter);
        bitmap.recycle();
        return ret;
    }

    public final Bitmap processImageF(Bitmap bitmap, List<PointF> polygon, int imageFilter) {
        return ContourDetector.processImageF(this.pointer, bitmap, polygon, imageFilter);
    }

    public final Bitmap processImageAndScale(byte[] encodedImage, List<PointF> polygon, int imageFilter, int biggestSide) {
        return ContourDetector.processImageAndScale(this.pointer, encodedImage, polygon, imageFilter, biggestSide);
    }

    public final Bitmap processImageAndRelease(Bitmap bitmap, List<PointF> polygon, int imageFilter) {
        return ContourDetector.processImageAndRelease(this.pointer, bitmap, polygon, imageFilter);
    }

    public final List<Point> getPolygon() {
        return ContourDetector.getPolygon(this.pointer);
    }

    public final List<PointF> getPolygonF() {
        return ContourDetector.getPolygonF(this.pointer);
    }

    public final double getDetectionScore() {
        return ContourDetector.getDetectionScore(this.pointer);
    }

    public final List<Line2D> getVerticalLines() {
        return ContourDetector.getVerticalLines(this.pointer);
    }

    public final List<Line2D> getHorizontalLines() {
        return ContourDetector.getHorizontalLines(this.pointer);
    }

    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        ContourDetector.setAcceptedAngleScore(this.pointer, acceptedAngleScore);
    }

    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        ContourDetector.setAcceptedSizeScore(this.pointer, acceptedSizeScore);
    }

    public final void setRequiredAspectRatios(List<PageAspectRatio> requiredPageAspectRatios) {
        ContourDetector.setRequiredAspectRatios(this.pointer, requiredPageAspectRatios);
    }

    public final void setRectOfInterest(RectF rectOfInterest) {
        ContourDetector.setRectOfInterest(this.pointer, rectOfInterest.left, rectOfInterest.top, rectOfInterest.width(), rectOfInterest.height());
    }

    public final void resetPolygonHistory() {
        ContourDetector.resetPolygonHistory(this.pointer);
    }

    @Override
    public void dispose() {
        this.disposer.dispose();
    }

    public static final Bitmap createBitmapFromEncodedData(byte[] data) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inDither = false;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        return BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
    }

    public static final Bitmap createBitmapFromEncodedFile(String fileName) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inDither = false;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = BitmapFactory.decodeFile((String)fileName, (BitmapFactory.Options)options);
        if (bitmap == null) {
            throw new IOException("Can't open Bitmap");
        }
        return bitmap;
    }

    public static final Bitmap createBitmapFromNV21(byte[] nv21, int width, int height) {
        int yStride = width + 15 & 0xFFFFFFF0;
        int[] image = new int[width * height];
        int h2 = height >> 1;
        for (int y = 0; y < h2; ++y) {
            int yOffs = (y << 1) * yStride;
            int vuOffs = (height + y) * yStride;
            int oOffs = (y << 1) * width;
            for (int x = 0; x < width; x += 2) {
                int v2 = (nv21[vuOffs + x] & 0xFF) - 128;
                int u2 = (nv21[vuOffs + x + 1] & 0xFF) - 128;
                int r0 = 91880 * v2;
                int g0 = 22553 * u2 + 46802 * v2;
                int b0 = 116130 * u2;
                int yOffsX = yOffs + x;
                int l00 = 256 + (nv21[yOffsX] & 0xFF) << 16;
                int l10 = 256 + (nv21[yOffsX + 1] & 0xFF) << 16;
                int l01 = 256 + (nv21[yOffsX + yStride] & 0xFF) << 16;
                int l11 = 256 + (nv21[yOffsX + yStride + 1] & 0xFF) << 16;
                int oOffsX = oOffs + x;
                image[oOffsX] = COLOR_CLAMP_RED[l00 + r0 >> 16] | COLOR_CLAMP_GREEN[l00 - g0 >> 16] | COLOR_CLAMP_BLUE[l00 + b0 >> 16];
                image[oOffsX + 1] = COLOR_CLAMP_RED[l10 + r0 >> 16] | COLOR_CLAMP_GREEN[l10 - g0 >> 16] | COLOR_CLAMP_BLUE[l10 + b0 >> 16];
                image[oOffsX + width] = COLOR_CLAMP_RED[l01 + r0 >> 16] | COLOR_CLAMP_GREEN[l01 - g0 >> 16] | COLOR_CLAMP_BLUE[l01 + b0 >> 16];
                image[oOffsX + width + 1] = COLOR_CLAMP_RED[l11 + r0 >> 16] | COLOR_CLAMP_GREEN[l11 - g0 >> 16] | COLOR_CLAMP_BLUE[l11 + b0 >> 16];
            }
        }
        return Bitmap.createBitmap((int[])image, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    private static native long ctor(String var0);

    static native void dtor(long var0);

    private static native void resetPolygonHistory(long var0);

    private static native List<Point> getPolygon(long var0);

    private static native List<PointF> getPolygonF(long var0);

    private static native double getDetectionScore(long var0);

    private static native DetectionResult detectNV21(long var0, byte[] var2, int var3, int var4);

    private static native DetectionResult detect(long var0, Bitmap var2);

    private static native Bitmap processImage(long var0, Bitmap var2, List<Point> var3, int var4);

    private static native Bitmap processImageF(long var0, Bitmap var2, List<PointF> var3, int var4);

    private static native Bitmap processImageAndScale(long var0, byte[] var2, List<PointF> var3, int var4, int var5);

    private static native Bitmap processImageAndRelease(long var0, Bitmap var2, List<PointF> var3, int var4);

    private static native List<Line2D> getVerticalLines(long var0);

    private static native List<Line2D> getHorizontalLines(long var0);

    private static native void setAcceptedSizeScore(long var0, double var2);

    private static native void setAcceptedAngleScore(long var0, double var2);

    private static native void setRequiredAspectRatios(long var0, List<PageAspectRatio> var2);

    private static native void setRectOfInterest(long var0, double var2, double var4, double var6, double var8);

    private static native void registerNatives();

    static {
        for (int i = -256; i < 512; ++i) {
            int v = i < 0 ? 0 : (i > 255 ? 255 : i);
            ContourDetector.COLOR_CLAMP_RED[i + 256] = 0xFF000000 | v << 16;
            ContourDetector.COLOR_CLAMP_GREEN[i + 256] = v << 8;
            ContourDetector.COLOR_CLAMP_BLUE[i + 256] = v;
        }
    }

    public static enum Type {
        EDGE_BASED,
        ML_BASED;

    }

    private static final class ContourDetectorDisposer
    implements Disposable {
        private final long ptr;

        public ContourDetectorDisposer(long ptr) {
            this.ptr = ptr;
        }

        @Override
        public void dispose() {
            ContourDetector.dtor(this.ptr);
        }
    }
}

