/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.core.contourdetector;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import androidx.annotation.RestrictTo;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.core.contourdetector.Line2D;
import io.scanbot.sdk.core.contourdetector.PageAspectRatio;
import io.scanbot.sdk.dispose.Disposable;
import io.scanbot.sdk.dispose.Disposer;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 92\u00020\u0001:\u00039:;B\u0011\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#J\u0019\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0082 J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0003J)\u0010'\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0082 J\b\u0010(\u001a\u00020)H\u0016J\u0011\u0010*\u001a\u00020)2\u0006\u0010%\u001a\u00020\u0011H\u0086 J\u0011\u0010\u0007\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0011H\u0082 J\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010%\u001a\u00020\u0011H\u0082 J\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010%\u001a\u00020\u0011H\u0082 J\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\f2\u0006\u0010%\u001a\u00020\u0011H\u0082 J\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010%\u001a\u00020\u0011H\u0082 J\u0006\u0010+\u001a\u00020)J\u0011\u0010+\u001a\u00020)2\u0006\u0010%\u001a\u00020\u0011H\u0082 J\u000e\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0006J\u0019\u0010,\u001a\u00020)2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0006H\u0082 J\u000e\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020\u0006J\u0019\u0010.\u001a\u00020)2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u0006H\u0082 J\u000e\u00100\u001a\u00020)2\u0006\u00101\u001a\u000202J1\u00100\u001a\u00020)2\u0006\u0010%\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006H\u0082 J\u001f\u00105\u001a\u00020)2\u0006\u0010%\u001a\u00020\u00112\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\fH\u0082 J\u0014\u00105\u001a\u00020)2\f\u00108\u001a\b\u0012\u0004\u0012\u0002070\fR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000fR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000f\u00a8\u0006<"}, d2={"Lio/scanbot/sdk/core/contourdetector/ContourDetector;", "Lio/scanbot/sdk/dispose/Disposable;", "modelPath", "", "(Ljava/lang/String;)V", "detectionScore", "", "getDetectionScore", "()D", "disposer", "Lio/scanbot/sdk/dispose/Disposer;", "horizontalLines", "", "Lio/scanbot/sdk/core/contourdetector/Line2D;", "getHorizontalLines", "()Ljava/util/List;", "pointer", "", "polygon", "Landroid/graphics/Point;", "getPolygon", "polygonF", "Landroid/graphics/PointF;", "getPolygonF", "verticalLines", "getVerticalLines", "ctor", "detect", "Lio/scanbot/sdk/core/contourdetector/DetectionResult;", "bitmap", "Landroid/graphics/Bitmap;", "data", "", "nv21", "width", "", "height", "ptr", "fileName", "detectNV21", "dispose", "", "dtor", "resetPolygonHistory", "setAcceptedAngleScore", "acceptedAngleScore", "setAcceptedSizeScore", "acceptedSizeScore", "setRectOfInterest", "rectOfInterest", "Landroid/graphics/RectF;", "x", "y", "setRequiredAspectRatios", "requiredAspectRatios", "Lio/scanbot/sdk/core/contourdetector/PageAspectRatio;", "requiredPageAspectRatios", "Companion", "ContourDetectorDisposer", "Type", "core-imageprocessing_release"})
public final class ContourDetector
implements Disposable {
    private final Disposer disposer;
    private final long pointer;
    public static final int IMAGE_FILTER_NONE = 0;
    public static final int IMAGE_FILTER_COLOR_ENHANCED = 1;
    public static final int IMAGE_FILTER_GRAY = 2;
    public static final int IMAGE_FILTER_BINARIZED = 3;
    public static final int IMAGE_FILTER_COLOR_DOCUMENT = 4;
    public static final int IMAGE_FILTER_PURE_BINARIZED = 11;
    public static final int IMAGE_FILTER_BACKGROUND_CLEAN = 13;
    public static final int IMAGE_FILTER_BLACK_AND_WHITE = 14;
    public static final int IMAGE_FILTER_OTSU_BINARIZATION = 15;
    public static final int IMAGE_FILTER_DEEP_BINARIZATION = 16;
    public static final int IMAGE_FILTER_EDGE_HIGHLIGHT = 17;
    public static final int IMAGE_FILTER_LOW_LIGHT_BINARIZATION = 18;
    public static final int IMAGE_FILTER_LOW_LIGHT_BINARIZATION_2 = 19;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final DetectionResult detect(@NotNull byte[] nv21, int width, int height) {
        Intrinsics.checkParameterIsNotNull((Object)nv21, (String)"nv21");
        return this.detectNV21(this.pointer, nv21, width, height);
    }

    @NotNull
    public final DetectionResult detect(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Bitmap bitmap = Companion.createBitmapFromEncodedData(data);
        DetectionResult ret = this.detect(this.pointer, bitmap);
        bitmap.recycle();
        return ret;
    }

    @NotNull
    public final DetectionResult detect(@NotNull String fileName) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Bitmap bitmap = Companion.createBitmapFromEncodedFile(fileName);
        DetectionResult ret = this.detect(this.pointer, bitmap);
        bitmap.recycle();
        return ret;
    }

    @NotNull
    public final DetectionResult detect(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        return this.detect(this.pointer, bitmap);
    }

    @NotNull
    public final List<Point> getPolygon() {
        return this.getPolygon(this.pointer);
    }

    @NotNull
    public final List<PointF> getPolygonF() {
        return this.getPolygonF(this.pointer);
    }

    public final double getDetectionScore() {
        return this.getDetectionScore(this.pointer);
    }

    @NotNull
    public final List<Line2D> getVerticalLines() {
        return this.getVerticalLines(this.pointer);
    }

    @NotNull
    public final List<Line2D> getHorizontalLines() {
        return this.getHorizontalLines(this.pointer);
    }

    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        this.setAcceptedAngleScore(this.pointer, acceptedAngleScore);
    }

    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        this.setAcceptedSizeScore(this.pointer, acceptedSizeScore);
    }

    public final void setRequiredAspectRatios(@NotNull List<PageAspectRatio> requiredPageAspectRatios) {
        Intrinsics.checkParameterIsNotNull(requiredPageAspectRatios, (String)"requiredPageAspectRatios");
        this.setRequiredAspectRatios(this.pointer, requiredPageAspectRatios);
    }

    public final void setRectOfInterest(@NotNull RectF rectOfInterest) {
        Intrinsics.checkParameterIsNotNull((Object)rectOfInterest, (String)"rectOfInterest");
        this.setRectOfInterest(this.pointer, rectOfInterest.left, rectOfInterest.top, rectOfInterest.width(), rectOfInterest.height());
    }

    public final void resetPolygonHistory() {
        this.resetPolygonHistory(this.pointer);
    }

    @Override
    public void dispose() {
        this.disposer.dispose();
    }

    private final native long ctor(String var1);

    public final native void dtor(long var1);

    private final native void resetPolygonHistory(long var1);

    private final native List<Point> getPolygon(long var1);

    private final native List<PointF> getPolygonF(long var1);

    private final native double getDetectionScore(long var1);

    private final native DetectionResult detectNV21(long var1, byte[] var3, int var4, int var5);

    private final native DetectionResult detect(long var1, Bitmap var3);

    private final native List<Line2D> getVerticalLines(long var1);

    private final native List<Line2D> getHorizontalLines(long var1);

    private final native void setAcceptedSizeScore(long var1, double var3);

    private final native void setAcceptedAngleScore(long var1, double var3);

    private final native void setRequiredAspectRatios(long var1, List<PageAspectRatio> var3);

    private final native void setRectOfInterest(long var1, double var3, double var5, double var7, double var9);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public ContourDetector(@Nullable String modelPath) {
        String string = modelPath;
        if (string == null) {
            string = "";
        }
        this.pointer = this.ctor(string);
        this.disposer = new Disposer(this, new ContourDetectorDisposer(this.pointer));
        boolean bl = this.pointer != 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Failed to create native resources.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
    }

    @JvmStatic
    @NotNull
    public static final Bitmap createBitmapFromEncodedData(@NotNull byte[] data) {
        return Companion.createBitmapFromEncodedData(data);
    }

    @JvmStatic
    @NotNull
    public static final Bitmap createBitmapFromEncodedFile(@Nullable String fileName) throws IOException {
        return Companion.createBitmapFromEncodedFile(fileName);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/core/contourdetector/ContourDetector$ContourDetectorDisposer;", "Lio/scanbot/sdk/dispose/Disposable;", "ptr", "", "(Lio/scanbot/sdk/core/contourdetector/ContourDetector;J)V", "dispose", "", "core-imageprocessing_release"})
    private final class ContourDetectorDisposer
    implements Disposable {
        private final long ptr;

        @Override
        public void dispose() {
            ContourDetector.this.dtor(this.ptr);
        }

        public ContourDetectorDisposer(long ptr) {
            this.ptr = ptr;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/core/contourdetector/ContourDetector$Type;", "", "(Ljava/lang/String;I)V", "EDGE_BASED", "ML_BASED", "core-imageprocessing_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type EDGE_BASED;
        public static final /* enum */ Type ML_BASED;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[2];
            Type[] typeArray2 = typeArray;
            typeArray[0] = EDGE_BASED = new Type();
            typeArray[1] = ML_BASED = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/scanbot/sdk/core/contourdetector/ContourDetector$Companion;", "", "()V", "IMAGE_FILTER_BACKGROUND_CLEAN", "", "IMAGE_FILTER_BINARIZED", "IMAGE_FILTER_BLACK_AND_WHITE", "IMAGE_FILTER_COLOR_DOCUMENT", "IMAGE_FILTER_COLOR_ENHANCED", "IMAGE_FILTER_DEEP_BINARIZATION", "IMAGE_FILTER_EDGE_HIGHLIGHT", "IMAGE_FILTER_GRAY", "IMAGE_FILTER_LOW_LIGHT_BINARIZATION", "IMAGE_FILTER_LOW_LIGHT_BINARIZATION_2", "IMAGE_FILTER_NONE", "IMAGE_FILTER_OTSU_BINARIZATION", "IMAGE_FILTER_PURE_BINARIZED", "createBitmapFromEncodedData", "Landroid/graphics/Bitmap;", "data", "", "createBitmapFromEncodedFile", "fileName", "", "core-imageprocessing_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Bitmap createBitmapFromEncodedData(@NotNull byte[] data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inDither = false;
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapFactory.decodeByte\u2026a, 0, data.size, options)");
            return bitmap;
        }

        @JvmStatic
        @NotNull
        public final Bitmap createBitmapFromEncodedFile(@Nullable String fileName) throws IOException {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inDither = false;
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            Bitmap bitmap = BitmapFactory.decodeFile((String)fileName, (BitmapFactory.Options)options);
            if (bitmap == null) {
                throw (Throwable)new IOException("Can't open Bitmap");
            }
            return bitmap;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

