/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.dispose;

import io.scanbot.sdk.dispose.Disposable;
import io.scanbot.sdk.dispose.ReferenceList;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class Disposer
extends WeakReference<Object> {
    private final Disposable disposable;
    private final ReferenceList.Node<Disposer> disposer;
    private volatile boolean disposed = false;
    private static final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private static final ReferenceList<Disposer> disposers = new ReferenceList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Disposer(Object referent, Disposable disposable) {
        super(referent, refQueue);
        this.disposable = disposable;
        ReferenceList<Disposer> referenceList = disposers;
        synchronized (referenceList) {
            this.disposer = disposers.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (!this.disposed) {
            ReferenceList<Disposer> referenceList = disposers;
            synchronized (referenceList) {
                disposers.remove(this.disposer);
            }
            this.disposed = true;
            this.disposable.dispose();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    static {
        Thread thread = new Thread(new Cleaner());
        thread.setName("Disposer-Thread");
        thread.setDaemon(true);
        thread.start();
    }

    private static final class Cleaner
    implements Runnable {
        private Cleaner() {
        }

        @Override
        public void run() {
            ReferenceQueue refQueue = refQueue;
            while (true) {
                try {
                    while (true) {
                        ((Disposer)refQueue.remove()).dispose();
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    }
}

