/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.textorientation;

import android.graphics.Bitmap;
import android.util.Log;
import io.scanbot.textorientation.model.TextOrientation;

public class TextOrientationRecognizer {
    public TextOrientationRecognizer(String tessDataPath) {
        TextOrientationRecognizer.ctor(tessDataPath);
    }

    private static native void ctor(String var0);

    private static native int recognizeBitmapNative(Bitmap var0, float var1);

    private static native int recognizeJPEGNative(byte[] var0, int var1, int var2, float var3);

    /*
     * WARNING - void declaration
     */
    public TextOrientation recognizeJPEG(byte[] jpeg, int width, int height, float requestedConfidence) {
        TextOrientation textOrientation;
        long l = System.currentTimeMillis();
        try {
            void var4_7;
            void var3_6;
            void var2_3;
            textOrientation = TextOrientation.getByCode(TextOrientationRecognizer.recognizeJPEGNative(jpeg, (int)var2_3, (int)var3_6, (float)var4_7));
        }
        catch (Throwable throwable) {
            long l2 = System.currentTimeMillis();
            Log.d((String)"TextOrientation", (String)("Total recognition time (sec): " + (float)(l2 - l) / 1000.0f));
            throw throwable;
        }
        long l3 = System.currentTimeMillis();
        Log.d((String)"TextOrientation", (String)("Total recognition time (sec): " + (float)(l3 - l) / 1000.0f));
        return textOrientation;
    }

    /*
     * WARNING - void declaration
     */
    public TextOrientation recognizeBitmap(Bitmap bitmap, float requestedConfidence) {
        TextOrientation textOrientation;
        long l = System.currentTimeMillis();
        try {
            void var2_3;
            textOrientation = TextOrientation.getByCode(TextOrientationRecognizer.recognizeBitmapNative(bitmap, (float)var2_3));
        }
        catch (Throwable throwable) {
            long l2 = System.currentTimeMillis();
            Log.d((String)"TextOrientation", (String)("Total recognition time (sec): " + (float)(l2 - l) / 1000.0f));
            throw throwable;
        }
        long l3 = System.currentTimeMillis();
        Log.d((String)"TextOrientation", (String)("Total recognition time (sec): " + (float)(l3 - l) / 1000.0f));
        return textOrientation;
    }
}

