/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.mrzscanner.model;

import io.scanbot.mrzscanner.model.MRZDocumentType;

public class MRZRecognitionResult {
    public final boolean recognitionSuccessful;
    public final String documentCode;
    public final String firstName;
    public final String lastName;
    public final String issuingStateOrOrganization;
    public final String departmentOfIssuance;
    public final String nationality;
    public final String dateOfBirth;
    public final String gender;
    public final String dateOfExpiry;
    public final String personalNumber;
    public final String optional1;
    public final String optional2;
    public final String discreetIssuingStateOrOrganization;
    public final int validCheckDigitsCount;
    public final int checkDigitsCount;
    public final MRZDocumentType travelDocType;

    public MRZRecognitionResult(String documentCode, String firstName, String lastName, String issuingStateOrOrganization, String departmentOfIssuance, String nationality, String dateOfBirth, String gender, String dateOfExpiry, String personalNumber, String optional1, String optional2, String discreetIssuingStateOrOrganization, int validCheckDigitsCount, int checkDigitsCount, int travelDocTypeValue, boolean recognitionSuccessful) {
        this.documentCode = documentCode;
        this.firstName = firstName;
        this.lastName = lastName;
        this.issuingStateOrOrganization = issuingStateOrOrganization;
        this.departmentOfIssuance = departmentOfIssuance;
        this.nationality = nationality;
        this.dateOfBirth = dateOfBirth;
        this.gender = gender;
        this.dateOfExpiry = dateOfExpiry;
        this.personalNumber = personalNumber;
        this.optional1 = optional1;
        this.optional2 = optional2;
        this.discreetIssuingStateOrOrganization = discreetIssuingStateOrOrganization;
        this.validCheckDigitsCount = validCheckDigitsCount;
        this.checkDigitsCount = checkDigitsCount;
        this.travelDocType = this.docTypeFromInt(travelDocTypeValue);
        this.recognitionSuccessful = recognitionSuccessful;
    }

    protected MRZDocumentType docTypeFromInt(int value) {
        switch (value) {
            case 0: {
                return MRZDocumentType.Passport;
            }
            case 1: {
                return MRZDocumentType.TravelDocument;
            }
            case 2: {
                return MRZDocumentType.Visa;
            }
            case 3: {
                return MRZDocumentType.IDCard;
            }
        }
        return MRZDocumentType.Undefined;
    }
}

