/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.tiffwriter;

import android.graphics.Bitmap;
import android.util.Log;
import java.util.List;

public class TIFFWriter {
    public TIFFWriter() {
        TIFFWriter.ctor();
    }

    public boolean writeSinglePageTIFFFromBitmap(Bitmap bitmap, String path) {
        boolean result = TIFFWriter.writeTIFF(bitmap, path);
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + path));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    public boolean writeSinglePageTIFFFromUri(String fileUri, String path) {
        boolean result = TIFFWriter.writeTIFFFromUri(fileUri, path);
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + path));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    public boolean writeMultiPageTIFFFromBitmapList(List<Bitmap> bitmaps, String path) {
        boolean result = TIFFWriter.writeTIFFMultiPage(bitmaps.toArray(new Bitmap[bitmaps.size()]), path);
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + path));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    public boolean writeMultiPageTIFFFromUriList(List<String> fileUris, String path) {
        boolean result = TIFFWriter.writeTIFFMultiPageFromUris(fileUris.toArray(new String[fileUris.size()]), path);
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + path));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    private static native void ctor();

    private static native boolean writeTIFF(Bitmap var0, String var1);

    private static native boolean writeTIFFFromUri(String var0, String var1);

    private static native boolean writeTIFFMultiPage(Bitmap[] var0, String var1);

    private static native boolean writeTIFFMultiPageFromUris(String[] var0, String var1);

    static {
        System.loadLibrary("scanbotsdk");
    }
}

