/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.tiffwriter;

import android.graphics.Bitmap;
import android.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TIFFWriter {
    public TIFFWriter() {
        TIFFWriter.ctor();
    }

    public boolean writeSinglePageTIFFFromBitmap(Bitmap bitmap, File targetFile) {
        boolean result = TIFFWriter.writeTIFF(bitmap, targetFile.getPath());
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + targetFile.getPath()));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    public boolean writeSinglePageTIFFFromFile(File sourceFile, File targetFile) {
        boolean result = TIFFWriter.writeTIFFFromFilePath(sourceFile.getPath(), targetFile.getPath());
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + targetFile.getPath()));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    public boolean writeMultiPageTIFFFromBitmapList(List<Bitmap> bitmaps, File targetFile) {
        boolean result = TIFFWriter.writeTIFFMultiPage(bitmaps.toArray(new Bitmap[bitmaps.size()]), targetFile.getPath());
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + targetFile.getPath()));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    public boolean writeMultiPageTIFFFromFileList(List<File> sourceFiles, File targetFile) {
        ArrayList<String> sourcePaths = new ArrayList<String>();
        for (File sourceFile : sourceFiles) {
            sourcePaths.add(sourceFile.getPath());
        }
        boolean result = TIFFWriter.writeTIFFMultiPageFromFilePaths(sourcePaths.toArray(new String[sourcePaths.size()]), targetFile.getPath());
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + targetFile.getPath()));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    private static native void ctor();

    private static native boolean writeTIFF(Bitmap var0, String var1);

    private static native boolean writeTIFFFromFilePath(String var0, String var1);

    private static native boolean writeTIFFMultiPage(Bitmap[] var0, String var1);

    private static native boolean writeTIFFMultiPageFromFilePaths(String[] var0, String var1);

    static {
        System.loadLibrary("scanbotsdk");
    }
}

