/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.mrzscanner;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.Log;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;

public class MRZRecognizer {
    public MRZRecognizer(String tessDataPath) {
        MRZRecognizer.ctor(tessDataPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MRZRecognitionResult recognizeMRZ(byte[] nv21, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            MRZRecognitionResult mRZRecognitionResult = MRZRecognizer.recognize(nv21, width, height, orientation);
            return mRZRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"MRZRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MRZRecognitionResult recognizeMRZBGR(byte[] bgr, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            MRZRecognitionResult mRZRecognitionResult = MRZRecognizer.recognizeBGR(bgr, width, height, orientation);
            return mRZRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"MRZRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MRZRecognitionResult recognizeMRZJPEG(byte[] jpeg, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            MRZRecognitionResult mRZRecognitionResult = MRZRecognizer.recognizeJPEG(jpeg, width, height, orientation);
            return mRZRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"MRZRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MRZRecognitionResult recognizeMRZBitmap(Bitmap bitmap, int orientation) {
        long a = System.currentTimeMillis();
        try {
            MRZRecognitionResult mRZRecognitionResult = MRZRecognizer.recognizeBitmap(bitmap, orientation);
            return mRZRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"MRZRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MRZRecognitionResult recognizeInAreaNV21(byte[] nv21, int width, int height, int orientation, Rect areaRect) {
        long a = System.currentTimeMillis();
        try {
            MRZRecognitionResult mRZRecognitionResult = MRZRecognizer.recognizeInAreaNV21(nv21, width, height, orientation, areaRect.left, areaRect.top, areaRect.width(), areaRect.height());
            return mRZRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"MRZRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    private static native void ctor(String var0);

    private static native MRZRecognitionResult recognize(byte[] var0, int var1, int var2, int var3);

    private static native MRZRecognitionResult recognizeBGR(byte[] var0, int var1, int var2, int var3);

    private static native MRZRecognitionResult recognizeJPEG(byte[] var0, int var1, int var2, int var3);

    private static native MRZRecognitionResult recognizeBitmap(Bitmap var0, int var1);

    private static native MRZRecognitionResult recognizeInAreaNV21(byte[] var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("tess");
        System.loadLibrary("scanbotsdk");
    }
}

