/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.mrzscanner.model;

import io.scanbot.mrzscanner.model.MRZDocumentType;
import io.scanbot.mrzscanner.model.MRZField;
import io.scanbot.mrzscanner.model.MRZFieldName;
import io.scanbot.mrzscanner.model.MRZTextRecognitionResult;
import java.util.List;
import java.util.ListIterator;

public class MRZRecognitionResult {
    public final boolean recognitionSuccessful;
    public final List<MRZField> fields;
    public final int validCheckDigitsCount;
    public final int checkDigitsCount;
    public final MRZDocumentType travelDocType;
    public final List<MRZTextRecognitionResult> recognizedMRZLines;

    public MRZRecognitionResult(List<MRZField> fields, int validCheckDigitsCount, int checkDigitsCount, int travelDocTypeValue, boolean recognitionSuccessful, List<MRZTextRecognitionResult> recognizedMRZLines) {
        this.fields = fields;
        this.validCheckDigitsCount = validCheckDigitsCount;
        this.checkDigitsCount = checkDigitsCount;
        this.travelDocType = this.docTypeFromInt(travelDocTypeValue);
        this.recognitionSuccessful = recognitionSuccessful;
        this.recognizedMRZLines = recognizedMRZLines;
    }

    protected MRZDocumentType docTypeFromInt(int value) {
        switch (value) {
            case 0: {
                return MRZDocumentType.Passport;
            }
            case 1: {
                return MRZDocumentType.TravelDocument;
            }
            case 2: {
                return MRZDocumentType.Visa;
            }
            case 3: {
                return MRZDocumentType.IDCard;
            }
        }
        return MRZDocumentType.Undefined;
    }

    public MRZField fieldByName(MRZFieldName name) {
        ListIterator<MRZField> it = this.fields.listIterator();
        while (it.hasNext()) {
            MRZField field = it.next();
            if (field.name != name) continue;
            return field;
        }
        return null;
    }

    public String documentCode() {
        return this.fieldByName((MRZFieldName)MRZFieldName.DocumentCode).value;
    }

    public String issuingStateOrOrganization() {
        return this.fieldByName((MRZFieldName)MRZFieldName.IssuingStateOrOrganization).value;
    }

    public String departmentOfIssuance() {
        return this.fieldByName((MRZFieldName)MRZFieldName.DepartmentOfIssuance).value;
    }

    public String firstName() {
        return this.fieldByName((MRZFieldName)MRZFieldName.FirstName).value;
    }

    public String lastName() {
        return this.fieldByName((MRZFieldName)MRZFieldName.LastName).value;
    }

    public String nationality() {
        return this.fieldByName((MRZFieldName)MRZFieldName.Nationality).value;
    }

    public String dateOfBirth() {
        return this.fieldByName((MRZFieldName)MRZFieldName.DateOfBirth).value;
    }

    public String gender() {
        return this.fieldByName((MRZFieldName)MRZFieldName.Gender).value;
    }

    public String dateOfExpiry() {
        return this.fieldByName((MRZFieldName)MRZFieldName.DateOfExpiry).value;
    }

    public String personalNumber() {
        return this.fieldByName((MRZFieldName)MRZFieldName.PersonalNumber).value;
    }

    public String travelDocType() {
        return this.fieldByName((MRZFieldName)MRZFieldName.TravelDocType).value;
    }

    public String optional1() {
        return this.fieldByName((MRZFieldName)MRZFieldName.Optional1).value;
    }

    public String optional2() {
        return this.fieldByName((MRZFieldName)MRZFieldName.Optional2).value;
    }

    public String discreetIssuingStateOrOrganization() {
        return this.fieldByName((MRZFieldName)MRZFieldName.DiscreetIssuingStateOrOrganization).value;
    }
}

