/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.mrzscanner.model;

import io.scanbot.mrzscanner.model.MRZFieldName;

public class MRZField {
    public final String value;
    public final double averageRecognitionConfidence;
    public final MRZFieldName name;

    public MRZField(MRZFieldName name) {
        this.name = name;
        this.value = "";
        this.averageRecognitionConfidence = 0.0;
    }

    public MRZField(int name, String value, double confidenceValue) {
        this.name = this.fieldNameFromInt(name);
        this.value = value;
        this.averageRecognitionConfidence = confidenceValue;
    }

    protected MRZFieldName fieldNameFromInt(int value) {
        switch (value) {
            case 1: {
                return MRZFieldName.DocumentCode;
            }
            case 2: {
                return MRZFieldName.IssuingStateOrOrganization;
            }
            case 3: {
                return MRZFieldName.DepartmentOfIssuance;
            }
            case 4: {
                return MRZFieldName.FirstName;
            }
            case 5: {
                return MRZFieldName.LastName;
            }
            case 6: {
                return MRZFieldName.Nationality;
            }
            case 7: {
                return MRZFieldName.DateOfBirth;
            }
            case 8: {
                return MRZFieldName.Gender;
            }
            case 9: {
                return MRZFieldName.DateOfExpiry;
            }
            case 10: {
                return MRZFieldName.PersonalNumber;
            }
            case 11: {
                return MRZFieldName.TravelDocType;
            }
            case 12: {
                return MRZFieldName.Optional1;
            }
            case 13: {
                return MRZFieldName.Optional2;
            }
            case 14: {
                return MRZFieldName.DiscreetIssuingStateOrOrganization;
            }
        }
        return MRZFieldName.Unknown;
    }
}

